unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, MBMRU, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    MbMRUList1: TMbMRUList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    PrintSetup1: TMenuItem;
    Print1: TMenuItem;
    N2: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    New1: TMenuItem;
    Reopen1: TMenuItem;
    MRUOptions1: TMenuItem;
    ClearMRUList1: TMenuItem;
    Display1: TMenuItem;
    FullPath1: TMenuItem;
    FileOnly1: TMenuItem;
    AbbPath1: TMenuItem;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    procedure MRUOptions1Click(Sender: TObject);
    procedure ClearMRUList1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure MbMRUList1MRUClick(Sender: TObject; MenuItem: TMenuItem;
      const FileName: String; MRUIndex: Integer; var CanDelete: Boolean);
    procedure FullPath1Click(Sender: TObject);
    procedure FileOnly1Click(Sender: TObject);
    procedure AbbPath1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.MRUOptions1Click(Sender: TObject);
begin
 ClearMRUList1.Enabled:=MbMRUList1.MRUCount > 0;
end;

procedure TForm1.ClearMRUList1Click(Sender: TObject);
begin
 MbMRUList1.MRUClear;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
 begin
  Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
  MbMRUList1.MRUAdd(OpenDialog1.FileName);
  StatusBar1.SimpleText:=OpenDialog1.FileName;
 end;
end;

procedure TForm1.MbMRUList1MRUClick(Sender: TObject; MenuItem: TMenuItem;
  const FileName: String; MRUIndex: Integer; var CanDelete: Boolean);
begin
 Memo1.Lines.LoadFromFile(FileName);
 StatusBar1.SimpleText:=FileName;
end;

procedure TForm1.FullPath1Click(Sender: TObject);
begin
 FullPath1.Checked:=true;
 MbMRUList1.MRUDisplay:=mdFullPath;
end;

procedure TForm1.FileOnly1Click(Sender: TObject);
begin
 FileOnly1.Checked:=true;
 MbMRUList1.MRUDisplay:=mdFileOnly;
end;

procedure TForm1.AbbPath1Click(Sender: TObject);
begin
 AbbPath1.Checked:=true;
 MbMRUList1.MRUDisplay:=mdAbbPath;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
 Close;
end;

end.
