unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, mpeg, ComCtrls;

type
  TFormMpeg = class(TForm)
    Memo: TMemo;
    gbSettings: TGroupBox;
    tbQuant: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    gbMovie: TGroupBox;
    cbMjpeg: TCheckBox;
    butMovie: TButton;
    gbSlide: TGroupBox;
    butSlide: TButton;
    procedure butSlideClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butMovieClick(Sender: TObject);
  private
    mpg: TMpeg;
  public
    function CheckImages: boolean;
  end;

var
  FormMpeg: TFormMpeg;

implementation

{$R *.DFM}

const QUANTCODE: array[0..7] of integer = (1,2,3,4,6,8,12,16);


procedure TFormMpeg.FormCreate(Sender: TObject);
begin
   mpg := TMpeg.Create;
end;

procedure TFormMpeg.FormDestroy(Sender: TObject);
begin
   mpg.Free;
end;

function TFormMpeg.CheckImages: boolean;
begin
   result := FileExists('fran101.bmp') and FileExists('slide01.bmp');
   if not result
      then MessageDlg('Cannot find the demo images',mtError,[mbOK],0);
end;

procedure TFormMpeg.butSlideClick(Sender: TObject);
var
 i: integer;
 fs: TFileStream;
 bm: TBitmap;
begin
   if not CheckImages then exit;

   // Initalization - Create a MPEG stream 400x96 pixels, base frequency
   // is 24 hz but it will be divided by 48 to provide 0.5 hz (one image
   // every 2 seconds). [The demo version has Height fixed to 96];

   bm := TBitmap.Create;
   fs := TFileStream.Create('slide.mpg',fmcreate);
   mpg.Open(400,96,QUANTCODE[tbQuant.Position],2000,bf24hz,fs);

   for i := 1 to 3 do begin
       bm.LoadFromFile('slide0' + inttostr(i) + '.bmp');
       mpg.AddIImage(bm);
       mpg.Keep(24*2-1);  // Keep the frame for 2 seconds.
   end;

   mpg.Close;     // Closes the stream and flush the buffers
   fs.Free;
   bm.Free;
   ShowMessage('OK. File "Slide.mpg" created');
end;

procedure TFormMpeg.butMovieClick(Sender: TObject);
var
 i: integer;
 fs: TFileStream;
 bm: TBitmap;
begin
   if not CheckImages then exit;

   // Initalization - Create a MPEG stream 112x96 pixels, base frequency
   // is 24 hz but it will be divided by 4 to obtain 6 frames per second.

   bm := TBitmap.Create;
   fs := TFileStream.Create('movie.mpg',fmcreate);
   mpg.Open(112,96,QUANTCODE[tbQuant.Position],2000,bf24hz,fs);

   for i := 1 to 6 do begin
       bm.LoadFromFile('fran10' + inttostr(i) + '.bmp');
       if (i = 1) or cbMjpeg.checked     // Mjpeg brings worse compression
          then mpg.AddIImage(bm)
          else mpg.AddPImage(bm);
       mpg.Keep(4-1);  // Keep the frame to divide the frequency by 4.
   end;

   mpg.Close;     // Closes the stream and flush the buffers
   fs.Free;
   bm.Free;
   ShowMessage('OK. File "movie.mpg" created');
end;


end.
