unit unMain;

interface

uses
  Windows, SysUtils, Classes,  Controls, Forms, Dialogs,
  Buttons, StdCtrls, Spin, ComCtrls, ExtCtrls, MP3RemoteI;

type
  TForm1 = class(TForm)
    Status: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    RadioG: TRadioGroup;
    se1: TSpinEdit;
    se2: TSpinEdit;
    Label4: TLabel;
    Label5: TLabel;
    cb1: TCheckBox;
    Edit1: TEdit;
    Label6: TLabel;
    EQ: TTabSheet;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    TabSheet4: TTabSheet;
    Edit2: TEdit;
    Label11: TLabel;
    Label12: TLabel;
    Button7: TButton;
    Button8: TButton;
    Edit3: TEdit;
    Button9: TButton;
    Label14: TLabel;
    Button10: TButton;
    SpinEdit1: TSpinEdit;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Label16: TLabel;
    Label17: TLabel;
    Button15: TButton;
    Label15: TLabel;
    od: TOpenDialog;
    TabSheet5: TTabSheet;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    Label3: TLabel;
    SpeedButton7: TSpeedButton;
    SpeedButton6: TSpeedButton;
    Label7: TLabel;
    Label13: TLabel;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    btStart: TButton;
    ProgressBar1: TProgressBar;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    lAlt: TLabel;
    lCtrl: TLabel;
    lShift: TLabel;
    Timer1: TTimer;
    Memo1: TMemo;
    Button11: TButton;
    TabSheet6: TTabSheet;
    RadioGroup1: TRadioGroup;
    CountDown: TCheckBox;
    Button16: TButton;
    Label18: TLabel;
    Button17: TButton;
    Button18: TButton;
    SpeedButton10: TSpeedButton;
    TabSheet7: TTabSheet;
    Label19: TLabel;
    SpinEdit2: TSpinEdit;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    TabSheet8: TTabSheet;
    Memo2: TMemo;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Button19: TButton;
    Button20: TButton;
    Label30: TLabel;
    GroupBox2: TGroupBox;
    Label31: TLabel;
    eqOn: TCheckBox;
    eqAuto: TCheckBox;
    eq10: TScrollBar;
    Label32: TLabel;
    eq0: TScrollBar;
    eq1: TScrollBar;
    eq2: TScrollBar;
    eq3: TScrollBar;
    eq7: TScrollBar;
    eq4: TScrollBar;
    eq5: TScrollBar;
    eq6: TScrollBar;
    eq8: TScrollBar;
    eq9: TScrollBar;
    stereo: TLabel;
    srate: TLabel;
    brate: TLabel;
    Edit4: TEdit;
    Button21: TButton;
    ListBox1: TListBox;
    Button22: TButton;
    Label33: TLabel;
    Edit5: TEdit;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Button23: TButton;
    Label37: TLabel;
    OD2: TOpenDialog;
    Button25: TButton;
    Panel3: TPanel;
    Image2: TImage;
    Label38: TLabel;
    Label39: TLabel;
    TabSheet3: TTabSheet;
    Label41: TLabel;
    Button30: TButton;
    Button31: TButton;
    Button32: TButton;
    Button33: TButton;
    Button34: TButton;
    Button35: TButton;
    Button36: TButton;
    cbShuffle: TCheckBox;
    cbRepeat: TCheckBox;
    Label42: TLabel;
    cbTimeRem: TCheckBox;
    Button24: TButton;
    Button26: TButton;
    Button27: TButton;
    Button28: TButton;
    Button29: TButton;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure btStartClick(Sender: TObject);
    procedure ProgressBar1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure cb1Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure se1Change(Sender: TObject);
    procedure RadioGClick(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure ProgressBar1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ProgressBar1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button11Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure SpeedButton10Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure eqOnClick(Sender: TObject);
    procedure eqAutoClick(Sender: TObject);
    procedure eq9Scroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure Button22Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button23Click(Sender: TObject);
    procedure Button25Click(Sender: TObject);
    procedure Label38Click(Sender: TObject);
    procedure Button24Click(Sender: TObject);
    procedure Button26Click(Sender: TObject);
    procedure Button27Click(Sender: TObject);
    procedure Button28Click(Sender: TObject);
    procedure Button29Click(Sender: TObject);
    procedure Button30Click(Sender: TObject);
    procedure Button31Click(Sender: TObject);
    procedure Button32Click(Sender: TObject);
    procedure Button33Click(Sender: TObject);
    procedure Button34Click(Sender: TObject);
    procedure Button35Click(Sender: TObject);
    procedure Button36Click(Sender: TObject);
    procedure cbShuffleClick(Sender: TObject);
    procedure cbRepeatClick(Sender: TObject);
    procedure cbTimeRemClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
     Scrolling   : Boolean;
     aOutPutType : TOutPutType;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses unAbout, ShellApi;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
 S : PChar;
begin
   aOutPutType:=osh_M_S_ms;

   // This had to be done like this for compatibility with VB
   GetMem(S,256);
    MP3RemoteI.GetWinampDir(S,255);
    Edit5.Text:=S;
   FreeMem(S,256);


end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
Var
 KeyType : TKeyType;
begin

 IF ShiftDown then KeyType:=ktShift else
   If CtrlDown then KeyType:=ktCtrl else
     KeyType:=ktNone;
 IF Sender is TSpeedButton then
   // Simulates pressing one of the 5 main buttons on winamp
   MP3RemoteI.PressButton(TSpeedButton(Sender).Tag,KeyType);

end;

procedure TForm1.Timer1Timer(Sender: TObject);

procedure UpDateWinInfo;
Var
 P : tpoint;
 s : PChar;

Begin

 GetAmpPos(p.x,p.y);
 se1.value:=p.x;
 se2.value:=p.y;

 // This had to be done like this for compatibility with VB
 GetMem(S,256);
  GetAmpCaption(s,255);
  edit1.Text:=String(S);
 FreeMem(S,256);


 cb1.Checked:=GetOnTop;

 case GetAmpWindowState of
  wsNormal    : RadioG.itemindex:=0;
  wsMinimized,wsMaximized : RadioG.itemindex:=1;
 end;

end;

Procedure UpdateAmp2;
Begin
 Label30.Caption:='Current Position: '+IntToStr(GetPlayListPos);
 Label20.Caption:='Playlist contains '+IntToStr(GetListLength)+' tracks';
End;

Procedure UpdateEQ;
Begin
  eqOn.Checked:=GetEQOn;
  eqAuto.Checked:=GetEQAutoLoad;

  eq10.Position:=GetEQ(10);  //Pre-Amp

  eq0.Position:=GetEQ(0);
  eq1.Position:=GetEQ(1);
  eq2.Position:=GetEQ(2);
  eq3.Position:=GetEQ(3);
  eq4.Position:=GetEQ(4);
  eq5.Position:=GetEQ(5);
  eq6.Position:=GetEQ(6);
  eq7.Position:=GetEQ(7);
  eq8.Position:=GetEQ(8);
  eq9.Position:=GetEQ(9);
End;

Var
 SongP  : Integer;
 S      : PChar;
begin
 IF GetStereo then
  Stereo.Caption:='Stereo'
 else Stereo.Caption:='Mono';
 brate.Caption:=IntToStr(GetBitRate)+' kbs';
 srate.Caption:=IntToStr(GetSampleRate)+' Khz';
 
 SongP:=GetSongPos;                 // Song position in millisecs
 progressbar1.Min:=0;
 progressbar1.Max:=ABS(GetSongLength);   // Song length in secs
 IF not Scrolling then
   progressbar1.position:=ABS(SongP div 1000); // Need to convert to secs

 IF CountDown.Checked then
  Begin
   //Count backward
   SongP:=Abs((GetSongLength*1000)-SongP)*-1;

   // This had to be done like this for compatibility with VB
   GetMem(S,256);
    IntToTimeStr(SongP,aOutPutType,s,255);
    label2.caption:=s;   //Convert millisec to Str
   FreeMem(S,256);

  end
 else
  Begin
   // This had to be done like this for compatibility with VB
   GetMem(S,256);
    IntToTimeStr(SongP,aOutPutType,s,255);
    label2.caption:=s;   //Convert millisec to Str
   FreeMem(S,256);
  end;

 Case GetAmpstate of
  asPlay  : label1.caption:='Playing';
  asPause : label1.Caption:='Paused';
  asStop  : label1.caption:='Stopped';
  asError : label1.caption:='Error?';
 end;

 Label1.Caption:=Label1.Caption+' song of '+IntToStr(progressbar1.Max)+' secs';

 IF PageControl1.ActivePage=tabsheet1 then UpDateWinInfo;
 IF PageControl1.ActivePage=tabsheet7 then UpdateAmp2;
 IF PageControl1.ActivePage=EQ then UpdateEQ;

 if ShiftDown then
  lShift.caption:='Down'
 else lShift.caption:='Up';
 if AltDown then
  lAlt.caption:='Down'
 else lAlt.caption:='Up';
 if CtrlDown then
  lCtrl.caption:='Down'
 else lCtrl.caption:='Up';


 cbShuffle.Checked := MP3RemoteI.GetShuffle;
 cbRepeat.Checked := MP3RemoteI.GetRepeat;
end;

procedure TForm1.btStartClick(Sender: TObject);
var
 S : PChar;
begin
 IF (Not MP3RemoteI.AmpFound) or (Not MP3RemoteI.GetIsWinamp) then
  Begin
   MP3RemoteI.FindWinamp;
   IF MP3RemoteI.AmpFound then Status.Caption:=' Winamp window found!'
    else IF MessageDlg('Winamp not found: Load it for you?',mtWarning,[mbYes,mbNo],0) = mrYes then
     Begin
       Status.Caption:=' Winamp  loading: Please wait';
       Status.Invalidate;
       IF MP3RemoteI.StartWinampAndWait then
        Begin
         IF MP3RemoteI.AmpFound then Status.Caption:=' Winamp window found!';
        end
       else Status.Caption:= ' Winamp not in registry? Is it installed on your computer?';
     end;
  end;

  // This had to be done like this for compatibility with VB
   GetMem(S,256);
    ConvVersion(GetVersion,s,255);
    Label3.Caption:='Winamp Version: '+s;
   FreeMem(S,256);

  cb1.Checked:=GetOnTop;
end;

procedure TForm1.ProgressBar1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 MP3RemoteI.SetSongpos(round((MP3RemoteI.GetSongLength/progressbar1.Width)*x)*1000);
 scrolling:=false;
end;


procedure TForm1.cb1Click(Sender: TObject);
begin
 MP3RemoteI.SetOnTop(cb1.Checked);
end;



procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
 MP3RemoteI.Volume(True);
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
 MP3RemoteI.Volume(False);
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
 SetAmpCaption(Edit1.Text);
end;

procedure TForm1.se1Change(Sender: TObject);
Var
 P : TPoint;
begin

 try
  p.x:=se1.value;
  p.y:=se2.value;
 except
  p.x:=0;
  p.y:=0;
 end;
 MP3RemoteI.SetAmpPos(p.x,p.y);

end;

procedure TForm1.RadioGClick(Sender: TObject);
begin
 case RadioG.itemindex of
  0 : MP3RemoteI.SetAmpWindowState(wsNormal);
  1 : MP3RemoteI.SetAmpWindowState(wsMinimized);
 end;
end;

procedure TForm1.Label2Click(Sender: TObject);
begin
 CountDown.checked:=not CountDown.Checked;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  MP3RemoteI.LoadFileBox;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  MP3RemoteI.PrefBox;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 MP3RemoteI.EQWindow;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  MP3RemoteI.PlayListWindow;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
 MP3RemoteI.AboutBox;
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
 MP3RemoteI.SendKey(Key);
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
 MP3RemoteI.CloseWinAmp;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
 MP3RemoteI.StartWinamp;
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
  MP3RemoteI.FFwd_Rew(False);
end;

procedure TForm1.SpeedButton9Click(Sender: TObject);
begin
 MP3RemoteI.FFwd_Rew(True);
end;


procedure TForm1.Button10Click(Sender: TObject);
begin
 MP3RemoteI.StartPlay;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
 MP3RemoteI.OpenWinampFile(PChar(Edit3.Text));
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
 MP3RemoteI.JumpToTime(spinedit1.value);
end;



procedure TForm1.Button14Click(Sender: TObject);
begin
  Button14.Caption:=inttostr(MP3RemoteI.WriteList);
end;

procedure TForm1.Button15Click(Sender: TObject);
begin
 MP3RemoteI.DeleteList;
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
 if od.execute then
  begin
   MP3RemoteI.AddFileToList(od.filename);
  end;
end;

procedure TForm1.ProgressBar1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 Scrolling:=True;
 progressbar1.Position:=Round((progressbar1.max/progressbar1.Width)*x);
end;

procedure TForm1.ProgressBar1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
 if Scrolling then
 progressbar1.Position:=Round((progressbar1.max/progressbar1.Width)*x);
 
end;


procedure TForm1.Button11Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
 case radiogroup1.ItemIndex of
  0:  aOutPutType:=osH_M_S_MS;
  1:  aOutPutType:=osM_S_ms;
  2:  aOutPutType:=osM_S;
  3:  aOutPutType:=osS_Ms;
 end;

end;

procedure TForm1.Button16Click(Sender: TObject);
begin
 MP3RemoteI.ForcePrevSong;
end;

procedure TForm1.Button18Click(Sender: TObject);
begin
 MP3RemoteI.SendKey('S');
end;

procedure TForm1.Button17Click(Sender: TObject);
begin
 MP3RemoteI.SendKey('R');
end;

procedure TForm1.SpeedButton10Click(Sender: TObject);
begin
 MP3RemoteI.SendKey('L');
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
 MP3RemoteI.SetVolume(ScrollBar1.Position);
 Label27.Caption:=IntToStr(ScrollBar1.Position);
end;

procedure TForm1.ScrollBar2Change(Sender: TObject);
begin
 MP3RemoteI.SetPanning(ScrollBar2.Position);
 Label28.Caption:=IntToStr(ScrollBar2.Position);
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
 MP3RemoteI.SetPlayListPos(SpinEdit2.Value);
 Label29.caption:='Song Length: '+IntToStr(MP3RemoteI.GetSongLength)+' secs';
end;

procedure TForm1.Button19Click(Sender: TObject);
begin
 MP3RemoteI.SetPlayListPos(SpinEdit2.Value);
 MP3RemoteI.Play;
end;

procedure TForm1.Button20Click(Sender: TObject);
begin
 with TfoAbout.Create(Self) do
 try
  ShowModal;
 finally
  Free;
 end;
end;

procedure TForm1.Button21Click(Sender: TObject);
begin
 MP3RemoteI.ChangeDirectory(Edit4.text);
end;

procedure TForm1.eqOnClick(Sender: TObject);
begin
 MP3RemoteI.SetEQOn(eqOn.Checked);
end;

procedure TForm1.eqAutoClick(Sender: TObject);
begin
 MP3RemoteI.SetEQAutoLoad(eqAuto.Checked);
end;

procedure TForm1.eq9Scroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
 IF Sender is TScrollBar then
    SetEQ(TScrollBar(Sender).Tag,ScrollPos);
end;


procedure TForm1.Button22Click(Sender: TObject);
var
 FTemp    : String;
 T        : Integer;
begin
 FTemp := ExtractFilePath(ParamStr(0))+'dummy.m3u';

 MP3RemoteI.SavePlayList(FTemp);
 ListBox1.Items.LoadFromFile(FTemp);

  {Remove extended M3U information}
    T := 0;
    While T < ListBox1.Items.Count do
     begin
      IF Pos('#',ListBox1.Items[T]) = 1 then
       ListBox1.Items.Delete(T)
      else
       Inc(T);
     end;

 ListBox1.ItemIndex:=MP3RemoteI.GetPlayListPos-1;
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
begin
 MP3RemoteI.SetPlayListPos(ListBox1.ItemIndex+1);
 MP3RemoteI.Play;
end;

procedure TForm1.Button23Click(Sender: TObject);
var
 S : PChar;
begin
 GetMem(S,256);
 try
  MP3RemoteI.GetFilename(s,255);
  Label36.Caption:=S;
 finally
  FreeMem(S,256);
 end;

end;




procedure TForm1.Button25Click(Sender: TObject);
begin
 IF OD2.Execute then
  MP3RemoteI.LoadPlayList(OD2.FileName);
end;


procedure TForm1.Label38Click(Sender: TObject);
begin
 //Remember to include ShellApi in your uses clause if you use this
 ShellExecute(GetDesktopWindow(), 'open', PChar('http://www.mindblastsoftware.com'), nil, nil, SW_SHOWNORMAL);
end;

procedure TForm1.Button24Click(Sender: TObject);
begin
 MP3RemoteI.FileInfo;
end;

procedure TForm1.Button26Click(Sender: TObject);
begin
    MP3RemoteI.VisPluginOptions;
end;

procedure TForm1.Button27Click(Sender: TObject);
begin
 MP3RemoteI.JumpTimeBox;

end;

procedure TForm1.Button28Click(Sender: TObject);
begin
   MP3RemoteI.JumpToFileBox;
end;

procedure TForm1.Button29Click(Sender: TObject);
begin
 MP3RemoteI.SkinSelectBox;
end;


procedure TForm1.Button30Click(Sender: TObject);
begin
 MP3RemoteI.ShadeMode;
end;

procedure TForm1.Button31Click(Sender: TObject);
begin
 MP3RemoteI.ShadeMode_Playlist;
end;

procedure TForm1.Button32Click(Sender: TObject);
begin
 MP3RemoteI.DoubleSize;
end;

procedure TForm1.Button33Click(Sender: TObject);
begin
 MP3RemoteI.AmpVisible;
end;

procedure TForm1.Button34Click(Sender: TObject);
begin
 MP3RemoteI.ReloadSkin;
end;

procedure TForm1.Button35Click(Sender: TObject);
begin
 MP3RemoteI.TitleScrolling;
end;

procedure TForm1.Button36Click(Sender: TObject);
begin
 MP3RemoteI.EasyMove;
end;

procedure TForm1.cbShuffleClick(Sender: TObject);
begin
 MP3RemoteI.SetShuffle(cbShuffle.Checked);
end;

procedure TForm1.cbRepeatClick(Sender: TObject);
begin
 MP3RemoteI.SetRepeat(cbRepeat.Checked);
end;

procedure TForm1.cbTimeRemClick(Sender: TObject);
begin
 MP3RemoteI.Countdown(cbTimeRem.Checked);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
 PageControl1.ActivePage := TabSheet5;
 btStart.Click;
end;



procedure TForm1.Button1Click(Sender: TObject);
begin
 AboutDLL;
end;

end.
