unit MP3RemoteI;

(* ---------------------------------------------------------
   This is the interface unit to the MP3RemoteDLL. There is a
   native Delphi component available. The MP3RemoteDLL was only
   ceated because of the popular demand for the component for other
   platforms, like VB and C.
   For updates, other components, etc. please visit our website.

   The ultimate MP3 Remote control - Control Winamp from within
   your own application!!!
   Write your own frontend for winamp in a breeze.
   It only takes about 3 easy steps:
    (1) Include the interface unit in your form
    (2) Create a few buttons, labels and sliders
    (3) Call the functions and procedures encapsulated in the MP3Remote
        DLL.

  Nope. I'm not joking. All the hard work has already been done for you!

  See comments, documentation and demo application for more details on usage.

  Contact us:
    MindBlast Software
    louw@gcs.co.za
    www.MindBlastSoftware.com

  Disclaimer:
    We do not except any responsibility for any damages that may result
    from the direct or indirect use of this component. This includes the
    evaluation of the component for its fitness for your particular use.

  Copyright:
    Copyright MindBlast Software 1998-2000.
    You may not distribute the source, the component, or any other part
    of the registered component.
    You may however, if you are a registered user of the MP3Remote component and/or DLL,
    use the component/DLL in your applications without any royalties or any other
    extra charges.

   --------------------------------------------------------- *)


interface
Uses Windows, Classes, Forms;

const
 btPrev   = 1;
 btPlay   = 2;
 btPause  = 3;  // Used for PressButton function
 btStop   = 4;  // Give this as the ButNo value
 btNext   = 5;

Type
 TKeyType     = (ktNone, ktCtrl, ktShift);   // Used in PressButton
 TAmpState    = (asPlay, asPause, asStop, asError); // Winamp playing state
 TOutPutType  = (osH_M_S_MS,osM_S_ms,osM_S,osS_Ms); // TimeToString output type

 procedure AboutDLL;StdCall;   // MBS About box - OK so it makes the DLL a
                       // bit big, but hey - you got the whole thing FREE didn't you?

 //// Use these functions first before anything will work!!!
 /// Note: Nothing will work until the correct Winamp Window handle is found!
 function FindWinampClass(aClass : String):Boolean; StdCall; //Find Winamp handle by class
 function FindWinamp:Boolean;StdCall;                    // Find the Winamp handle
 function OpenWinampFile(AFile : PChar):Boolean;StdCall; // Open Winamp with file as parameter
 function StartWinamp:Boolean;StdCall;                   // Starts Winamp application
 function StartWinampAndWait:Boolean;StdCall;            // Starts winamp and wait for it to load
 procedure CloseWinAmp;StdCall;                          // Closes winamp

 // Test with these functions!!!
 Function WinampWindow:Hwnd;StdCall; // Return handle of Winamp window
 Function AmpFound:Boolean;StdCall;  // Returns true if Winamp was found previously
                              // i.e. by FindWinamp or StartWinampAndWait
 procedure AddFileToListNow(FName : String);StdCall;      { Adds a file to the playlist
  using SendMessage in stead of PostMessage - Use this for long filenames }
 procedure AddFileToList(FName : String);StdCall;      { Adds a file to the playlist
                                                     Does not affect the playing of the current file being played }
 procedure DeleteList;StdCall;                         // Delete the current playlist
 procedure StartPlay;StdCall;                          // Starts playing
 procedure ChangeDirectory(NewDir : String);StdCall;   // Changes the directory
 Function GetAmpState:TAmpState;StdCall;               // Get the state of WinAmp (playing, stopped, paused)
 Function JumpToTime(aTime : Integer):Boolean;StdCall; // Returns true if call is successfull
                                               // Jumps to aTime in song (In milliSeconds)
 Function GetSongPos:Integer;StdCall;                  // get position of song that is playing in milliseconds
 Procedure SetSongPos(Value : Integer);StdCall;        // set the song position in millisecs (see JumpToTime)
 Function GetSongLength:Integer;StdCall;               // Get the length of the song in seconds

 procedure SetOnTop(Value : Boolean);StdCall;          // Set amp OnTop value
 function GetOnTop:Boolean;StdCall;                    // Get amp OnTop value

 procedure SetAmpCaption(Value : String);StdCall;      // Set the caption of Winamp!
 function GetAmpCaption(lpStr : PChar; Max : Integer):Integer; StdCall;
                                                      // Get Winamp's caption

 procedure SetAmpPos(x,y : Integer);StdCall;          // Set position of Winamp
 procedure GetAmpPos(Var x,y : Integer);StdCall;                    // Get position of Winamp

 procedure SetAmpWindowState(Value : TWindowState);StdCall; // Set Winamps windowstate (wsMinimized, wsNormal)
 function GetAmpWindowState:TWindowState;StdCall;      // Get Window state (wsMinimized, wsNormal)

 function GetIsWinamp:Boolean;StdCall;

 Function WriteList:Integer;StdCall;                   // Writes the current playlist to <winampdir>\Winamp.pl
                                               // and returns the index of the current song in the playlist
 procedure ForcePrevSong;StdCall;  {Only ver 1.666+}   // Always plays previous song
 procedure LoadFileBox;StdCall;                        // pops up the load file(s) box
 procedure PrefBox;StdCall;                            // pops up the preferences
 procedure EQWindow;StdCall;                           // toggles the EQ window
 procedure PlayListWindow;StdCall;                     // toggles the playlist window
 procedure Volume(Up : Boolean);StdCall;               // True  - turns the volume up a little
                                               // False - Turns the volume down a little
 procedure FFwd_Rew(FFwd : Boolean);StdCall;           // True  - fast forwards 5 seconds
                                               // False - rewinds 5 seconds
 procedure ChangeAlwaysOnTop;StdCall;                  // toggles always on top
 procedure AboutBox;StdCall;                           // pops up the about box

 procedure SendKey(Ch : Char);StdCall;  //Simulate keypress in winamp

 procedure Play;StdCall;
 procedure PlayLater; StdCall;
 procedure Pause;StdCall;
 Procedure Stop;StdCall;   { Doesn't take much of a brain to figure these out 8^) }
 procedure Next;StdCall;
 procedure Previous;StdCall;

 procedure PressButton(ButNo : Byte; KeyType : TKeyType);StdCall;
 //            Simulates the press of a button on Winamp
 //            ButNo is the number of the button (1=Prev; 2=Play; 3=Pause; etc);
 //            KeyType tells how the button must behave
 //                    ktNone  - act like normal button
 //                    ktCtrl  - act like Ctrl was held in
 //                    ktShift - act like Shift was held in

 function GetVersion:Word;StdCall;                       // Get Winamp version
 function GetVersionStr(lpStr : PChar; Max : Integer):Integer; StdCall;
                                                         // Returns version in String format
 function ConvVersion(Ver : Word; lpStr : PChar; Max : Integer):Integer; StdCall;

 /////////--- Winamp v2.0+ functions ---///////////
 function  GetListLength:Integer;StdCall;                // Get number of songs in playlist
 procedure SetPlayListPos(Value : Integer);StdCall;      // Set playlist position
 procedure SetVolume(Value : Byte);StdCall;              // Set volume 0-255
 procedure SetPanning(Value : Byte);StdCall;             // Set panning -255 to 255
 //////////////////////////////////////////////////

 /////////--- Winamp v2.05+ functions ---///////////
 Function GetPlayListPos:Integer; StdCall;
 //get position of song that is playing in milliseconds
 function GetEQOn:Boolean;StdCall;                       // Returns True if EQ is enabled
 procedure SetEQOn(Value : Boolean); StdCall;            // Enable/Disable EQ
 function GetEQAutoLoad:Boolean;StdCall;                 // Returns True if EQ is set to autoload
 procedure SetEQAutoLoad(Value : Boolean);StdCall;       // Disable/Enable EQ AutoLoad
 function GetEQ(Index : Byte):Byte;StdCall;              // Get EQ values
 procedure SetEQ(Index : Byte; Value : Byte); StdCall;   // Set EQ Value
 function GetStereo:Boolean;StdCall;                     // True if MP3 is stereo
 function GetBitRate:Integer;StdCall;                    // BitRate of MP3
 function GetSampleRate:Integer;StdCall;                 // SampleRate of MP3
 //////////////////////////////////////////////////


 //// Aditional Function ////
 Function IntToTimeStr(Value : Integer; OutPutType : TOutPutType; lpStr : PChar; Max : Integer):Integer; StdCall;
 //Converts value that is in milliseconds to hh:mm:ss.mss

 Function ShiftToKeyType(Value : TShiftState):TKeyType;StdCall;
 // Converts TShiftState to TKeyType
 // Very usefull if used with OnMouseDown Events on Buttons, etc.

 Function ShiftDown:Boolean;StdCall;
 Function CtrlDown:Boolean;StdCall;  //Return true if button is currently down
 Function AltDown:Boolean;StdCall;

 //////////////////////////////////////////////////

 /// Added 15/03/1999
 function GetFileName(lpStr : PChar; Max : Integer):Integer; stdcall;
 procedure LoadPlayList(aFile : String); StdCall;
 function BackupPlayList(aFile : String):Integer; StdCall;
 function SavePlayList(aFile : String):Integer; StdCall; //Same as backup playlist
 function GetWinampDir(lpStr : PChar; Max : Integer):Integer; stdcall;

 //Added 26/08/2000
 procedure SetDLLMode(Value : Boolean); stdcall;
 procedure SetClassName(Value : String); stdcall;

 //////////////////////////////////////////////
//      New Winamp v2.6+  Functions         //
//////////////////////////////////////////////

procedure SetBookmark(Value : Byte);  stdcall;
procedure SetPlaylistEntry(Position : Integer); stdcall;
function GetURL( lpStr : PChar; Max : Integer):Integer; stdcall;
procedure RestartWinamp; stdcall;
function GetSkin(Path : PChar; lpStr : PChar; Max : Integer):Integer;  stdcall;
function GetSkinAndPath( lpStr : PChar; Max : Integer ):Integer; stdcall;
procedure SetSkin(Skin : PChar); stdcall;
procedure SetVis(VisName : PChar; ModuleIndex : Integer); stdcall;
procedure SetURL(URL : PChar); stdcall;
procedure OpenMiniBrowser; stdcall;
function IsConnected:Boolean; stdcall;
procedure UpdateTitle; stdcall;
procedure FlushCache; stdcall;
procedure SetURLLock(Locked : Boolean);
procedure SetURLLockForce(Locked : Boolean); stdcall;
function GetFilenameAtPos(FPos : Integer; lpStr : PChar; Max : Integer):Integer; stdcall;
function GetTitleAtPos(FPos : Integer; lpStr : PChar; Max : Integer):Integer; stdcall;
function GetShuffle:Boolean; stdcall;
function GetRepeat:Boolean; stdcall;
procedure SetShuffle(Value : Boolean); stdcall;
procedure SetRepeat(Value : Boolean); stdcall;


 // Winamp 2.6+ commands
procedure FileInfo; stdcall;
procedure Countdown(Value : Boolean); stdcall;
procedure VisOptions; stdcall;
procedure VisPluginOptions; stdcall;
procedure VisConfig; stdcall;
procedure ExecuteVisPlugin; stdcall;
procedure TitleScrolling; stdcall;
procedure ShadeMode; stdcall;
procedure ShadeMode_Playlist; stdcall;
procedure DoubleSize; stdcall;
procedure AmpVisible; stdcall;
procedure MiniBrowser; stdcall;
procedure EasyMove; stdcall;
procedure ToggleRepeat; stdcall;
procedure ToggleShuffle; stdcall;
procedure JumpTimeBox; stdcall;
procedure JumpToFileBox; stdcall;
procedure SkinSelectBox; stdcall;
procedure ReloadSkin; stdcall;
procedure CloseWinamp2; stdcall;
//===================== END of Winamp 2.6+ functions ====================


implementation

procedure AboutDll; external 'MP3RemoteDLL.dll' name 'DllAbout';
procedure AddFileToListNow(FName : String); external 'MP3RemoteDLL.dll' name 'AddFileToListNow';
procedure AddFileToList(FName : String); external 'MP3RemoteDLL.dll' name 'AddFileToList';
procedure DeleteList; external 'MP3RemoteDLL.dll' name 'DeleteList';
procedure StartPlay; external 'MP3RemoteDLL.dll' name 'StartPlay';
procedure ChangeDirectory(NewDir : String); external 'MP3RemoteDLL.dll' name 'ChangeDirectory';
Function GetAmpState:TAmpState; external 'MP3RemoteDLL.dll' name 'GetAmpState';
Function JumpToTime(aTime : Integer):Boolean; external 'MP3RemoteDLL.dll' name 'JumpToTime';
Function GetSongPos:Integer; external 'MP3RemoteDLL.dll' name 'GetSongPos';
Procedure SetSongPos(Value : Integer); external 'MP3RemoteDLL.dll' name 'SetSongPos';
Function GetSongLength:Integer; external 'MP3RemoteDLL.dll' name 'GetSongLength';
procedure SetOnTop(Value : Boolean); external 'MP3RemoteDLL.dll' name 'SetOnTop';
function GetOnTop:Boolean; external 'MP3RemoteDLL.dll' name 'GetOnTop';
procedure SetAmpCaption(Value : String); external 'MP3RemoteDLL.dll' name 'SetAmpCaption';
function GetAmpCaption(lpStr : PChar; Max : Integer):Integer; external 'MP3RemoteDLL.dll' name 'GetAmpCaption';
procedure SetAmpPos(x,y : Integer); external 'MP3RemoteDLL.dll' name 'SetAmpPos';
procedure GetAmpPos(Var x,y : Integer); external 'MP3RemoteDLL.dll' name 'GetAmpPos';
procedure SetAmpWindowState(Value : TWindowState); external 'MP3RemoteDLL.dll' name 'SetAmpWindowState';
function GetAmpWindowState:TWindowState; external 'MP3RemoteDLL.dll' name 'GetAmpWindowState';
function GetIsWinamp:Boolean; external 'MP3RemoteDLL.dll' name 'GetIsWinamp';
Function WriteList:Integer; external 'MP3RemoteDLL.dll' name 'WriteList';
procedure ForcePrevSong; external 'MP3RemoteDLL.dll' name 'ForcePrevSong';
procedure LoadFileBox; external 'MP3RemoteDLL.dll' name 'LoadFileBox';
procedure PrefBox; external 'MP3RemoteDLL.dll' name 'PrefBox';
procedure EQWindow; external 'MP3RemoteDLL.dll' name 'EQWindow';
procedure PlayListWindow; external 'MP3RemoteDLL.dll' name 'PlayListWindow';
procedure Volume(Up : Boolean); external 'MP3RemoteDLL.dll' name 'Volume';
procedure FFwd_Rew(FFwd : Boolean); external 'MP3RemoteDLL.dll' name 'FFwd_Rew';
procedure ChangeAlwaysOnTop; external 'MP3RemoteDLL.dll' name 'ChangeAlwaysOnTop';
procedure AboutBox; external 'MP3RemoteDLL.dll' name 'AboutBox';
procedure SendKey(Ch : Char); external 'MP3RemoteDLL.dll' name 'SendKey';
procedure Play; external 'MP3RemoteDLL.dll' name 'Play';
procedure PlayLater; external 'MP3RemoteDLL.dll' name 'PlayLater';
procedure Pause; external 'MP3RemoteDLL.dll' name 'Pause';
Procedure Stop; external 'MP3RemoteDLL.dll' name 'Stop';
procedure Next; external 'MP3RemoteDLL.dll' name 'Next';
procedure Previous; external 'MP3RemoteDLL.dll' name 'Previous';
procedure PressButton(ButNo : Byte; KeyType : TKeyType); external 'MP3RemoteDLL.dll' name 'PressButton';
function GetVersion:Word; external 'MP3RemoteDLL.dll' name 'GetVersion';
function GetVersionStr(lpStr : PChar; Max : Integer):Integer; external 'MP3RemoteDLL.dll' name 'GetVersionStr';
function ConvVersion(Ver : Word; lpStr : PChar; Max : Integer):Integer; external 'MP3RemoteDLL.dll' name 'ConvVersion';
function FindWinampClass(aClass : String):Boolean; external 'MP3RemoteDLL.dll' name 'FindWinampClass';
function FindWinamp:Boolean; external 'MP3RemoteDLL.dll' name 'FindWinamp';
function OpenWinampFile(AFile : PChar):Boolean; external 'MP3RemoteDLL.dll' name 'OpenWinampFile';
function StartWinamp:Boolean; external 'MP3RemoteDLL.dll' name 'StartWinamp';
function StartWinampAndWait:Boolean; external 'MP3RemoteDLL.dll' name 'StartWinampAndWait';
procedure CloseWinAmp; external 'MP3RemoteDLL.dll' name 'CloseWinAmp';
function  GetListLength:Integer; external 'MP3RemoteDLL.dll' name 'GetListLength';
procedure SetPlayListPos(Value : Integer); external 'MP3RemoteDLL.dll' name 'SetPlayListPos';
procedure SetVolume(Value : Byte); external 'MP3RemoteDLL.dll' name 'SetVolume';
procedure SetPanning(Value : Byte); external 'MP3RemoteDLL.dll' name 'SetPanning';


Function GetPlayListPos:Integer; external 'MP3RemoteDLL.dll' name 'GetPlayListPos';
function GetEQOn:Boolean; external 'MP3RemoteDLL.dll' name 'GetEQOn';
procedure SetEQOn(Value : Boolean); external 'MP3RemoteDLL.dll' name 'SetEQOn';
function GetEQAutoLoad:Boolean; external 'MP3RemoteDLL.dll' name 'GetEQAutoLoad';
procedure SetEQAutoLoad(Value : Boolean); external 'MP3RemoteDLL.dll' name 'SetEQAutoLoad';
function GetEQ(Index : Byte):Byte; external 'MP3RemoteDLL.dll' name 'GetEQ';
procedure SetEQ(Index : Byte; Value : Byte); external 'MP3RemoteDLL.dll' name 'SetEQ';
function GetStereo:Boolean; external 'MP3RemoteDLL.dll' name 'GetStereo';
function GetBitRate:Integer; external 'MP3RemoteDLL.dll' name 'GetBitRate';
function GetSampleRate:Integer; external 'MP3RemoteDLL.dll' name 'GetSampleRate';


Function IntToTimeStr(Value : Integer; OutPutType : TOutPutType; lpStr : PChar; Max : Integer):Integer; external 'MP3RemoteDLL.dll' name 'IntToTimeStr';
Function ShiftToKeyType(Value : TShiftState):TKeyType; external 'MP3RemoteDLL.dll' name '';
Function ShiftDown:Boolean; external 'MP3RemoteDLL.dll' name 'ShiftDown';
Function CtrlDown:Boolean; external 'MP3RemoteDLL.dll' name 'CtrlDown';
Function AltDown:Boolean; external 'MP3RemoteDLL.dll' name 'AltDown';

function GetFileName(lpStr : PChar; Max : Integer):Integer; external 'MP3RemoteDLL.dll' name 'GetFileName';
procedure LoadPlayList(aFile : String); external 'MP3RemoteDLL.dll' name 'LoadPlayList';
function BackupPlayList(aFile : String):Integer; external 'MP3RemoteDLL.dll' name 'BackupPlayList';
function SavePlayList(aFile : String):Integer; external 'MP3RemoteDLL.dll' name 'SavePlayList';
function GetWinampDir(lpStr : PChar; Max : Integer):Integer; external 'MP3RemoteDLL.dll' name 'GetWinampDir';

Function WinampWindow:Hwnd; external 'MP3RemoteDLL.dll' name 'WinampWindow';
Function AmpFound:Boolean; external 'MP3RemoteDLL.dll' name 'AmpFound';


procedure SetDLLMode(Value : Boolean); external 'MP3RemoteDLL.dll' name 'SetDLLMode';
procedure SetClassName(Value : String); external 'MP3RemoteDLL.dll' name 'SetClassName';

 //////////////////////////////////////////////
//      New Winamp v2.6+  Functions         //
//////////////////////////////////////////////

procedure SetBookmark(Value : Byte);   external 'MP3RemoteDLL.dll' name 'SetBookmark';
procedure SetPlaylistEntry(Position : Integer);  external 'MP3RemoteDLL.dll' name 'SetPlaylistEntry';
function GetURL( lpStr : PChar; Max : Integer):Integer;  external 'MP3RemoteDLL.dll' name 'GetURL';
procedure RestartWinamp;  external 'MP3RemoteDLL.dll' name 'RestartWinamp';
function GetSkin(Path : PChar; lpStr : PChar; Max : Integer):Integer;   external 'MP3RemoteDLL.dll' name 'GetSkin';
function GetSkinAndPath( lpStr : PChar; Max : Integer ):Integer;  external 'MP3RemoteDLL.dll' name 'GetSkinAndPath';
procedure SetSkin(Skin : PChar);  external 'MP3RemoteDLL.dll' name 'SetSkin';
procedure SetVis(VisName : PChar; ModuleIndex : Integer);  external 'MP3RemoteDLL.dll' name 'SetVis';
procedure SetURL(URL : PChar);  external 'MP3RemoteDLL.dll' name 'SetURL';
procedure OpenMiniBrowser;  external 'MP3RemoteDLL.dll' name 'OpenMiniBrowser';
function IsConnected:Boolean;  external 'MP3RemoteDLL.dll' name 'IsConnected';
procedure UpdateTitle;  external 'MP3RemoteDLL.dll' name 'UpdateTitle';
procedure FlushCache;  external 'MP3RemoteDLL.dll' name 'FlushCache';
procedure SetURLLock(Locked : Boolean); external 'MP3RemoteDLL.dll' name 'SetURLLock';
procedure SetURLLockForce(Locked : Boolean);  external 'MP3RemoteDLL.dll' name 'SetURLLockForce';
function GetFilenameAtPos(FPos : Integer; lpStr : PChar; Max : Integer):Integer;  external 'MP3RemoteDLL.dll' name 'GetFilenameAtPos';
function GetTitleAtPos(FPos : Integer; lpStr : PChar; Max : Integer):Integer;  external 'MP3RemoteDLL.dll' name 'GetTitleAtPos';
function GetShuffle:Boolean;  external 'MP3RemoteDLL.dll' name 'GetShuffle';
function GetRepeat:Boolean;  external 'MP3RemoteDLL.dll' name 'GetRepeat';
procedure SetShuffle(Value : Boolean);  external 'MP3RemoteDLL.dll' name 'SetShuffle';
procedure SetRepeat(Value : Boolean);  external 'MP3RemoteDLL.dll' name 'SetRepeat';


 // Winamp 2.6+ commands
procedure FileInfo;  external 'MP3RemoteDLL.dll' name 'FileInfo';
procedure Countdown(Value : Boolean);  external 'MP3RemoteDLL.dll' name 'Countdown';
procedure VisOptions;  external 'MP3RemoteDLL.dll' name 'VisOptions';
procedure VisPluginOptions;  external 'MP3RemoteDLL.dll' name 'VisPluginOptions';
procedure VisConfig;  external 'MP3RemoteDLL.dll' name 'VisConfig';
procedure ExecuteVisPlugin;  external 'MP3RemoteDLL.dll' name 'ExecuteVisPlugin';
procedure TitleScrolling;  external 'MP3RemoteDLL.dll' name 'TitleScrolling';
procedure ShadeMode;  external 'MP3RemoteDLL.dll' name 'ShadeMode';
procedure ShadeMode_Playlist;  external 'MP3RemoteDLL.dll' name 'ShadeMode_Playlist';
procedure DoubleSize;  external 'MP3RemoteDLL.dll' name 'DoubleSize';
procedure AmpVisible;  external 'MP3RemoteDLL.dll' name 'AmpVisible';
procedure MiniBrowser;  external 'MP3RemoteDLL.dll' name 'MiniBrowser';
procedure EasyMove;  external 'MP3RemoteDLL.dll' name 'EasyMove';
procedure ToggleRepeat;  external 'MP3RemoteDLL.dll' name 'ToggleRepeat';
procedure ToggleShuffle;  external 'MP3RemoteDLL.dll' name 'ToggleShuffle';
procedure JumpTimeBox;  external 'MP3RemoteDLL.dll' name 'JumpTimeBox';
procedure JumpToFileBox;  external 'MP3RemoteDLL.dll' name 'JumpToFileBox';
procedure SkinSelectBox;  external 'MP3RemoteDLL.dll' name 'SkinSelectBox';
procedure ReloadSkin;  external 'MP3RemoteDLL.dll' name 'ReloadSkin';
procedure CloseWinamp2;  external 'MP3RemoteDLL.dll' name 'CloseWinamp2';
//===================== END of Winamp 2.6+ functions ====================
end.
