unit ScrollLabel;

{
This component was developed for use in MP3Tag. I will improve on
ScrollLabel later, but for know it works fine for its purpose.
This component is FREEWARE.

You can get MP3Tag at http://www.MindBlastSoftware.com
Please contact me for any comments, bugs, suggestions, etc at
louw@gcs.co.za

Sorry for the lack of comments, but I don't think you will have
any trouble in understanding how it all works. 

Disclaimer:
You use this component at your own and exclusive risk. 

}

interface
{$R ScrollLabel.Res}

uses
  Windows,   Classes, Graphics,
  StdCtrls, extctrls;

Const
 ScrollBy = 1;

type

  TScrollLabel = class(TCustomLabel)
  private
    { Private declarations }
    FBitmap     : TBitmap;
    FTimer      : TTimer;
    FInterval   : Cardinal;
    FActive     : Boolean;
    FScrollBy   : Integer;
    FCurPos     : Integer;
    FWait       : Integer;
    FWaiting    : Boolean;
    FCaption    : String;

    procedure SetActive(Value : Boolean);
    procedure SetInterval(Value : Cardinal);
    procedure FillBitMap;
    procedure Activate;
    procedure Deactivate;
    procedure UpdatePos;
    procedure DoOnTimer(Sender : TObject);

  protected
    { Protected declarations }
    procedure paint; override;

  public
    { Public declarations }
    constructor create(AOwner: TComponent);override;
    destructor destroy; override;
  published
    { Published declarations }
    property Active    : Boolean read FActive write SetActive;
    property ScrollBy  : Integer read FScrollBy write FScrollBy;
    property Interval  : Cardinal read FInterval write SetInterval;
    property WaitOnEnd : Integer read FWait write FWait;
    property align;
    property Color;
    property Caption;
    property Font;
    property ParentColor;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;

  end;

procedure Register;

implementation

constructor TScrollLabel.Create(AOwner : TComponent);
Begin
  inherited Create(AOwner);

  FInterval:=100;

  FTimer:=TTimer.Create(Self);
  With FTimer do
   Begin
    Enabled:=False;
    Interval:=FInterval;
    OnTimer:=DoOnTimer;
   end;
  Width:=100;
  Height:=20;
  FActive:=False;
  Activate;
  FScrollBy:=2;
  FWait:=1000;
  AutoSize:=False;
end;

destructor TScrollLabel.Destroy;
begin
 Deactivate;
 FTimer.Free;
 inherited Destroy;
end;



procedure TScrollLabel.SetActive(Value : Boolean);
begin
 IF Value <> FActive then
  Begin
    FActive:=Value;
    IF FActive then
     Begin
       Activate;
     end
    else Deactivate;
    FWaiting:=False;
  end;
end;

procedure TScrollLabel.SetInterval(Value : Cardinal);
begin
 IF Value <> FInterval then
  Begin
    FInterval:=Value;
    FTimer.Interval:=Value;
  end;
end;


procedure TScrollLabel.Activate;
begin
 FActive:=True;
 FTimer.Enabled:=True;
 FTimer.Interval:=FInterval;
 FWaiting:=False;

 FBitmap:=TBitmap.Create;
  with FBitmap do
   Begin
    pixelformat:=pf8bit;
    width:=10;
    height:=10;
   end;

 FCurPos:=0;
 FillBitMap;
end;

procedure TScrollLabel.Deactivate;
begin
  FTimer.Enabled:=False;
  FBitmap.Free;
  FActive:=False;
  Invalidate;
end;

procedure TScrollLabel.DoOnTimer(Sender : Tobject);
Begin
 IF FWaiting then
  Begin
   FTimer.Interval:=FInterval;
   FWaiting:=False;
  end;

 UpDatePos;
 Paint;
end;

procedure TScrollLabel.FillBitmap;
Var
 VRect : TRect;
begin


  With FBitmap do
   begin
     Canvas.Font:=Self.Font;
     Canvas.Brush.Color:=Color;
     IF (Canvas.TextWidth(Self.Caption)+5)> Self.Width then
      Width:=Canvas.TextWidth(Self.Caption)+5
     Else Width:=Self.Width;

     height:=Self.Height;
     Vrect.Top:=0;
     VRect.Left:=0;

     VRect.Bottom:=FBitmap.Height;
     VRect.Right:=FBitMap.Width;
     Canvas.FillRect(VRect);
     Canvas.Brush.Style:=bsClear;

     Canvas.Textout(1,0,Self.Caption);
   end;
end;

procedure TScrollLabel.UpDatePos;
begin
  If FBitmap.Canvas.TextWidth(Self.Caption) > Width then
   Begin
     FCurPos:=FCurPos+FScrollBy;
     IF FCurPos <= 0 then
      Begin
        FScrollBy:=Abs(FScrollBy);
        IF FWait<>0 then
         Begin
           FWaiting:=True;
           FTimer.Interval:=FWait;
         end;
      end;

     IF FBitMap.Width-FCurPos <= Width then
      Begin
       FScrollBy:=Abs(FScrollBy)*-1;
       IF FWait<>0 then
         Begin
           FWaiting:=True;
           FTimer.Interval:=FWait;
         end;
      end;
   end;

end;

procedure TScrollLabel.Paint;
begin
 IF FActive then
  Begin
   IF Caption <> FCaption then
    Begin
     Deactivate;
     Activate;
     FCaption:=Caption;
    end;
   BitBlt(Canvas.Handle,0,0,Width,Height,FBitmap.Canvas.Handle,FCurPos,0,srcCopy);
  end
 else Inherited Paint;
end;

procedure Register;
begin
  RegisterComponents('MBS', [TScrollLabel]);
end;

end.
