unit Mlrdemo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, Mlrquery, DB, Mlrtable, StdCtrls, Buttons,
  Grids, DBGrids, ExtCtrls, Mlroptim, DBCtrls;

type
  TForm1 = class(TForm)
    bbtnClose: TBitBtn;
    bbtnTable: TBitBtn;
    Label1: TLabel;
    TableSource: TDataSource;
    QuerySource: TDataSource;
    DBGrid1: TDBGrid;
    bbtnQuery: TBitBtn;
    StringGrid1: TStringGrid;
    Label4: TLabel;
    Panel1: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label11: TLabel;
    Panel4: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Panel2: TPanel;
    MLRTable1: TMLRTable;
    MLRQuery1: TMLRQuery;
    bbtnOutput: TBitBtn;
    bbtnPlots: TBitBtn;
    ComboBox1: TComboBox;
    MLRTable2: TMLRTable;
    MLRTable3: TMLRTable;
    bbtnOptimize: TBitBtn;
    MLRTable4: TMLRTable;
    Memo1: TMemo;
    DBMemo1: TDBMemo;
    SampleDataSource: TDataSource;
    SampleDataTable: TTable;
    MLRQuery2: TMLRQuery;
    MLRQuery3: TMLRQuery;
    MLRTable5: TMLRTable;
    ComboBox2: TComboBox;
    procedure bbtnTableClick(Sender: TObject);
    procedure bbtnQueryClick(Sender: TObject);
    procedure bbtnOutputClick(Sender: TObject);
    procedure bbtnPlotsClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure bbtnCloseClick(Sender: TObject);
    procedure Enablebbtn(var bbtn1,bbtn2: TBitBtn);
    procedure bbtnOptimizeClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Table: TMLRTable;
  Query: TMLRQuery;

implementation

{$R *.DFM}

procedure TForm1.bbtnTableClick(Sender: TObject);
var i,j: integer; simpleLoad,multiLoad: boolean;
begin
 DBMemo1.Visible := False;
 StringGrid1.Enabled := Table.Active;
 Panel2.Caption := Table.TableName;
 simpleLoad := (ComboBox2.ItemIndex <= 0);
 multiLoad := not simpleLoad;
 with Table do
  if (simpleLoad and LoadValues) or (multiLoad and ReLoad) then
   begin
    Execute;   { perform regression and allow access to results}
    bbtnPlots.Enabled := True;
    bbtnOutput.Enabled := True;
    bbtnOptimize.Enabled := True;
    Label2.Caption := intToStr(n)+' datapoints.';
    Label3.Caption := intToStr(DegreesOfFreedom)+' degrees of freedom.';
    Label11.Caption := intToStr(nControls)+' control variables.';
    StringGrid1.ColCount := nControls + 3;
    StringGrid1.RowCount := n + 7;
    StringGrid1.Cells[1,0] := ResponseVarY.OutputTerm;
    StringGrid1.Cells[0,n+1] := 'Mean';
    StringGrid1.Cells[0,n+2] := 'Std Dev';
    StringGrid1.Cells[0,n+3] := 'Max';
    StringGrid1.Cells[0,n+4] := 'Min';
    StringGrid1.Cells[0,n+5] := 'Parameters';
    StringGrid1.Cells[0,n+6] := 'Constant';
    StringGrid1.Cells[1,n+1] := floatToStrF(yBar,ffFixed,7,3);
    StringGrid1.Cells[1,n+2] := floatToStrF(yStdErr,ffFixed,7,3);
    StringGrid1.Cells[1,n+3] := floatToStrF(yMax,ffFixed,7,3);
    StringGrid1.Cells[1,n+4] := floatToStrF(yMin,ffFixed,7,3);
    StringGrid1.Cells[1,n+5] := '1.00';
    StringGrid1.Cells[2,n+6] := floatToStrF(b[0],ffFixed,7,3);
    for j:= 1 to nControls do
     begin
      StringGrid1.Cells[j+2,0] := cVariable[j].OutputTerm;
      StringGrid1.Cells[j+2,n+1] := floatToStrF(xBar[j],ffFixed,7,3);
      StringGrid1.Cells[j+2,n+2] := floatToStrF(xStdErr[j],ffFixed,7,3);
      StringGrid1.Cells[j+2,n+3] := floatToStrF(xMax[j],ffFixed,7,3);
      StringGrid1.Cells[j+2,n+4] := floatToStrF(xMin[j],ffFixed,7,3);
      StringGrid1.Cells[j+2,n+5] := floatToStrF(b[j],ffFixed,7,3);
     end;      { for j := 1}
    for i:= 1 to n do
     begin
      StringGrid1.Cells[0,i] := intToStr(i);
      StringGrid1.Cells[1,i] := floatToStrF(y[i],ffFixed,7,3);
      for j:= 1 to nControls do
       StringGrid1.Cells[j+2,i] := floatToStrF(x[i,j],ffFixed,7,3);
     end    { for i := 1}
   end  { if loadValues }
end;

procedure TForm1.bbtnQueryClick(Sender: TObject);
var i,j: integer; simpleLoad,multiLoad: boolean;
begin
 DBMemo1.Visible := False;
 StringGrid1.Enabled := Query.Active;
 Panel2.Caption := Query.SQL.Strings[0];
 simpleLoad := (ComboBox2.ItemIndex <= 0);
 multiLoad := not simpleLoad;
 with Query do
  begin
   if  (simpleLoad and LoadValues) or (multiLoad and ReLoad) then
    begin
     Execute;
     bbtnPlots.Enabled := True;
     bbtnOutput.Enabled := True;
     bbtnOptimize.Enabled := True
    end;
    Label2.Caption := intToStr(n)+' datapoints.';
    Label3.Caption := intToStr(DegreesOfFreedom)+' degrees of freedom.';
    Label11.Caption := intToStr(nControls)+' control variables.';
    StringGrid1.ColCount := nControls + 3;
    StringGrid1.RowCount := n + 6;
    StringGrid1.Cells[1,0] := ResponseVarY.OutputTerm;
    StringGrid1.Cells[0,n+1] := 'Mean';
    StringGrid1.Cells[0,n+2] := 'Std Dev';
    StringGrid1.Cells[0,n+3] := 'Max';
    StringGrid1.Cells[0,n+4] := 'Min';
    StringGrid1.Cells[1,n+1] := floatToStrF(yBar,ffFixed,7,3);
    StringGrid1.Cells[1,n+2] := floatToStrF(yStdErr,ffFixed,7,3);
    StringGrid1.Cells[1,n+3] := floatToStrF(yMax,ffFixed,7,3);
    StringGrid1.Cells[1,n+4] := floatToStrF(yMin,ffFixed,7,3);
    for j:= 1 to nControls do
     begin
      StringGrid1.Cells[j+2,0] := cVariable[j].OutputTerm;
      StringGrid1.Cells[j+2,n+1] := floatToStrF(xBar[j],ffFixed,7,3);
      StringGrid1.Cells[j+2,n+2] := floatToStrF(xStdErr[j],ffFixed,7,3);
      StringGrid1.Cells[j+2,n+3] := floatToStrF(xMax[j],ffFixed,7,3);
      StringGrid1.Cells[j+2,n+4] := floatToStrF(xMin[j],ffFixed,7,3);
     end;
    for i:= 1 to n do
     begin
      StringGrid1.Cells[0,i] := intToStr(i);
      StringGrid1.Cells[1,i] := floatToStrF(y[i],ffFixed,7,3);
      for j:= 1 to nControls do
       StringGrid1.Cells[j+2,i] := floatToStrF(x[i,j],ffFixed,7,3);
     end
   end
end;

procedure TForm1.bbtnOutputClick(Sender: TObject);
begin
 if bbtnTable.Enabled then
  Table.Output
 else
  Query.Output
end;

procedure TForm1.bbtnPlotsClick(Sender: TObject);
begin
 if bbtnTable.Enabled then
  Table.ShowPlots
 else
  Query.ShowPlots
end;

procedure TForm1.Enablebbtn(var bbtn1,bbtn2: TBitBtn);
begin
 bbtn1.Enabled := True;
 bbtn2.Enabled := False
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
 bbtnOptimize.Enabled := False;
 bbtnOutput.Enabled := False;
 bbtnPlots.Enabled := False;
 StringGrid1.Enabled := False;
 with ComboBox1 do
  case ItemIndex of
   0: begin
       Enablebbtn(bbtnTable,bbtnQuery);
       Table := MLRTable1;
      end;
   1: begin
       Enablebbtn(bbtnQuery,bbtnTable);
       Query := MLRQuery1;
      end;
   2: begin
       Enablebbtn(bbtnTable,bbtnQuery);
       Table := MLRTable2;
      end;
   3: begin
       Enablebbtn(bbtnTable,bbtnQuery);
       Table := MLRTable3;
      end;
   4: begin
       Enablebbtn(bbtnTable,bbtnQuery);
       Table := MLRTable4;
      end;
   5: begin
       Enablebbtn(bbtnQuery,bbtnTable);
       Query := MLRQuery2;
      end;
   6: begin
       Enablebbtn(bbtnQuery,bbtnTable);
       Query := MLRQuery3;
      end;
   7: begin
       Enablebbtn(bbtnTable,bbtnQuery);
       Table := MLRTable5;
      end;
  end;  { case }
 Memo1.Visible := False;
 DBMemo1.Visible := True;
 SampleDataTable.FindKey([ComboBox1.ItemIndex]);
 Screen.Cursor := crHourGlass;
 if bbtnTable.Enabled then
  begin
   Table.Close;
   Table.DatabaseName := ExtractFilePath(Application.ExeName);
   Table.Open;
   TableSource.Dataset := Table;
   DBGrid1.DataSource := TableSource
  end
 else
  begin
   Query.Close;
   Query.DatabaseName := ExtractFilePath(Application.ExeName);
   Query.Open;
   QuerySource.Dataset := Query;
   DBGrid1.DataSource := QuerySource
  end;
 Screen.Cursor := crDefault;
end;

procedure TForm1.bbtnCloseClick(Sender: TObject);
begin
 Close
end;

procedure TForm1.bbtnOptimizeClick(Sender: TObject);
var msg: string;
begin
 if bbtnTable.Enabled then
  begin
   optimizeTable(Table,NONDOMINATED);
   bbtnTableClick(Sender)
  end;
 if bbtnQuery.Enabled then
  begin
   optimizeQuery(Query,NONDOMINATED);
   bbtnQueryClick(Sender)
  end;
 msg := 'This project uses a demo version of'+#10#13+
        'Optigress.'+#10#13+#10#13+
        'Optigress is a separate product, and'+#10#13+
        'is NOT included with MLRegress.'+#10#13+#10#13+
        'Contact Applied Analytic Systems'+#10#13+
        'for ordering instructions.';
 MessageDlg(msg,mtInformation,[mbOK],0);
 bbtnOptimize.Enabled := False;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
 SampleDataTable.Close;
 SampleDataTable.DatabaseName := ExtractFilePath(Application.ExeName);
 SampleDataTable.Open;
end;

end.
