unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Meta;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    sFile: TEdit;
    Label1: TLabel;
    btnBrowse: TButton;
    OpenDialog1: TOpenDialog;
    Shape1: TShape;
    Metadata1: TMetadata;
    Label2: TLabel;
    btnCreate: TButton;
    btnRebuild: TButton;
    btnCompact: TButton;
    btnRepair: TButton;
    Button5: TButton;
    procedure btnBrowseClick(Sender: TObject);
    procedure btnCreateClick(Sender: TObject);
    procedure btnRebuildClick(Sender: TObject);
    procedure btnCompactClick(Sender: TObject);
    procedure btnRepairClick(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.btnBrowseClick(Sender: TObject);
begin
  if OpenDialog1.Execute then sFile.Text := OpenDialog1.FileName;
end;

procedure TMainForm.btnCreateClick(Sender: TObject);
begin
  Metadata1.CreateDatabase( sFile.Text, True );
end;

procedure TMainForm.btnRebuildClick(Sender: TObject);
begin
  Metadata1.RebuildDatabase( sFile.Text );
end;

procedure TMainForm.btnCompactClick(Sender: TObject);
begin
  Metadata1.CompactDatabase( sFile.Text );
end;

procedure TMainForm.btnRepairClick(Sender: TObject);
begin
  Metadata1.RepairDatabase( sFile.Text );
end;

procedure TMainForm.Button5Click(Sender: TObject);
begin
  Close;
end;

end.
