{$DEFINE Shareware}
unit PopUpEdit;

interface

uses
	 Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	 StdCtrls, DBCtrls, DB, dsgnintf, uLookupAbout
	 {$IFDEF Shareware}, ShareWare{$ENDIF};


type
	 TPopUpEditEditor = class (TComponentEditor)
		 function GetVerbCount: integer; override;
		 function GetVerb(Index: integer): string; override;
		 procedure ExecuteVerb(Index: integer); override;
	 end;

	 TPopUpAction = (paPost, paCancel);
	 TKeyMode = (kmAutoInc, kmManual);
	 TPopUpCloseEvent = procedure(var KeyValue: variant; DataValue: string; var Action: TPopUpAction) of object;
	 TPopUpEdit = class(TCustomEdit)
	 private
		 FCombo: TDBLookupComboBox;
		 FOnPopUpClose: TPopUpCloseEvent;
		 FCancelOnExit: boolean;
		 FKeyMode: TKeyMode;
		 FKeyValue: variant;
		 FKeyField: TFieldDataLink;
		 FDataField: TFieldDataLink;
		 FListField: TFieldDataLink;
	 protected
		 procedure KeyPress(var Key: Char); override;
		 procedure DoExit; override;
		 procedure SetCombo(Combo: TDBLookupComboBox); virtual;
		 function GetCombo: TDBLookupComboBox; virtual;
		 procedure SetDatasource(ADatasource: TDatasource);
		 function GetDatasource: TDatasource;
		 procedure ClearFields;
		 procedure Notification(AComponent: TComponent; Operation: TOperation); override;
		 procedure UpdateMaster;
	 public
		 constructor Create(AOwner: TComponent);override;
		 destructor Destroy; override;
		 procedure Loaded; override;
		 procedure PopUp(s: string);
		 procedure PostData(var KeyValue: variant; DataValue: string);
		 property Text;
	 published
		 property AutoSelect;
		 property AutoSize;
		 property BorderStyle;
		 property CancelOnExit: boolean read FCancelOnExit write FCancelOnExit;
		 property CharCase;
		 property Color;
		 property ComboBox: TDBLookupComboBox read FCombo write FCombo;
		 property Ctl3D;
		 property Enabled;
		 property Font;
		 property HideSelection;
		 property MaxLength;
		 property OEMConvert;
		 property ParentColor;
		 property ParentCtl3D;
		 property ParentFont;
		 property ParentShowHint;
		 property PasswordChar;
		 property PopupMenu;
		 property ReadOnly;
		 property ShowHint;
		 property TabOrder;
		 property TabStop;
		 property OnChange;
		 property OnClick;
		 property OnDblClick;
		 property OnKeyDown;
		 property OnKeyPress;
		 property OnKeyUp;
		 property OnMouseDown;
		 property OnMouseMove;
		 property OnMouseUp;
		 property OnPopUpClose: TPopUpCloseEvent read FOnPopUpClose write FOnPopUpClose;
	 end;

procedure Register;

implementation

procedure Register;
begin
	 RegisterComponentEditor(TPopUpEdit, TPopUpEditEditor);
	 RegisterComponents('Data Controls', [TPopUpEdit]);
end;

function TPopUpEditEditor.GetVerbCount: integer;
begin
	 result := 1;
end;

function TPopUpEditEditor.GetVerb(index: integer): string;
begin
	 result := 'About';
end;

procedure TPopUpEditEditor.ExecuteVerb(index: integer);
var About: TAboutBox;
begin
	 About := TAboutBox.Create(Application);
	 About.Component := Component;
	 About.ShowModal;
	 About.Destroy;
end;

constructor TPopUpEdit.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	 {$IFDEF Shareware}
		if (not (csDesigning in ComponentState)) and (not kp_ShareWareCheck) then
			raise EComponentError.CreateFmt('%s: Cannot run outside of IDE. To register contact Karl Pienaar at kgp@iafrica.com', [name]);
  {$ENDIF}
	 FKeyField := TFieldDataLink.Create;
	 FKeyField.Control := self;
	 FDataField := TFieldDataLink.Create;
	 FDataField.Control := self;
	 FListField := TFieldDataLink.Create;
	 FListField.Control := self;
	 FKeyMode := kmManual;
	 Visible := False;
	 Ctl3D := False;
	 FCancelOnExit := False;
end;

destructor TPopUpEdit.Destroy;
begin
	 ClearFields;
	 if FKeyField <> nil then FKeyField.Destroy;
	 if FDataField <> nil then FDataField.Destroy;
	 if FListField <> nil then FListField.Destroy;
	 inherited Destroy;
end;

procedure TPopUpEdit.ClearFields;
begin
	 if FKeyField <> nil then	FKeyField.FieldName := '';
	 if FDataField <> nil then FDataField.FieldName := '';
	 if FListField <> nil then FListField.FieldName := '';
end;

procedure TPopUpEdit.Notification(AComponent: TComponent;
	 Operation: TOperation);
begin
	 inherited Notification(AComponent, Operation);
	 if Operation = opRemove then
	 begin
		 if AComponent = FCombo then begin
			FCombo := nil;
			ClearFields;
		 end else if (FDataField <> nil) or (FKeyField <> nil) or (FListField <> nil) then
				 if (AComponent = FDatafield.Datasource)
				 or (AComponent = FKeyfield.Datasource) then
			 ClearFields;
	 end;
end;

procedure TPopUpEdit.DoExit;
var Action: TPopUpAction;
begin
	visible := False;
	Action := paPost;
	if FCancelOnExit then
	begin
		Text := '';
		exit;
	end
	else begin
		if FKeyField.Field is TAutoIncField then begin
			FKeyMode := kmAutoInc;
			UpdateMaster;
			if assigned(FOnPopUpClose)then
				FOnPopUpClose(FKeyValue, Text, Action);
		end else begin
			FKeyMode := kmManual;
			if assigned(FOnPopUpClose)then
				FOnPopUpClose(FKeyValue, Text, Action);
			UpdateMaster;
		end;
	end;
	if Action = paPost then
		PostData(FKeyValue, Text);
	Text := '';
	if Visible then
		Visible := False;
	inherited DoExit;
end;

function TPopUpEdit.GetCombo: TDBLookupComboBox;
begin
	result := FCombo;
end;

function TPopUpEdit.GetDatasource: TDatasource;
begin
	result := FDataField.DataSource;
end;

procedure TPopUpEdit.KeyPress(var Key: Char);
var temp: boolean;
begin
	inherited KeyPress(Key);
	temp := FCancelOnExit;
	if (Key in [#13, #9, #10, #27]) then
	begin
	 if Key = #27 then
	 begin
		FCancelOnExit := true;
	 end;
	Visible := False;
	Text := '';
	FCancelOnExit := temp;
	end;
end;

procedure TPopUpEdit.Loaded;
begin
	inherited Loaded;
	Visible := False;
end;

procedure TPopUpEdit.PopUp(s: string);
begin
	if not Assigned(FCombo) then
		raise EComponentError.CreateFmt('%s: ComboBox Property Not Assigned', [Name]);
	Parent := FCombo.Parent;
	SetBounds(FCombo.Left, FCombo.Top, FCombo.Width, FCombo.Height);
	SetCombo(FCombo);
	SetZOrder(True);
	Visible := True;
	SetFocus;
	Text := s;
	SelStart := length(s);
end;

procedure TPopUpEdit.PostData(var KeyValue: variant; DataValue: string);
begin
try
		if not FDataField.Edit then
			raise EDatabaseError.CreateFmt('%s: Cannot edit Field %s of %s.',
					[name, FDataField.FieldName, FDataField.Datasource.Dataset.Name]);
		FDataField.Field.AsVariant := FKeyValue;
		FDataField.UpdateRecord;
except
	raise;
end;
end;

procedure TPopUpEdit.SetCombo(Combo: TDBLookupComboBox);
//var fldTemp: TFieldDataLink;
begin
	try
		begin
			if FCombo <> nil then	begin
				if FCombo.DataSource.DataSet.FieldByName(FCombo.DataField).FieldKind = fkLookup then{ begin
					fldTemp := TFieldDataLink.Create;
					fldTemp.DataSource := FCombo.DataSource;
					fldTemp.FieldName := FCombo.DataField;
					if (Pos(';',fldTemp.Field.LookupKeyFields) > 0) then
							raise EComponentError.CreateFmt('%s: %s has more than 1 KeyField' +
									#13 + #10 + 'Only 1 LookupKeyField supported', [Name, FCombo.DataField]);
						FDataField.Datasource := FCombo.DataSource;
						FDataField.FieldName := FCombo.DataField;
						FKeyField.Field := fldTemp.Field.LookupDataSet.FieldByName(fldTemp.Field.LookupKeyFields);
						FKeyField.FieldName := fldTemp.Field.LookupKeyFields;
						FListField.Datasource.DataSet := fldTemp.Field.LookupDataSet;
						FListField.FieldName := fldTemp.Field.LookupResultField;
				end else begin}
					raise EComponentError.CreateFmt('%s: %s LookupFields not supported', [Name, FCombo.DataField]);
				if (FCombo.DataField = '') or (FCombo.ListField = '')
					or (FCombo.KeyField = '') then
						raise EDatabaseError.CreateFmt('%s: datafields not set', [FCombo.name]);
				 SetDatasource(Combo.DataSource);
				 FDataField.DataSource := FCombo.DataSource;
				 FDataField.FieldName := FCombo.DataField;
				 FKeyField.DataSource := FCombo.ListSource;
				 FKeyField.FieldName := FCombo.KeyField;
				 FListField.DataSource := FCombo.ListSource;
				 FListField.FieldName := FCombo.ListField;
				//end;
			end;
		end;
//		fldTemp.Destroy;
	except
		raise;
	end;
end;

procedure TPopUpEdit.SetDatasource(ADatasource: TDatasource);
begin
		FDatafield.DataSource := ADatasource;
end;

procedure TPopUpEdit.UpdateMaster;
begin
		FKeyField.DataSource.DataSet.Insert;
		FListField.Edit;
		FListField.Field.Text := Text;
		if FKeyMode = kmManual then begin
			FKeyField.Field.AsVariant := FKeyValue;
			if (VarIsEmpty(FKeyValue)) or (VarIsNull(FKeyValue)) then
					raise EDatabaseError.CreateFmt('%s: No value for KeyField %s', [Name, FKeyField.FieldName]);
		end;
		FKeyField.DataSource.DataSet.Post;
		FKeyValue := FKeyField.Field.AsVariant;
{		if not FKeyField.Edit then
			raise EDatabaseError.CreateFmt('%s: Cannot edit Field %s of %s.',
					[name, FKeyField.FieldName, FKeyField.Datasource.Dataset.Name]);
		FKeyField.Field.AsVariant := FKeyValue;
		if not FListField.Edit then
			raise EDatabaseError.CreateFmt('%s: Cannot edit Field %s of %s.',
					[name, FListField.FieldName, FListField.Datasource.Dataset.Name]);
		FListField.Field.Text := Text;
		FListField.UpdateRecord;}
end;
end.
