unit UPrinter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IOPort;

type
  TFormPrinter = class(TForm)
    Memo: TMemo;
    ButtonPrint: TButton;
    IOPort: TIOPort;
    procedure ButtonPrintClick(Sender: TObject);
  private
    { Private declarations }
    procedure PrintChar(Value: Char);
    procedure PrintString(const Value: String);
  public
    { Public declarations }
  end;

var
  FormPrinter: TFormPrinter;

implementation

{$R *.DFM}

procedure TFormPrinter.PrintChar(Value: Char);
const Timeout = 5000; // timeout in ms
var Ticks: Integer; // tick counter
begin
  Ticks := GetTickCount + Timeout;
  while (IOPort.Port[$379] and $80) = 0 do // wait for not busy
    if GetTickCount > Ticks then
      raise Exception.Create('Timeout');

  IOPort.Port[$378] := Ord(Value); // data

  IOPort.Port[$37A] := IOPort.Port[$37A] and not 1; // strobe impuls
  IOPort.Port[$37A] := IOPort.Port[$37A] or 1;
end;

procedure TFormPrinter.PrintString(const Value: String);
var i: Integer;
begin
  for i := 1 to Length(Value) do
    PrintChar(Value[i]);
end;

procedure TFormPrinter.ButtonPrintClick(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    PrintString(Memo.Lines.Text);
  finally
    Screen.Cursor := crDefault;
  end;
end;

end.
