unit timemain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, agsocket, Agtime, ComCtrls, ToolWin, ExtCtrls, Buttons;

type
  TTimeForm = class(TForm)
    agTime1: TagTime;
    StatusBar: TStatusBar;
    Panel1: TPanel;
    ServerComboBox: TComboBox;
    Label3: TLabel;
    PaintBox1: TPaintBox;
    Label1: TLabel;
    ConnectButton: TSpeedButton;
    CancelButton: TSpeedButton;
    Label2: TLabel;
    procedure agTime1Closed(Sender: TObject);
    procedure agTime1Open(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ConnectButtonClick(Sender: TObject);
    procedure agTime1Connected(Sender: TObject);
  private
    { Private declarations }
    procedure DrawClock(DT : TDateTime);
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  TimeForm: TTimeForm;

implementation

{$R *.DFM}

procedure TTimeForm.agTime1Closed(Sender: TObject);
begin
  StatusBar.SimpleText:='Connection closed';
end;

procedure TTimeForm.agTime1Open(Sender: TObject);
begin
  StatusBar.SimpleText:='Opening connection';
end;

procedure TTimeForm.FormCreate(Sender: TObject);
begin
  ServerComboBox.ItemIndex:=0;
end;

procedure TTimeForm.EnableControls;
begin
  ServerComboBox.Enabled:=true;
  ConnectButton.Enabled:=true;
  CancelButton.Enabled:=false;
end;

procedure TTimeForm.DisableControls;
begin
  ServerComboBox.Enabled:=false;
  ConnectButton.Enabled:=false;
  CancelButton.Enabled:=true;
end;

procedure TTimeForm.DrawClock(DT : TDateTime);
var
  Hour, Min, Sec, MSec : word;
  r : Integer;
  Angle : real;
begin
  DecodeTime(DT,Hour,Min,Sec,MSec);
  if Hour>12 then Hour:=Hour-12;
  with PaintBox1 do
  begin
    Canvas.Brush.Color:=clBtnFace;
    Canvas.Pen.Color:=clBlue;
    Canvas.Pen.Width:=2;
    Canvas.Ellipse(2,2,Width-2,Height-2);
    Canvas.Pen.Width:=4;
    Canvas.Pen.Color:=clRed;
    Canvas.MoveTo(Width div 2, Height div 2);
    r:=(Width div 2)-15;
    Angle:=pi*Hour/6+2*pi*Min/12/60;
    Canvas.LineTo(Width div 2+Round(r*Sin(Angle)),Width div 2-Round(r*Cos(Angle)));
    Canvas.MoveTo(Width div 2, Height div 2);
    r:=(Width div 2)-4;
    Angle:=pi*Min/30;
    Canvas.LineTo(Width div 2+Round(r*Sin(Angle)),Width div 2-Round(r*Cos(Angle)));
    Canvas.MoveTo(Width div 2, Height div 2);
    r:=(Width div 2)-4;
    Angle:=pi*Sec/30;
    Canvas.Pen.Color:=clGreen;
    Canvas.Pen.Width:=1;
    Canvas.LineTo(Width div 2+Round(r*Sin(Angle)),Width div 2-Round(r*Cos(Angle)));
  end;
end;

procedure TTimeForm.ConnectButtonClick(Sender: TObject);
begin
  DisableControls;
  agTime1.Server:=ServerComboBox.Text;
  try
    agTime1.Execute;
    Label1.Caption:=FormatDateTime('ddd, mmm dd yyyy',agTime1.DateTime);
    Label2.Caption:=FormatDateTime('hh:mm:ss "UTC"',agTime1.DateTime);
    DrawClock(agTime1.DateTime);
  finally
    EnableControls;
  end;
end;

procedure TTimeForm.agTime1Connected(Sender: TObject);
begin
  StatusBar.SimpleText:='Connected to server';
end;


end.
