unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  IEMIO, StdCtrls, ImageEnView, IEMView, ImageEnIO, Buttons, ImageEnProc,
  ComCtrls, ExtCtrls, IEOpenSaveDlg;

type
  TForm1 = class(TForm)
    ImageEnMView1: TImageEnMView;
    ImageEnMIO1: TImageEnMIO;
    ImageEnProc1: TImageEnProc;
    ImageEnIO1: TImageEnIO;
    Panel1: TPanel;
    GroupBox4: TGroupBox;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    GroupBox2: TGroupBox;
    SpeedButton2: TSpeedButton;
    Label1: TLabel;
    Edit1: TEdit;
    UpDown1: TUpDown;
    CheckBox3: TCheckBox;
    GroupBox3: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    OpenImageEnDialog1: TOpenImageEnDialog;
    OpenImageEnDialog2: TOpenImageEnDialog;
    SaveImageEnDialog1: TSaveImageEnDialog;
    Label2: TLabel;
    Label3: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ImageEnMView1ImageDraw(Sender: TObject; idx, Left,
      Top: Integer; Canvas: TCanvas);
    procedure Button5Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure ImageEnMView1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses GifLZW, TIFLZW;

// Load
procedure TForm1.Button1Click(Sender: TObject);
begin
	if OpenImageEnDialog2.Execute then
   	ImageEnMIO1.LoadFromFile(OpenImageEnDialog2.FileName);
end;

// Save
procedure TForm1.Button2Click(Sender: TObject);
begin
	if SaveImageEnDialog1.Execute then
   	ImageEnMIO1.SaveToFile(SaveImageEnDialog1.FileName);
end;

// Select TWain
procedure TForm1.Button3Click(Sender: TObject);
begin
	ImageEnMIO1.SelectAcquireSource;
end;

// Aqcuire TWain
procedure TForm1.Button4Click(Sender: TObject);
begin
	ImageEnMIO1.Acquire;
end;

procedure TForm1.ImageEnMView1ImageDraw(Sender: TObject; idx, Left,
  Top: Integer; Canvas: TCanvas);
begin
   with canvas do begin
      Font.Height:=15;
      Font.Color:=clBlack;
      textout(Left,Top,inttostr(idx)+': '+inttostr(imageenmview1.ImageWidth[idx])+' x '+inttostr(imageenmview1.ImageHeight[idx]));
   end;
end;

// Clear
procedure TForm1.Button5Click(Sender: TObject);
begin
	ImageEnMView1.Clear;
end;

// Play
procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
	imageenmview1.playing:=SpeedButton2.Down;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
	if CheckBox1.Checked then
		ImageEnMView1.StoreType:=ietThumb
   else
   	ImageEnMView1.StoreType:=ietNormal;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
	ImageEnMView1.VisibleSelection:=CheckBox2.Checked;
end;


// GIF parameters
procedure TForm1.Button6Click(Sender: TObject);
begin
	ImageEnMIO1.DoPreviews( ImageEnMView1.SelectedImage,[ppGIF] );
end;

// TIFF parameters
procedure TForm1.Button7Click(Sender: TObject);
begin
	ImageEnMIO1.DoPreviews( ImageEnMView1.SelectedImage,[ppTIFF] );
end;

// Effects
procedure TForm1.Button8Click(Sender: TObject);
begin
	ImageEnProc1.DoPreviews([peAll]);
end;

// Insert
procedure TForm1.Button9Click(Sender: TObject);
var
	tempbmp:TBitmap;
   idx:integer;
begin
	idx:=ImageEnMView1.SelectedImage;
   if idx<0 then idx:=0;
	ImageEnMView1.InsertImage( idx );
   tempbmp:=TBitmap.create;
   tempbmp.width:=ImageEnMView1.ThumbWidth;
	tempbmp.height:=ImageEnMView1.ThumbHeight;
   tempbmp.pixelformat:=pf24bit;
   ImageEnMView1.SetImage(idx,tempbmp);
   tempbmp.free;
end;

// Append
procedure TForm1.Button10Click(Sender: TObject);
var
	tempbmp:TBitmap;
   idx:integer;
begin
	idx:=ImageEnMView1.AppendImage;
   tempbmp:=TBitmap.create;
   tempbmp.width:=ImageEnMView1.ThumbWidth;
	tempbmp.height:=ImageEnMView1.ThumbHeight;
   tempbmp.pixelformat:=pf24bit;
   ImageEnMView1.SetImage(idx,tempbmp);
   tempbmp.free;
end;

// Delete
procedure TForm1.Button11Click(Sender: TObject);
begin
	if ImageEnMView1.SelectedImage>=0 then
   	ImageEnMView1.DeleteImage( ImageEnMView1.SelectedImage );
end;

// Copy
procedure TForm1.Button12Click(Sender: TObject);
begin
	ImageEnProc1.CopyToClipboard;
end;

// Paste
procedure TForm1.Button13Click(Sender: TObject);
begin
	ImageEnProc1.PasteFromClipboard;
end;

// Load image
procedure TForm1.Button14Click(Sender: TObject);
begin
	if OpenImageEnDialog1.Execute then
   	//ImageEnIO1.LoadFromFile( OpenImageEnDialog1.FileName );
      ImageEnMView1.SetImageFromFile( ImageEnMView1.SelectedImage, OpenImageEnDialog1.FileName );
     
end;


// Grid columns
procedure TForm1.Edit1Change(Sender: TObject);
begin
	ImageEnMView1.GridWidth:=strtointdef(edit1.text,0);
end;

// Auto
procedure TForm1.CheckBox3Click(Sender: TObject);
begin
	if checkbox3.checked then begin
   	edit1.enabled:=false;
      ImageEnMView1.GridWidth:=-1;
   end else begin
   	edit1.enabled:=true;
      ImageEnMView1.GridWidth:=strtointdef(edit1.text,0);
   end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
   DefGIF_LZWDECOMPFUNC:=GIFLZWDecompress;
   DefGIF_LZWCOMPFUNC:=GIFLZWCompress;
   DefTIFF_LZWDECOMPFUNC:=TIFFLZWDecompress;
   DefTIFF_LZWCOMPFUNC:=TIFFLZWCompress;
	Edit2.Text:=IntToStr( ImageEnMView1.ThumbWidth );
   Edit3.Text:=IntToStr( ImageEnMView1.ThumbHeight );
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
	ImageEnMView1.ThumbWidth:=StrToIntDef( Edit2.Text, 0 );
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
	ImageEnMView1.ThumbHeight:=StrToIntDef( Edit3.Text, 0 );
end;

procedure TForm1.ImageEnMView1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
	showmessage(inttostr(key));
end;

end.
