unit CUnit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ICT_SC, OleCtrls;

type
  TMAIN = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    ICT_SCRCAP1: TICT_SCRCAP;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ICT_SCRCAP1Timer(Sender: TObject);
    procedure ICT_SCRCAP1HotKey(Sender: TObject; Index: Integer);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MAIN: TMAIN;
  Result:integer;


implementation

{$R *.DFM}

procedure TMAIN.Button1Click(Sender: TObject);
begin
     Result:=ICT_SCRCAP1.OpenAVI(ICT_SCRCAP1.AVIFilename);
     if Result > 0 then
     showmessage('Error ='+IntToStr(Result));

     Button1.Enabled := false;
     Button2.Enabled := true;
     Button4.Enabled := true;
end;

procedure TMAIN.Button2Click(Sender: TObject);
begin
     Result:=ICT_SCRCAP1.CaptureScreen;
     if Result > 0 then
     showmessage('Error ='+IntToStr(Result));
     Button1.Enabled := false;
     Button3.Enabled := true;
end;

procedure TMAIN.Button3Click(Sender: TObject);
begin
     screen.Cursor := crHourGlass;
     try
        Result:=ICT_SCRCAP1.CloseAVI;
     except
        showmessage('Error ='+IntToStr(Result));
     end;
     screen.Cursor := crDefault;
     Application.Terminate;
end;

procedure TMAIN.Button4Click(Sender: TObject);
begin
     If Button4.Caption = '&Time Capture' then
     begin
        ICT_SCRCAP1.TimerEnabled := True;
        Button4.Caption := '&Stop Time Capture'
     end
     else
     begin
        ICT_SCRCAP1.TimerEnabled := False;
        Button4.Caption := '&Time Capture';
     end;
     Button1.Enabled := false;
     Button3.Enabled := true;
end;

procedure TMAIN.FormCreate(Sender: TObject);
begin
     ICT_SCRCAP1.AddHotKey(VKSpace, []);
     Button2.Enabled := false;
     Button3.Enabled := false;
     Button4.Enabled := false;
     Application.ShowHint := True;
     
end;


procedure TMAIN.ICT_SCRCAP1Timer(Sender: TObject);
begin
     Result:=ICT_SCRCAP1.CaptureScreen;
     if Result > 0 then
     showmessage('Error ='+IntToStr(Result));
end;



procedure TMAIN.ICT_SCRCAP1HotKey(Sender: TObject; Index: Integer);
begin
  case Index of
    0 :
    begin
    if main.Visible then
       main.visible := false
    else
       main.visible := true;
    end;

end;

end;


end.
