unit test2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, HImages, StdCtrls, Spin, CustomHImages;

type
  TForm1 = class(TForm)
    ShowHotspotsBtn: TButton;
    GroupBox1: TGroupBox;
    SpinEdit1: TSpinEdit;
    ColorBtn: TButton;
    ColorDialog1: TColorDialog;
    HyperImages1: THyperImages;
    GroupBox2: TGroupBox;
    ListBox1: TListBox;
    RadioGroup1: TRadioGroup;
    GroupBox3: TGroupBox;
    ScaleSpinEdit: TSpinEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ShowHotspotsBtnClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure ColorBtnClick(Sender: TObject);
    procedure HyperImages1ImageMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure RadioGroup1Click(Sender: TObject);
    procedure ScaleSpinEditChange(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  HyperImages1.PicturesDir := ExtractFilePath(Application.ExeName)+ 'Images';
  ListBox1.Items := HyperImages1.Pictures;
  ColorDialog1.Color := HyperImages1.HotspotsPen.Color;
  SpinEdit1.Value := HyperImages1.HotspotsPen.Width;
  HyperImages1.LoadImageFromFile(ListBox1.Items[0]); 
  ListBox1.ItemIndex := HyperImages1.Pictures.IndexOf(HyperImages1.PictureFilename);
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
begin
  with ListBox1 do HyperImages1.LoadImageFromFile(Items[ItemIndex]);
end;

procedure TForm1.ShowHotspotsBtnClick(Sender: TObject);
begin
  with HyperImages1 do ShowHotspots := not ShowHotspots;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  HyperImages1.HotspotsPen.Width := SpinEdit1.Value;
end;


procedure TForm1.ColorBtnClick(Sender: TObject);
begin
  if ColorDialog1.Execute then
    HyperImages1.HotspotsPen.Color := ColorDialog1.Color;
end;

procedure TForm1.HyperImages1ImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  S: String;
  Pt: TPoint;
begin
  with HyperImages1 do begin
    Pt := ClientToScreen(Point(X, Y));
    if PointIsOnTarget(X, Y, S) then begin
      if PictureFileName = 'dog1.bmp' then begin
        if S = 'back leg' then begin
          MessageDlgPos('back leg', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'back leg' then begin
          MessageDlgPos('back leg', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'back' then begin
          MessageDlgPos('back', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'chest' then begin
          MessageDlgPos('chest', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'front leg' then begin
          MessageDlgPos('front leg', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'head' then begin
          MessageDlgPos('head', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'neck' then begin
          MessageDlgPos('neck', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'tail' then begin
          MessageDlgPos('tail', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end;
      end else
      if PictureFileName = 'dog2.bmp' then begin
        if S = 'back leg' then begin
          MessageDlgPos('back leg', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'back' then begin
          MessageDlgPos('back', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'chest' then begin
          MessageDlgPos('chest', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'colar' then begin
          MessageDlgPos('colar', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'front leg' then begin
          MessageDlgPos('front leg', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'head' then begin
          MessageDlgPos('head', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'tail' then begin
          MessageDlgPos('tail', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end else
        if S = 'dog house' then begin
          MessageDlgPos('dog house', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
        end;
      end;
    end else begin
      MessageDlgPos('Nothing here', mtCustom, [mbOK], 0, Pt.X, Pt.Y);
      {Your code when no target is hit}
    end;
  end;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  with RadioGroup1 do
    case ItemIndex of
      0: begin
           HyperImages1.AutoScalePanel := True;
           ScaleSpinEdit.Value := HyperImages1.Scale;
           ScaleSpinEdit.Enabled := True;
         end;
      1: begin
           HyperImages1.AutoScaleImage := True;
           HyperImages1.Width := 400;
           HyperImages1.Height := 150;
           ScaleSpinEdit.Value := HyperImages1.Scale;
           ScaleSpinEdit.Enabled := False;
         end;
    end;
end;

procedure TForm1.ScaleSpinEditChange(Sender: TObject);
begin
  HyperImages1.Scale := ScaleSpinEdit.Value;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  HyperImages1.HintOnHot := CheckBox1.Checked;
end;


procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  HyperImages1.InvertOnHot := CheckBox2.Checked;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  if CheckBox3.Checked then
    HyperImages1.Hotcursor := crHandpoint else
    HyperImages1.Hotcursor := crDefault;
end;

end.

















