unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, HTMLImp, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    N2: TMenuItem;
    HTMLImport1: THTMLImport;
    OpenDialog1: TOpenDialog;
    N3: TMenuItem;
    Clear1: TMenuItem;
    ListView1: TListView;
    procedure Open1Click(Sender: TObject);
    procedure HTMLImport1ImportURL(Sender: TObject; Lab, URL: String);
    procedure ListView1DblClick(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  ShellApi;

var
  BaseUrl: String = 'http://www.microsoft.com/';

procedure TForm1.Open1Click(Sender: TObject);
var
  LinksCnt: Integer;
begin
  with OpenDialog1 do
    if Execute then
    begin
      if InputQuery('Enter base URL', 'Base URL:', BaseUrl) then
      begin
        HTMLImport1.BaseURL:=BaseUrl;
        LinksCnt:=HTMLImport1.ImportFromFile(FileName);
        StatusBar1.SimpleText:=Format('%d links extracted',[LinksCnt]);
      end;
    end;
end;

procedure TForm1.HTMLImport1ImportURL(Sender: TObject; Lab, URL: String);
begin
  with ListView1.Items.Add do
  begin
    Caption:=URL;
    Subitems.Add(Lab);
  end;
end;

procedure TForm1.ListView1DblClick(Sender: TObject);
begin
  with ListView1 do
    if Selected<>nil then
      ShellExecute(0, 'open', PChar(Selected.Caption), '', '', SW_SHOW); 
end;

procedure TForm1.Clear1Click(Sender: TObject);
begin
  with ListView1.Items do
  try
    BeginUpdate;
    Clear;
  finally
    EndUpdate;
  end;
end;

end.
