// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'htmlabel.pas' rev: 5.00

#ifndef htmlabelHPP
#define htmlabelHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Menus.hpp>	// Pascal unit
#include <ActiveX.hpp>	// Pascal unit
#include <ComObj.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Htmlabel
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TPicturePosition { bpTopLeft, bpTopRight, bpBottomLeft, bpBottomRight, bpCenter, bpTiled, bpStretched 
	};
#pragma option pop

struct TInternetContent;
typedef TInternetContent *PInternetContent;

class DELPHICLASS TWebPicture;
typedef void __fastcall (__closure *TDownloadProgressEvent)(System::TObject* Sender, unsigned dwSize
	, unsigned dwTotSize);

typedef void __fastcall (__closure *TDownloadCancelEvent)(System::TObject* Sender, bool &Cancel);

typedef void __fastcall (__closure *TDownloadCompleteEvent)(System::TObject* Sender);

typedef void __fastcall (__closure *TDownloadErrorEvent)(System::TObject* Sender, AnsiString err);

class PASCALIMPLEMENTATION TWebPicture : public Graphics::TGraphic 
{
	typedef Graphics::TGraphic inherited;
	
private:
	Classes::TMemoryStream* fDatastream;
	bool fIsEmpty;
	bool fStretched;
	_di_IPicture gpPicture;
	int fLogPixX;
	int fLogPixY;
	AnsiString fURL;
	AnsiString fID;
	bool fAsynch;
	bool fThreadBusy;
	TDownloadProgressEvent fOnDownLoadProgress;
	TDownloadCancelEvent fOnDownLoadCancel;
	TDownloadCompleteEvent fOnDownLoadComplete;
	TDownloadErrorEvent fOnDownLoadError;
	void __fastcall LoadPicture(void);
	
protected:
	virtual bool __fastcall GetEmpty(void);
	virtual int __fastcall GetHeight(void);
	virtual int __fastcall GetWidth(void);
	virtual void __fastcall SetHeight(int Value);
	virtual void __fastcall SetWidth(int Value);
	virtual void __fastcall ReadData(Classes::TStream* Stream);
	virtual void __fastcall WriteData(Classes::TStream* Stream);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const Windows::TRect &Rect);
	void __fastcall DownLoadError(AnsiString err);
	void __fastcall DownLoadComplete(void);
	void __fastcall DownLoadCancel(bool &cancel);
	void __fastcall DownLoadProgress(unsigned dwSize, unsigned dwTotSize);
	
public:
	__fastcall virtual TWebPicture(void);
	__fastcall virtual ~TWebPicture(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall LoadFromFile(const AnsiString FileName);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromResourceName(unsigned Instance, const AnsiString ResName);
	void __fastcall LoadFromResourceID(unsigned Instance, int ResID);
	void __fastcall LoadFromURL(AnsiString url);
	virtual void __fastcall LoadFromClipboardFormat(Word AFormat, unsigned AData, HPALETTE APalette);
	virtual void __fastcall SaveToClipboardFormat(Word &AFormat, unsigned &AData, HPALETTE &APalette);
	__property bool Busy = {read=fThreadBusy, nodefault};
	__property bool Asynch = {read=fAsynch, write=fAsynch, nodefault};
	__property AnsiString ID = {read=fID, write=fID};
	
__published:
	__property bool Stretch = {read=fStretched, write=fStretched, nodefault};
	__property TDownloadErrorEvent OnDownLoadError = {read=fOnDownLoadError, write=fOnDownLoadError};
	__property TDownloadCompleteEvent OnDownLoadComplete = {read=fOnDownLoadComplete, write=fOnDownLoadComplete
		};
	__property TDownloadCancelEvent OnDownLoadCancel = {read=fOnDownLoadCancel, write=fOnDownLoadCancel
		};
	__property TDownloadProgressEvent OnDownLoadProgress = {read=fOnDownLoadProgress, write=fOnDownLoadProgress
		};
};


struct TInternetContent
{
	bool complete;
	TWebPicture* webpicture;
} ;

class DELPHICLASS TDownLoadThread;
class PASCALIMPLEMENTATION TDownLoadThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	TWebPicture* webpicture;
	
protected:
	virtual void __fastcall Execute(void);
	
public:
	__fastcall TDownLoadThread(TWebPicture* awebpicture);
public:
	#pragma option push -w-inl
	/* TThread.Destroy */ inline __fastcall virtual ~TDownLoadThread(void) { }
	#pragma option pop
	
};


class DELPHICLASS TWebPictureCache;
class PASCALIMPLEMENTATION TWebPictureCache : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	void __fastcall SetPicture(int Index, TWebPicture* Value);
	TWebPicture* __fastcall GetPicture(int Index);
	
public:
	__property TWebPicture* Items[int index] = {read=GetPicture, write=SetPicture/*, default*/};
	TWebPicture* __fastcall AddPicture(void);
	TWebPicture* __fastcall FindPicture(AnsiString ID);
	void __fastcall ClearPictures(void);
public:
	#pragma option push -w-inl
	/* TList.Destroy */ inline __fastcall virtual ~TWebPictureCache(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TWebPictureCache(void) : Classes::TList() { }
	#pragma option pop
	
};


class DELPHICLASS TWebImage;
class PASCALIMPLEMENTATION TWebImage : public Controls::TGraphicControl 
{
	typedef Controls::TGraphicControl inherited;
	
private:
	TWebPicture* fWebPicture;
	TPicturePosition fPicturePosition;
	TDownloadCancelEvent fOnDownLoadCancel;
	TDownloadCompleteEvent fOnDownLoadComplete;
	TDownloadErrorEvent fOnDownLoadError;
	TDownloadProgressEvent fOnDownLoadProgress;
	void __fastcall SeTWebPicture(const TWebPicture* Value);
	void __fastcall PictureChanged(System::TObject* sender);
	void __fastcall SetPicturePosition(const TPicturePosition Value);
	void __fastcall DownLoadError(System::TObject* Sender, AnsiString err);
	void __fastcall DownLoadComplete(System::TObject* Sender);
	void __fastcall DownLoadCancel(System::TObject* Sender, bool &cancel);
	void __fastcall DownLoadProgress(System::TObject* Sender, unsigned dwSize, unsigned dwTotSize);
	
protected:
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TWebImage(Classes::TComponent* aOwner);
	__fastcall virtual ~TWebImage(void);
	virtual void __fastcall Loaded(void);
	
__published:
	__property TWebPicture* WebPicture = {read=fWebPicture, write=SeTWebPicture};
	__property TPicturePosition PicturePosition = {read=fPicturePosition, write=SetPicturePosition, nodefault
		};
	__property Align ;
	__property Anchors ;
	__property Constraints ;
	__property DragKind ;
	__property DragCursor ;
	__property DragMode ;
	__property Hint ;
	__property ParentShowHint ;
	__property ShowHint ;
	__property Visible ;
	__property OnClick ;
	__property OnContextPopup ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDock ;
	__property OnStartDock ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseUp ;
	__property OnMouseMove ;
	__property OnStartDrag ;
	__property TDownloadErrorEvent OnDownLoadError = {read=fOnDownLoadError, write=fOnDownLoadError};
	__property TDownloadCompleteEvent OnDownLoadComplete = {read=fOnDownLoadComplete, write=fOnDownLoadComplete
		};
	__property TDownloadCancelEvent OnDownLoadCancel = {read=fOnDownLoadCancel, write=fOnDownLoadCancel
		};
	__property TDownloadProgressEvent OnDownLoadProgress = {read=fOnDownLoadProgress, write=fOnDownLoadProgress
		};
};


typedef AnsiString TRichText;

typedef void __fastcall (__closure *TAnchorClick)(System::TObject* Sender, AnsiString Anchor);

#pragma option push -b-
enum TVAlignment { tvaTop, tvaCenter, tvaBottom };
#pragma option pop

class DELPHICLASS THTMLabel;
class PASCALIMPLEMENTATION THTMLabel : public Stdctrls::TCustomLabel 
{
	typedef Stdctrls::TCustomLabel inherited;
	
private:
	AnsiString fAnchor;
	bool fAutoSizing;
	Classes::TStringList* fHTMLText;
	TAnchorClick fAnchorClick;
	bool fAnchorHint;
	TAnchorClick fAnchorEnter;
	TAnchorClick fAnchorExit;
	Controls::TImageList* fImages;
	TWebPictureCache* fImageCache;
	int fupdatecount;
	Graphics::TColor fURLColor;
	Controls::TBevelCut FBevelInner;
	Controls::TBevelCut FBevelOuter;
	Controls::TBevelWidth FBevelWidth;
	Controls::TBorderWidth FBorderWidth;
	Forms::TFormBorderStyle FBorderStyle;
	int fShadowOffset;
	Graphics::TColor fShadowColor;
	bool fHover;
	int fHoverHyperLink;
	int fOldHoverHyperLink;
	Graphics::TColor fHoverColor;
	Graphics::TColor fHoverFontColor;
	Windows::TRect fCurrHoverRect;
	Classes::TNotifyEvent fOnMouseLeave;
	Classes::TNotifyEvent fOnMouseEnter;
	TVAlignment fVAlignment;
	void __fastcall SetHTMLText(Classes::TStringList* value);
	void __fastcall SetImages(Controls::TImageList* value);
	void __fastcall SetURLColor(Graphics::TColor value);
	void __fastcall SetAutoSizing(bool value);
	void __fastcall HTMLChanged(System::TObject* sender);
	void __fastcall SetBevelInner(Controls::TBevelCut Value);
	void __fastcall SetBevelOuter(Controls::TBevelCut Value);
	void __fastcall SetBevelWidth(Controls::TBevelWidth Value);
	void __fastcall SetBorderWidth(Controls::TBorderWidth Value);
	void __fastcall SetBorderStyle(Forms::TBorderStyle Value);
	AnsiString __fastcall IsAnchor(int x, int y, Windows::TRect &hoverrect);
	HIDESBASE MESSAGE void __fastcall CMHintShow(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Msg);
	void __fastcall SetShadowColor(const Graphics::TColor Value);
	void __fastcall SetShadowOffset(const int Value);
	void __fastcall SetHover(const bool Value);
	void __fastcall SetHoverColor(const Graphics::TColor Value);
	void __fastcall SetHoverFontColor(const Graphics::TColor Value);
	void __fastcall HoverInvalidate(const Windows::TRect &r);
	HIDESBASE AnsiString __fastcall GetText();
	void __fastcall SetVAlignment(const TVAlignment Value);
	
protected:
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation AOperation
		);
	virtual void __fastcall Paint(void);
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	virtual AnsiString __fastcall GetDisplText();
	virtual void __fastcall UpdateDisplText(void);
	virtual bool __fastcall HTMLPaint(Graphics::TCanvas* canvas, AnsiString s, const Windows::TRect &fr
		, Controls::TImageList* fImages, int xpos, int ypos, int focuslink, int hoverlink, int shadowoffset
		, bool checkhotspot, bool checkheight, bool print, bool selected, bool blink, bool hoverstyle, double 
		resfactor, Graphics::TColor urlcolor, Graphics::TColor hovercolor, Graphics::TColor hoverfontcolor
		, Graphics::TColor shadowcolor, AnsiString &anchorval, AnsiString &stripval, AnsiString &focusanchor
		, int &xsize, int &ysize, int &hyperlinks, int &mouselink, Windows::TRect &hoverrect);
	
public:
	__fastcall virtual THTMLabel(Classes::TComponent* AOwner);
	__fastcall virtual ~THTMLabel(void);
	void __fastcall BeginUpdate(void);
	void __fastcall EndUpdate(void);
	__property AnsiString Text = {read=GetText};
	
__published:
	__property Align ;
	__property Anchors ;
	__property BiDiMode ;
	__property Constraints ;
	__property DragKind ;
	__property ParentBiDiMode ;
	__property bool AnchorHint = {read=fAnchorHint, write=fAnchorHint, nodefault};
	__property bool AutoSizing = {read=fAutoSizing, write=SetAutoSizing, nodefault};
	__property Controls::TBevelCut BevelInner = {read=FBevelInner, write=SetBevelInner, default=0};
	__property Controls::TBevelCut BevelOuter = {read=FBevelOuter, write=SetBevelOuter, default=0};
	__property Controls::TBevelWidth BevelWidth = {read=FBevelWidth, write=SetBevelWidth, default=1};
	__property Controls::TBorderWidth BorderWidth = {read=FBorderWidth, write=SetBorderWidth, default=0
		};
	__property Forms::TBorderStyle BorderStyle = {read=FBorderStyle, write=SetBorderStyle, default=0};
	__property Color ;
	__property DragCursor ;
	__property DragMode ;
	__property Enabled ;
	__property FocusControl ;
	__property Font ;
	__property Hint ;
	__property bool Hover = {read=fHover, write=SetHover, nodefault};
	__property Graphics::TColor HoverColor = {read=fHoverColor, write=SetHoverColor, nodefault};
	__property Graphics::TColor HoverFontColor = {read=fHoverFontColor, write=SetHoverFontColor, nodefault
		};
	__property Classes::TStringList* HTMLText = {read=fHTMLText, write=SetHTMLText};
	__property Controls::TImageList* Images = {read=fImages, write=SetImages};
	__property ParentShowHint ;
	__property ParentColor ;
	__property ParentFont ;
	__property PopupMenu ;
	__property Graphics::TColor ShadowColor = {read=fShadowColor, write=SetShadowColor, nodefault};
	__property int ShadowOffset = {read=fShadowOffset, write=SetShadowOffset, nodefault};
	__property ShowHint ;
	__property Transparent ;
	__property Graphics::TColor URLColor = {read=fURLColor, write=SetURLColor, nodefault};
	__property TVAlignment VAlignment = {read=fVAlignment, write=SetVAlignment, nodefault};
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
	__property TAnchorClick OnAnchorClick = {read=fAnchorClick, write=fAnchorClick};
	__property TAnchorClick OnAnchorEnter = {read=fAnchorEnter, write=fAnchorEnter};
	__property TAnchorClick OnAnchorExit = {read=fAnchorExit, write=fAnchorExit};
	__property Classes::TNotifyEvent OnMouseLeave = {read=fOnMouseLeave, write=fOnMouseLeave};
	__property Classes::TNotifyEvent OnMouseEnter = {read=fOnMouseEnter, write=fOnMouseEnter};
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Htmlabel */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Htmlabel;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// htmlabel
