unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, DBTables, ExtCtrls, Grids, DBGrids, grTool, StdCtrls, ComCtrls,
  ToolWin, Menus;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Addr1: TStringField;
    Table1Addr2: TStringField;
    Table1City: TStringField;
    DBGrid1: TDBGrid;
    StatusBar1: TStatusBar;
    DBgrTool1: TDBgrTool;
    ImageList1: TImageList;
    ToolBar1: TToolBar;
    RestoreBtn: TToolButton;
    ToolButton2: TToolButton;
    SrchBtn: TToolButton;
    PreviewBtn: TToolButton;
    FiltBtn: TToolButton;
    ViewBtn: TToolButton;
    ToolButton8: TToolButton;
    SaveBtn: TToolButton;
    CloseBtn: TToolButton;
    ToolButton3: TToolButton;
    MainMenu1: TMainMenu;
    Data1: TMenuItem;
    SearchMenu: TMenuItem;
    FilterMenu: TMenuItem;
    PreviewMenu: TMenuItem;
    Grid1: TMenuItem;
    SetViewMenu: TMenuItem;
    SaveViewMenu: TMenuItem;
    RestoreViewMenu: TMenuItem;
    Help1: TMenuItem;
    AboutMenu: TMenuItem;
    N1: TMenuItem;
    CloseMenu: TMenuItem;
    ReplaceBtn: TToolButton;
    Table1State: TStringField;
    Table1Zip: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1FAX: TStringField;
    Table1TaxRate: TFloatField;
    Table1Contact: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    procedure SrchBtnClick(Sender: TObject);
    procedure FiltBtnClick(Sender: TObject);
    procedure ViewBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RestoreBtnClick(Sender: TObject);
    procedure PreviewBtnClick(Sender: TObject);
    procedure DBgrTool1SetFilter(Sender: TObject);
    procedure AboutMenuClick(Sender: TObject);
    procedure ReplaceBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses About;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Table1.Open;

  { there is some tricks - you can set this property in design time }
  Table1Addr2.Tag:=100; { user can't filter data with this field !!! }

  { Field City is non-visible, but user can set this field to visible
    with function ExecView }
  Table1City.Visible:=False;

  { Field Contact is non-visible, and user can't set this field to
    visible with function ExecView }
  Table1Contact.Visible:=False;
  Table1Contact.Tag:=1000;

  { if Tag is 1100 - user can't filter data and can't set this field
    to visible }
end;

procedure TForm1.SrchBtnClick(Sender: TObject);
begin
  DBgrTool1.ExecSearch;
end;

procedure TForm1.FiltBtnClick(Sender: TObject);
begin
  DBgrTool1.ExecFilter;
end;

procedure TForm1.ViewBtnClick(Sender: TObject);
begin
  DBgrTool1.ExecView;
end;

procedure TForm1.PreviewBtnClick(Sender: TObject);

begin
  DBgrTool1.ExecPreview;
end;

procedure TForm1.ReplaceBtnClick(Sender: TObject);
begin
  DBgrTool1.ExecReplace;
end;

{ those two function you can use, if DBgrTool1.IniSaveGrid property is
  set to False }
procedure TForm1.SaveBtnClick(Sender: TObject);
begin
  { manual save position and width of fields in grid }
  DBgrTool1.SaveDataSet;
end;

procedure TForm1.RestoreBtnClick(Sender: TObject);
begin
  { manual restore position and width of fields in grid }
  DBgrTool1.RestoreDataSet;
end;

procedure TForm1.CloseBtnClick(Sender: TObject);
begin
  Close;
end;


procedure TForm1.DBgrTool1SetFilter(Sender: TObject);
begin
  StatusBar1.SimpleText:=DBgrTool1.UserFilter;
end;

procedure TForm1.AboutMenuClick(Sender: TObject);
begin
  Form2.ShowModal;
end;

end.
