unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, FlexMarquee, FlexFontListBox, ComCtrls, ExtCtrls, Spin,
  FlexFind, FlexLabelList, FlexStatus, FlexGauge,
  FlexDriveQuery, FlexTexturePanel;

type
  TForm1 = class(TForm)
    FlexFind1: TFlexFind;
    FlexStatus1: TFlexStatus;
    FlexDriveQuery1: TFlexDriveQuery;
    BitBtn7: TBitBtn;
    Image1: TImage;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label1: TLabel;
    Edit1: TEdit;
    BitBtn2: TBitBtn;
    CheckBox1: TCheckBox;
    FlexFontListBox1: TFlexFontListBox;
    TabSheet2: TTabSheet;
    FlexMarquee1: TFlexMarquee;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    RadioGroup1: TRadioGroup;
    BitBtn3: TBitBtn;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    TabSheet8: TTabSheet;
    Label8: TLabel;
    Button3: TButton;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    ListBox2: TListBox;
    CheckBox13: TCheckBox;
    TabSheet3: TTabSheet;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    CheckBox2: TCheckBox;
    BitBtn4: TBitBtn;
    ListBox1: TListBox;
    CheckBox3: TCheckBox;
    TabSheet4: TTabSheet;
    FlexLabelList1: TFlexLabelList;
    BitBtn5: TBitBtn;
    GroupBox1: TGroupBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox16: TCheckBox;
    TabSheet5: TTabSheet;
    BitBtn6: TBitBtn;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    TabSheet7: TTabSheet;
    Label7: TLabel;
    FlexGauge1: TFlexGauge;
    RadioGroup2: TRadioGroup;
    Edit4: TEdit;
    Button1: TButton;
    TabSheet10: TTabSheet;
    FlexTexturePanel1: TFlexTexturePanel;
    Memo1: TMemo;
    Button4: TButton;
    Button5: TButton;
    RadioGroup3: TRadioGroup;
    TabSheet6: TTabSheet;
    GroupBox2: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure Edit2Enter(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure FlexStatus1StartProcessing;
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure FlexMessageBox1Help(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox9Click(Sender: TObject);
    procedure CheckBox15Click(Sender: TObject);
    procedure CheckBox14Click(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     FlexMarquee1.Start;
end;


procedure TForm1.BitBtn2Click(Sender: TObject);
begin
     Edit1.Text := FlexFontListBox1.SelectedFont.Name;
end;



procedure TForm1.CheckBox1Click(Sender: TObject);
begin
     FlexFontListBox1.DrawFont := CheckBox1.State = cbChecked;
end;




procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
     case RadioGroup1.ItemIndex of
          0: FlexMarquee1.ScrollDirection := sdLeftToRight;
          1: FlexMarquee1.ScrollDirection := sdRightToLeft;
          2: FlexMarquee1.ScrollDirection := sdAlternateSideways;
          3: FlexMarquee1.ScrollDirection := sdUpToDown;
          4: FlexMarquee1.ScrollDirection := sdDownToUp;
          5: FlexMarquee1.ScrollDirection := sdAlternateUpDown;
     end;
end;


procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
     try
        FlexMarquee1.ScrollSpeed := SpinEdit1.Value;
     except
     end;
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
     try
        FlexMarquee1.ScrollIncrement := SpinEdit2.Value;
     except
     end;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
     FlexMarquee1.Stop;
end;

procedure TForm1.Edit2Enter(Sender: TObject);
begin
     TEdit(Sender).Color := clYellow;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
begin
     Tedit(Sender).ParentColor := True;
end;





procedure TForm1.BitBtn4Click(Sender: TObject);
begin
     ListBox1.Items.Clear;
     with FlexFind1 do
     begin
          TraversePaths := CheckBox2.State = cbChecked;
          WaitWhenFinished := CheckBox3.State = cbChecked;
          Paths.Clear;
          Paths.Add(Edit3.Text);
          FileNames.Clear;
          FileNames.Add(Edit2.Text);
          if Execute then ListBox1.Items.Assign(FlexFind1.Found);
     end;
end;


procedure TForm1.BitBtn5Click(Sender: TObject);
begin
     if FlexLabelList1.SelectedItem + 1 > FlexLabelList1.Items.Count then
        FlexLabelList1.SelectedItem := 1
     else
         FlexLabelList1.SelectedItem := FlexLabelList1.SelectedItem + 1;

end;




procedure TForm1.CheckBox6Click(Sender: TObject);
begin
     with FlexLabelList1 do
     begin
          SelectedStyles := [];
          if CheckBox4.State = cbChecked then SelectedStyles := SelectedStyles + [ssChangeColor];
          if CheckBox5.State = cbChecked then SelectedStyles := SelectedStyles + [ssMakeBold];
          if CheckBox6.State = cbChecked then SelectedStyles := SelectedStyles + [ssDrawBox];
          if CheckBox16.State = cbChecked then SelectedStyles := SelectedStyles + [ssShowGlyph];
     end;
end;

procedure TForm1.FlexStatus1StartProcessing;
var i, j: integer;
begin
     for i := 1 to FlexStatus1.Stages.Count do
     begin
          FlexStatus1.CurrentStage := i;
          for j := 1 to 5 do
          begin
               if FlexStatus1.Canceled then exit;
               FlexStatus1.Progress := j * 20;
               Application.ProcessMessages;
               Sleep(1000);
          end;
     end;
end;


procedure TForm1.BitBtn6Click(Sender: TObject);
begin
     FlexStatus1.Execute;
end;


procedure TForm1.BitBtn7Click(Sender: TObject);
begin
     Application.Terminate;
end;

procedure TForm1.FlexMessageBox1Help(Sender: TObject);
begin
    MessageDlg('They pushed help', mtInformation,
      [mbOk], 0);
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
     if RadioGroup2.ItemIndex = 0 then
        FlexGauge1.BarOrientation := boVertical
     else
         FlexGauge1.BarOrientation := boHorizontal;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     if edit4.text <> '' then FlexGauge1.Progress := StrToInt(edit4.Text);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
      FlexDriveQuery1.ReturnMatchingDrives;
      ListBox2.Items.Assign(FlexDriveQuery1.Found);
end;

procedure TForm1.CheckBox9Click(Sender: TObject);
begin
     with FlexDriveQuery1 do
     begin
          DriveTypesToFind := [];
          if CheckBox9.State = cbChecked then DriveTypesToFind := DriveTypesToFind + [dtFixed];
          if CheckBox10.State = cbChecked then DriveTypesToFind := DriveTypesToFind + [dtCDROM];
          if CheckBox11.State = cbChecked then DriveTypesToFind := DriveTypesToFind + [dtRemovable];
          if CheckBox12.State = cbChecked then DriveTypesToFind := DriveTypesToFind + [dtRAMDrive];
          if CheckBox13.State = cbChecked then DriveTypesToFind := DriveTypesToFind + [dtNetwork];
     end;
end;


procedure TForm1.CheckBox15Click(Sender: TObject);
begin
     if CheckBox15.state = cbchecked then
        FlexStatus1.DialogBorderStyle := dbNone
     else
         FlexStatus1.DialogBorderStyle := dbDialog;
end;

procedure TForm1.CheckBox14Click(Sender: TObject);
begin
     FlexStatus1.AbortButton := CheckBox14.state = cbchecked;
end;

procedure TForm1.CheckBox8Click(Sender: TObject);
begin
     FlexStatus1.WaitWhenFinished := CheckBox8.state = cbchecked;
end;

procedure TForm1.CheckBox7Click(Sender: TObject);
begin
     FlexStatus1.FlatButtons := CheckBox7.state = cbchecked;

end;

procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
     case RadioGroup3.ItemIndex of
          0: FlexTexturePanel1.BackgroundPlacement := bpTiled;
          1: FlexTexturePanel1.BackgroundPlacement := bpCentered;
     end;
end;



end.
