/*-----------------------------------------------------------------------------
  Unit     : TfisSysMenu.h
  Purpose  : Adds menu items to the system menu for a form
  Copyright:  First Internet Software House 2000, http://www.fishouse.com
  Status   : Shareware, register at http://www.fishouse.com/register.asp
  Contact  : support@fishouse.com
 ----------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
#ifndef TfisSysMenuH
#define TfisSysMenuH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
//---------------------------------------------------------------------------
typedef int (__stdcall *WNDPROCFUNC)();
//---------------------------------------------------------------------------
class PACKAGE TfisSysMenu : public TComponent
{
    typedef int (__stdcall *WNDPROCFUNC)();
private:
    bool FEnabled;
    TPopupMenu *FMenu;
    TForm* prOwner;
    TWndMethod prOldFormWndProc;
    static TfisSysMenu * __fastcall FindSysMenu(TComponent *aOwner,
        TfisSysMenu *aIgnore);
    static WNDPROCFUNC prOldAppWndProc;
    static int prInstanceCount;
protected:
    void __fastcall SetEnabled(bool aEnabled);
    void __fastcall SetMenu(TPopupMenu *aMenu);
    virtual void __fastcall Notification(TComponent* AComponent, TOperation Operation);
    void __fastcall NewFormWindowProc(TMessage &aMessage);
    void __fastcall CreateMenuItems(void);
    void __fastcall DeleteMenuItems(void);
    void __fastcall CallClickHandler(TMenuItem *aMenu, int aCommand);
    static LRESULT APIENTRY NewAppWndProc(HWND hwnd, UINT uMsg, WPARAM wParam,
        LPARAM lParam);
public:
    __fastcall TfisSysMenu(TComponent* Owner);
    __fastcall ~TfisSysMenu(void);
__published:
    __property bool Enabled = {read = FEnabled, write=SetEnabled, default = true};
    __property TPopupMenu *Menu = {read = FMenu, write = SetMenu};
};
//---------------------------------------------------------------------------
#endif
