/*-----------------------------------------------------------------------------
  Unit     : TfisSysMenu.cpp
  Purpose  : Adds menu items to the system menu for a form
  Copyright:  First Internet Software House 2000, http://www.fishouse.com
  Status   : Shareware, register at http://www.fishouse.com/register.asp
  Contact  : support@fishouse.com
 ------------------------------------------------------------------------------

  History:

  Date                By      Comments
  ----                ----    --------
  05 May 2000         NC      Created

 ----------------------------------------------------------------------------*/
#include <vcl.h>
#pragma hdrstop

#include "TfisSysMenu.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
WNDPROCFUNC TfisSysMenu::prOldAppWndProc = NULL;
int TfisSysMenu::prInstanceCount = 0;
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TfisSysMenu *)
{
    new TfisSysMenu(NULL);
}
//---------------------------------------------------------------------------
TfisSysMenu *__fastcall TfisSysMenu::FindSysMenu(TComponent *aOwner, TfisSysMenu *aIgnore)
{
    for(int lCount = 0; lCount < aOwner->ComponentCount; lCount++)
	{
		if(aOwner->Components[lCount]->InheritsFrom(__classid(TfisSysMenu)))
		{
            if(aOwner->Components[lCount] != aIgnore)
            {
                return((TfisSysMenu *)aOwner->Components[lCount]);
            }
		}
    }
    return(NULL);
}
//---------------------------------------------------------------------------
LRESULT APIENTRY TfisSysMenu::NewAppWndProc(HWND hwnd, UINT uMsg, WPARAM wParam,
    LPARAM lParam)
{
    switch(uMsg)
    {
        case CM_APPKEYDOWN:
        {
            TfisSysMenu *lThis = FindSysMenu(Screen->ActiveForm, NULL);
            if(lThis != NULL && lThis->FMenu != NULL && lThis->FEnabled)
            {
                TWMKey lKeyMsg;
                lKeyMsg.Msg = uMsg;
                lKeyMsg.CharCode = (unsigned short)wParam;
                lKeyMsg.KeyData = lParam;
                lThis->FMenu->IsShortCut(lKeyMsg);
                lThis->CreateMenuItems();

            }
        }
        break;
    }
    return(CallWindowProc(prOldAppWndProc, hwnd, uMsg, wParam, lParam));
}
//---------------------------------------------------------------------------
__fastcall TfisSysMenu::TfisSysMenu(TComponent* Owner)
    : TComponent(Owner)
{
    if(FindSysMenu(Owner, this) != NULL)
    {
        throw EComponentError("Only One Instance Allowed");
    }
    FEnabled = true;
    FMenu = NULL;
    prOwner = (TForm *)Owner;
    if(!ComponentState.Contains(csDesigning))
    {
        prOldFormWndProc = prOwner->WindowProc;
        prOwner->WindowProc = NewFormWindowProc;
        if(++prInstanceCount == 1)
        {
            prOldAppWndProc = (WNDPROCFUNC)SetWindowLong(Application->Handle,
                GWL_WNDPROC, (long)NewAppWndProc);
        }
    }
}
//---------------------------------------------------------------------------
__fastcall TfisSysMenu::~TfisSysMenu(void)
{
    if(!ComponentState.Contains(csDesigning))
    {
        if(Owner != NULL)
        {
            prOwner->WindowProc = prOldFormWndProc;
        }
        if(--prInstanceCount == 0)
        {
            SetWindowLong(Application->Handle, GWL_WNDPROC, (long)prOldAppWndProc);
        }
    }
    DeleteMenuItems();
}
//---------------------------------------------------------------------------
void __fastcall TfisSysMenu::CallClickHandler(TMenuItem *aMenu, int aCommand)
{
    for(int lCount = 0; lCount < aMenu->Count; lCount++)
    {
        if(aMenu->Items[lCount]->Command == aCommand)
        {
            if(aMenu->Items[lCount]->OnClick != NULL)
            {
                aMenu->Items[lCount]->OnClick(aMenu->Items[lCount]);
                CreateMenuItems();
            }
            break;
        }
        if(aMenu->Items[lCount]->Count != 0)
        {
            CallClickHandler(aMenu->Items[lCount], aCommand);
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisSysMenu::NewFormWindowProc(TMessage &aMessage)
{
    switch(aMessage.Msg)
    {
        case WM_SYSCOMMAND:
        {
            if(FMenu != NULL && FEnabled)
            {
                CallClickHandler(FMenu->Items, aMessage.WParam);
            }
        }
        break;
        case WM_DESTROY:
        {
            DeleteMenuItems();
        }
        break;
    }
    prOldFormWndProc(aMessage);
}
//---------------------------------------------------------------------------
void __fastcall TfisSysMenu::CreateMenuItems(void)
{
    DeleteMenuItems();
    HMENU lSysMenu = GetSystemMenu(prOwner->Handle, false);
    if(FMenu != NULL)
    {
        AppendMenu(lSysMenu, MF_SEPARATOR, 0xE000, 0);
        for(int lCount = 0; lCount < FMenu->Items->Count; lCount++)
        {
            if(FMenu->Items->Items[lCount]->Visible)
            {
                int lFlags = MF_STRING;
                if(FMenu->Items->Items[lCount]->Caption == '-')
                {
                    lFlags = MF_SEPARATOR;
                }
                if(FMenu->Items->Items[lCount]->Checked)
                {
                    lFlags |= MF_CHECKED;
                    if(FMenu->Items->Items[lCount]->RadioItem)
                    {
                        lFlags |= MFT_RADIOCHECK;
                    }
                }
                if(!FMenu->Items->Items[lCount]->Enabled)
                {
                    lFlags |= MF_GRAYED;
                }
                if(FMenu->Items->Items[lCount]->Break == mbBarBreak)
                {
                    lFlags |= MF_MENUBARBREAK;
                }
                else if(FMenu->Items->Items[lCount]->Break == mbBreak)
                {
                    lFlags |= MF_MENUBREAK;
                }
                AnsiString lCaption = FMenu->Items->Items[lCount]->Caption;
                if(Menu->Items->Items[lCount]->ShortCut != 0)
                {
                    lCaption += "\t" +
                        ShortCutToText(Menu->Items->Items[lCount]->ShortCut);
                }
                if(FMenu->Items->Items[lCount]->Count != 0)
                {
                    AppendMenu(lSysMenu, MF_POPUP,
                        (unsigned int)FMenu->Items->Items[lCount]->Handle,
                        lCaption.c_str());
                }
                else
                {
                    AppendMenu(lSysMenu, lFlags, FMenu->Items->Items[lCount]->Command,
                        lCaption.c_str());
                }
            }
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisSysMenu::DeleteMenuItems(void)
{
    if(Owner != NULL)
    {
        HMENU lSysMenu = GetSystemMenu(prOwner->Handle, false);
        while(RemoveMenu(lSysMenu, 7, MF_BYPOSITION))
        {
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisSysMenu::SetEnabled(bool aEnabled)
{
    FEnabled = aEnabled;
    if(aEnabled)
    {
        CreateMenuItems();
    }
    else
    {
        DeleteMenuItems();
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisSysMenu::SetMenu(TPopupMenu *aMenu)
{
    FMenu = aMenu;
    if(aMenu != NULL)
    {
        aMenu->FreeNotification(this);
        if(FEnabled)
        {
            CreateMenuItems();
        }
    }
    else
    {
        DeleteMenuItems();
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisSysMenu::Notification(TComponent *aComponent, TOperation aOperation)
{
    TComponent::Notification(aComponent, aOperation);
    if(aOperation == opRemove && aComponent == FMenu  && !ComponentState.Contains(csDestroying))
    {
        FMenu = NULL;
        DeleteMenuItems();
    }
}
//---------------------------------------------------------------------------
namespace Tfissysmenu
{
    void __fastcall PACKAGE Register()
    {
         TComponentClass classes[1] = {__classid(TfisSysMenu)};
         RegisterComponents("FISH", classes, 0);
    }
}
//---------------------------------------------------------------------------


