unit progress;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TFProgress = class(TForm)
    ProgressBar1: TProgressBar;
    Label1: TLabel;
  private
    { Private declarations }
    ps,dif : Integer;
  public
    { Public declarations }
    procedure init(max : Integer);
    procedure setPos(p : Integer);
    procedure setCap(c : String);
  end;

var
  FProgress: TFProgress;

implementation

{$R *.DFM}

procedure TFProgress.init(max : Integer);
begin
   progressbar1.max := max;
   progressbar1.position := 0;
   dif := max div 25;
   ps := 0;
   show;
end;

procedure TFProgress.setCap(c : String);
begin
   label1.caption := c;
   refresh;
end;

procedure TFProgress.setPos(p : Integer);
begin
   progressbar1.position := p;
   if p > ps then begin
      progressbar1.refresh;
      ps := ps + dif;
   end;
end;

end.
