unit Demo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, EZDataInstall, ExtCtrls, Buttons, Menus, DB, DBTables;

type
  TFDataInstallDemo = class(TForm)
    EZDataInstall1: TEZDataInstall;
    dopen: TOpenDialog;
    screens: TNotebook;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    source: TPanel;
    BitBtn1: TBitBtn;
    Label5: TLabel;
    BtnCreate: TButton;
    Button3: TButton;
    Label6: TLabel;
    ListBox1: TListBox;
    dest: TPanel;
    BitBtn2: TBitBtn;
    Label7: TLabel;
    Label8: TLabel;
    btnInstall: TButton;
    Install: TButton;
    stat: TLabel;
    Label9: TLabel;
    Bevel1: TBevel;
    Button4: TButton;
    Button5: TButton;
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    procedure BtnCreateClick(Sender: TObject);
    procedure btnInstallClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure InstallClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FDataInstallDemo: TFDataInstallDemo;

implementation
uses bde;

{$R *.DFM}

procedure TFDataInstallDemo.BtnCreateClick(Sender: TObject);
begin
   btnCreate.enabled := false;
   stat.caption := 'Making definition file "'+ezDataInstall1.definitionFile+'"';
   stat.refresh;
   ezDataInstall1.DatabasePath := source.caption;
   if ezDataInstall1.makeDefinitionFile then begin
      listbox1.items.loadFromFile(ezDataInstall1.definitionFile);
      stat.caption := 'Definition file "'+ezDataInstall1.definitionFile+ '" Made.';
   end else
      stat.caption := '';
   btnCreate.enabled := true;
end;

procedure TFDataInstallDemo.btnInstallClick(Sender: TObject);
begin
   try
     screen.cursor := crHourGlass;
     btnInstall.enabled := false;
     ezDataInstall1.DatabasePath := dest.caption;
     ezDataInstall1.makeDatabaseFiles;
   finally
     btnInstall.enabled := true;
     screen.cursor := crDefault;
   end;

end;

procedure TFDataInstallDemo.Button3Click(Sender: TObject);
begin
  screens.activePage := 'Make Definition File';
end;

procedure TFDataInstallDemo.BitBtn1Click(Sender: TObject);
begin
   if dopen.execute then begin
      source.caption := extractFilePath(dopen.filename);
   end;
end;

procedure TFDataInstallDemo.BitBtn2Click(Sender: TObject);
begin
   if dopen.execute then begin
      dest.caption := extractFilePath(dopen.filename);
   end;
end;

procedure TFDataInstallDemo.InstallClick(Sender: TObject);
begin
   Screens.activePage := 'Create Database File';
end;

procedure TFDataInstallDemo.Button4Click(Sender: TObject);
begin
   screens.activePage := 'Menu';
end;

end.
