{***********************************************}
{       Simple DEMO Program for using           }
{                                               }
{         Expression Parser 1.30                }
{       for DELPHI 1.0, 3.0 and 4.0             }
{                                               }
{           by Todor Marholev                   }
{       e-mail: spsoft@mail.vega.bg             }
{***********************************************}

unit Unit1;

interface

uses
  SysUtils, {$IFDEF WIN32}Windows,{$ELSE}WinProcs, WinTypes,{$ENDIF} Messages,
  Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ExPars;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label2: TLabel;
    ResultLbl: TLabel;
    ExprParser1: TExprParser;
    EPUserLib1: TEPUserLib;
    Button5: TButton;
    Button6: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    function ExprParser1Variable(Sender: TObject;
      const VarName: String): Extended;
    function ExprParser1Function(Sender: TObject; const FuncName: String;
      const FuncParams: array of Extended): Extended;
    procedure Button6Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses ParsType, Unit2;
{$R *.DFM}

procedure _MySum(AnOper: POperation); far;
var I : Integer;
begin
  with AnOper^ do
    For I:=1 to ArgCnt do
      case I of
        1: dest^:=arg1^;
        2: dest^:=dest^+arg2^;
        3: dest^:=dest^+arg3^;
       else dest^:=dest^+args^[I-4]^;
      end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   ExprParser1.AddFunction('MySum', _MySum, -1 {Unlimited number of arguments});
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   ExprParser1.EditVariables;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   EPUserLib1.Edit;
end;


procedure TForm1.Button5Click(Sender: TObject);
begin
   EPUserLib1.IniFile:='';
   {If a Path is not specified, INI file must be in the Windows directory}
   EPUserLib1.IniFile:='DEMOLIB.INI';
end;

procedure TForm1.Button3Click(Sender: TObject);
procedure AddUserLibExpr(AList: TEPExprList; AName, AExpr: String);
var ASrc: TStrings;
    AIdx: Integer;
begin
   ASrc:=TStringList.Create;
   try
     ASrc.Add(AExpr);
     with AList do if Find(AName,AIdx) then Sources[AIdx]:=ASrc else Add(AName,ASrc);
   finally ASrc.Free; end;
end;
begin
   ExprParser1.Variable['x1']:=4;
   ExprParser1.Variable['y1']:=3;
   AddUserLibExpr(EPUserLib1.Aliases,'x','%0');
   with EPUserLib1.Aliases do begin
     AddExpr('y','%1');
     AddExpr('z','%2');
   end;
   with EPUserLib1.UserFuncs do begin
     AddExpr('LibFunc1','x + y^3');
     AddExpr('LibFunc2','LibFunc1(x,y)^2');
   end;

   Edit1.Text:='x1 ^ y1 + MySum(MyFunc(x,y,z),MyFunc(x+4,y+1,z+9),prod(x2,y2),'+
               'MyFunc1(x2,y2),LibFunc2(x2,y2),x3^y3)';
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   If ExprParser1.Expr<>Edit1.Text then ExprParser1.Expr:=Edit1.Text;
   ResultLbl.Caption:=FloatToStr(ExprParser1.F([3,2,4]));
end;

procedure TForm1.Button6Click(Sender: TObject);
var ADlg: TUsedVarsEditDlg;
begin
   If ExprParser1.Expr<>Edit1.Text then ExprParser1.Expr:=Edit1.Text;
   ADlg:=TUsedVarsEditDlg.Create(Self);
   try
     with ADlg do begin
       AnExprParser:=Self.ExprParser1;
       ShowModal;
     end;
   finally ADlg.Free; end;
end;

function TForm1.ExprParser1Variable(Sender: TObject; const VarName: String): Extended;
var AnIdx: Integer;
begin
   If VarName=UpperCase('x2') then begin
     Result:=5;
   end else If VarName='Y2' then begin
     Result:=3;
   end else with ExprParser1.UsedVariables do
     If Find(VarName,AnIdx) then Result:=Value[AnIdx]
   else Result:=0;
end;

function TForm1.ExprParser1Function(Sender: TObject;
  const FuncName: String; const FuncParams: array of Extended): Extended;
var I : Integer;
begin
   Result:=0;
   If FuncName=UpperCase('MyFunc') then begin
     Result:=FuncParams[0]*FuncParams[1]+FuncParams[2];
   end else
   If FuncName=UpperCase('MyFunc1') then begin
     Result:=SQR(FuncParams[0]) + FuncParams[1];
   end else
   If FuncName=UpperCase('MySumFunc') then begin
     For I:=0 to High(FuncParams) do Result:=Result+FuncParams[I];
   end;
end;

end.
