unit Unit2;

interface

uses SysUtils, {$IFDEF WIN32}Windows,{$ELSE}WinTypes, WinProcs,{$ENDIF} Classes, Graphics,
     Forms, Controls, Buttons, StdCtrls, ExtCtrls, ExPars;

type
  TUsedVarsEditDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    ListBox1: TListBox;
    Header1: THeader;
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure Header1Sizing(Sender: TObject; ASection, AWidth: Integer);
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    AnExprParser: TExprParser;
  end;

var
  UsedVarsEditDlg: TUsedVarsEditDlg;

implementation

{$R *.DFM}


procedure TUsedVarsEditDlg.FormShow(Sender: TObject);
begin
   If AnExprParser<>nil then ListBox1.Items.Assign(AnExprParser.UsedVariables);
end;

procedure TUsedVarsEditDlg.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
   If not (Key in [^H,^X,^C,^V,'0'..'9',DecimalSeparator]) then Key:=#0;
end;

procedure TUsedVarsEditDlg.ListBox1DrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);

type PFloat = ^Extended;

var VV : Extended;
    PCh : array[0..127] of Char;
    RR: Integer;
begin
   with ListBox1 do If Items.Objects[Index]<>nil then VV:=PFloat(Items.Objects[Index])^ else VV:=0;
   ListBox1.Canvas.FillRect(Rect); RR:=Rect.Right;
   with Header1 do begin
     with Rect do begin Left:=Left+2;Right:=Left+SectionWidth[0]-2; end;
     StrPCopy(PCh,ListBox1.Items[Index]);
     DrawText(ListBox1.Canvas.Handle,PCh,StrLen(PCh),Rect,dt_Left or dt_VCenter);
     with Rect do begin Left:=Left+SectionWidth[0];Right:=RR-2; end;
     StrPCopy(PCh,FloatToStr(VV));
     DrawText(ListBox1.Canvas.Handle,PCh,StrLen(PCh),Rect,dt_Right or dt_VCenter);
   end;
end;

procedure TUsedVarsEditDlg.Header1Sizing(Sender: TObject; ASection, AWidth: Integer);
begin
   ListBox1.Repaint;
end;


procedure TUsedVarsEditDlg.ListBox1Click(Sender: TObject);
var AnIdx: Integer;
begin
   AnIdx:=ListBox1.ItemIndex;
   If (AnIdx>=0) and (AnIdx<ListBox1.Items.Count) then begin
     Edit1.Text:=FloatToStr(AnExprParser.UsedVariables.Value[AnIdx]);
   end;
end;

procedure TUsedVarsEditDlg.Button1Click(Sender: TObject);
var AnIdx: Integer;
begin
   AnIdx:=ListBox1.ItemIndex;
   If (AnIdx>=0) and (AnIdx<ListBox1.Items.Count) then begin
     with AnExprParser.UsedVariables do
       try
         Value[AnIdx]:=StrToFloat(Edit1.Text);
       except Value[AnIdx]:=0; end;
     ListBox1.Repaint;
   end;
end;

end.
