{***********************************************}
{       Simple DEMO Program for using           }
{                                               }
{           Expression Parser                   }
{      for DELPHI 1.0, 3.0, 4.0 and 5.0         }
{                                               }
{           by Todor Marholev                   }
{       e-mail: spsoft@mail.vega.bg             }
{***********************************************}

unit Unit1;

interface

uses
  SysUtils, {$IFDEF WIN32}Windows,{$ELSE}WinProcs, WinTypes,{$ENDIF} Messages,
  Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ExPars, Vars, ExLink,
  DBTables, DB, parstype, ExFuncs, ExtCtrls, ExClass;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label2: TLabel;
    ResultLbl: TLabel;
    ExprParser1: TExParser;
    EPUserLib1: TEPUserLib;
    Button5: TButton;
    Button6: TButton;
    EPVars1: TEPVars;
    Table1: TTable;
    DataSource1: TDataSource;
    EPRegFuncs1: TEPRegFuncs;
    Memo1: TMemo;
    Button7: TButton;
    Button8: TButton;
    ResultLbl2: TLabel;
    Database1: TDatabase;
    DescrLbl: TLabel;
    Button9: TButton;
    EPRegFuncs1MYPROD1: TEPEventFunc;
    EPVars1VAR1: TVariable;
    Table1RecNo: TAutoIncField;
    Table1Value: TFloatField;
    EPVCLClasses1: TEPVCLClasses;
    Button10: TButton;
    Button11: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    function ExprParser1Variable(Sender: TObject;
      const VarName: String): Variant;
    function ExprParser1Function(Sender: TObject; const FuncName: String;
      const FuncParams: array of Variant): Variant;
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    function EPRegFuncs1MYPROD1Evaluate(
      const Params: array of Variant): Variant;
    function EPVars1VAR1CalcValue(Sender: TVariable): Variant;
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    InitVal: Variant;
    ID: TGUID;
    FNeedsUninitialize: Boolean;
    procedure ShowResult(ALabel: TLabel; AValue: Extended);
    function _DemoFunc(AParams: array of Variant): Integer;
    procedure _MySum(AnOper: PParserOperation);
  end;

var
  Form1: TForm1;

implementation

uses Unit2, ActiveX;
{$R *.DFM}

function _MyAVG(Params: array of ParserFloat): Extended; far;
var I : Integer;
    Res: Extended;
begin
   Res:=0;
   if Integer(High(Params))>=0 then begin
     for I:=0 to Integer(High(Params)) do Res:=Res+Extended(Params[I]);
     Res:=Res / (Integer(High(Params))+1);
   end;
   Result:=Res;
end;

procedure TForm1._MySum(AnOper: PParserOperation);
var I : Integer;
begin
  with AnOper^ do begin
    For I:=1 to ArgCnt do
      case I of
        1: dest^:=arg1^;
        2: dest^:=dest^+arg2^;
        3: dest^:=dest^+arg3^;
       else dest^:=dest^+args^[I-1]^;
      end;
  end;
end;

procedure TForm1.ShowResult(ALabel: TLabel; AValue: Extended);
begin
   if ALabel is TLabel then ALabel.Caption:=FloatToStr(AValue);
end;
function TForm1._DemoFunc(AParams: array of Variant): Integer;
begin
   Result:=ExprParser1.CallFunction('DemoLibFunc',AParams);
end;

function TForm1.EPRegFuncs1MYPROD1Evaluate(const Params: array of Variant): Variant;
var I: Integer;
begin
   if Integer(High(Params))>=0 then begin
     Result:=1;
     for I:=0 to Integer(High(Params)) do Result:=Extended(Result)*Extended(Params[I]);
   end else Result:=0;
end;

function TForm1.EPVars1VAR1CalcValue(Sender: TVariable): Variant;
begin
   Result:=40;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   InitVal:=10;
   EPRegFuncs1.AddFunctionOfObj('MySum', self._MySum, -1 {Unlimited number of arguments},'My SUM function',fct_Aggregate);
   EPRegFuncs1.AddStdFunction('MyAVG',@_MyAVG, nil, [typeArray], typeExtended ,'My AVG function', fct_Custom);
   EPRegFuncs1.AddStdFunction('ShowResult',@TForm1.ShowResult, Self, [typeLongInt, typeExtended], typeVoid ,
                                'Outputs a value in a label''s caption', fct_Custom);
   EPRegFuncs1.AddStdFunction('DemoFunc',@TForm1._DemoFunc, Self, [typeArray],typeInteger,
                             'This demo function simply calls a user defined script function', fct_Custom);
   Table1.Open;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   ExprParser1.EditVariables;
  { EPVars1.EditVariables;}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   EPUserLib1.Edit;
end;


procedure TForm1.Button5Click(Sender: TObject);
begin
   EPUserLib1.IniFile:='';
   {If a Path is not specified, INI file must be in the Windows directory}
   EPUserLib1.IniFile:='demolib.INI';
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   ExprParser1.Expression.Assign(Memo1.Lines);
   ResultLbl.Caption:=ExprParser1.F([3,2,4]);
end;

procedure TForm1.Button6Click(Sender: TObject);
var ADlg: TUsedVarsEditDlg;
begin
   ExprParser1.Expression.Assign(Memo1.Lines);
   ADlg:=TUsedVarsEditDlg.Create(Self);
   try
     with ADlg do begin
       AnExprParser:=Self.ExprParser1;
       ShowModal;
     end;
   finally ADlg.Free; end;
end;

function TForm1.ExprParser1Variable(Sender: TObject; const VarName: String): Variant;
var AnIdx: Integer;
begin
   Result:=0;
   If CompareText(VarName,'x2')=0 then begin
     Result:=5;
   end else If CompareText(VarName,'Y2')=0 then begin
     Result:=3;
   end else with ExprParser1.UsedVariables do
     If Find(VarName,AnIdx) then Result:=Value[AnIdx];
end;

function TForm1.ExprParser1Function(Sender: TObject;
  const FuncName: String; const FuncParams: array of Variant): Variant;
var I : Integer;
begin
   Result:=0;
   If CompareText(FuncName,'MyFunc')=0 then begin
     if High(FuncParams)<2 then
       raise ESyntaxError.Create(msgMismatchArgs+': '+FuncName+'('+')');
     Result:=Extended(FuncParams[0])*Extended(FuncParams[1])+Extended(FuncParams[2]);
   end else
   If CompareText(FuncName,'MyFunc1')=0 then begin
     if High(FuncParams)<1 then
       raise ESyntaxError.Create(msgMismatchArgs+': '+FuncName+'('+')');
     Result:=SQR(FuncParams[0]) + Extended(FuncParams[1]);
   end else
   If CompareText(FuncName,'MySumFunc')=0 then begin
     For I:=0 to Integer(High(FuncParams)) do Result:=Result+Extended(FuncParams[I]);
   end else raise Exception.Create('Unknown function name: '+FuncName);
end;

procedure TForm1.Button3Click(Sender: TObject);
procedure AddUserLibExpr(AList: TEPExprList; AName, AExpr: String);
var ASrc: TStrings;
    AIdx: Integer;
begin
   ASrc:=TStringList.Create;
   try
     ASrc.Add(AExpr);
     with AList do if Find(AName,AIdx) then Sources[AIdx]:=ASrc else Add(AName,ASrc);
   finally ASrc.Free; end;
end;
begin
   ResultLbl.Caption:='0'; ResultLbl2.Caption:='';
   EPVars1['x1'].Value:=4;
   EPVars1['y1'].Value:=3;
   AddUserLibExpr(EPUserLib1.Aliases,'x','%0');
   with EPUserLib1.Aliases do begin
     AddExpr('y','%1');
     AddExpr('z','%2');
   end;
   with EPUserLib1.UserFuncs do begin
     AddExpr('LibFunc1','x + y^3');
     AddExpr('LibFunc2','LibFunc1(x,y)^2');
   end;
   with Memo1.Lines do begin
     Clear;
     Add('x1 ^ y1 + MySum(MyFunc(x,y,z),MyFunc(x+4,y+1,z+9),');
     Add('prod(x2,y2),MyFunc1(x2,y2),LibFunc2(x2,y2),x3^y3)');
   end;
   DescrLbl.Caption:='A complex single line expression demo, that uses function arguments, user defined library'+
                     ' functions and aliases, variables and registered math procedure. '+
                     ' You can try to load other definitions for library functions from INI file.';
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
   ResultLbl.Caption:='0'; ResultLbl2.Caption:='';
   with Memo1.Lines do begin
     Clear;
     Add('ACount:=0;');
     Add('Result:=0;');
     Add('ATbl:=[TTable].Create([Self]);');
     Add('try');
     Add('  ATbl.DatabaseName:="DEMODB"; ATbl.TableName:="ValTbl.DB";');
     Add('  ATbl.IndexFieldNames:="RecNo";');
     Add('  ATbl.Open; ATbl.First;');
     Add('  while Not ATbl.EOF do begin');
     Add('    Result:=Result+ATbl.FieldByName("Value").AsFloat;');
     Add('    ACount:=ACount+1;');
     Add('    ATbl.Next;');
     Add('  end;');
     Add('finally');
     Add('  ATbl.Free;');
     Add('end;');
     Add('[ResultLbl2].Caption:=ACount;');
   end;
   DescrLbl.Caption:='This demo shows how to create components and use of runtime components, class references,'+
                     ' while loop, ''try finally end'' statement. You can use BREAK to break the loop.';
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
   ResultLbl.Caption:='0'; ResultLbl2.Caption:='';
   with Memo1.Lines do begin
     Clear;
     Add('Sum:=0; K:=3;');
     Add('if k<5 then');
     Add('  for I:=0 to 30 do begin');
     Add('    if (I>=0) and (I<5) then Sum:=Sum+3');
     Add('    else if (I>=5) and (I<20) then Sum:=Sum+5');
     Add('    else if (I>=20) and (I<=30) then Sum:=Sum+10;');
     Add('  end');
     Add('else if k<10 then begin');
     Add('  I:=0;');
     Add('  repeat');
     Add('    if (I>=0) and (I<10) then Sum:=Sum+4');
     Add('    else if (I>=10) and (I<20) then Sum:=Sum+5');
     Add('    else if (I>=20) and (I<=30) then Sum:=Sum+6;');
     Add('    Inc(I);');
     Add('  until I>30;');
     Add('end else begin');
     Add('  I:=0;');
     Add('  while I<=30 do begin');
     Add('    Sum:=Sum+10;');
     Add('    Inc(I);');
     Add('  end;');
     Add('end;');
     Add('Result:=Sum;');
     Add('ShowResult([ResultLbl2],I);');
   end;
   DescrLbl.Caption:='This demo is a complex script that uses many nested ''if then else'' statements and loops. '+
                     'Also shows how to use registered runtime function of object (ShowResult)';
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
   ResultLbl.Caption:='0'; ResultLbl2.Caption:='';
   with EPVars1['RTVar'] do begin
     Descr:='A link to a runtime variable';
     LinkTo(@InitVal);
   end;
   with Memo1.Lines do begin
     Clear;
     Add('I:=MyPROD(RTVar,4,5);');
     Add('Result:=MySUM(3,Var1,5,MyAVG(2,3,4,5));');
     Add('ShowResult([ResultLbl2], I);');
   end;
   DescrLbl.Caption:='This is an example of using a runtime variables and registered functions, and ''on event'' '+
                     'evaluated variables and registered functions.';
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
   ResultLbl.Caption:='0'; ResultLbl2.Caption:='';
   with EPUserLib1.UserFuncs do begin
     ClearEntries;
     AddExpr('DemoLibFunc','%0+%1');
   end;
   with Memo1.Lines do begin
     Clear;
     Add('SS:="Format(""%4.4d"",Integer((%0+2*%1)*3))";');
     Add('I:=DemoFunc(2,3);');
     Add('Result:=ExecScript(SS,2,I);');
   end;
   DescrLbl.Caption:='This example shows how to execute a script defined during evaluation and '+
                     'how to call a user defined script function from a program (DemoFunc).';
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
   ResultLbl.Caption:='0'; ResultLbl2.Caption:='';
   with Memo1.Lines do begin
     Clear;
     Add('Excel:=CreateOleObject("Excel.Application");');
     Add('Excel.Visible:=True;');
     Add('WBook:=Excel.WorkBooks.Add;');
     Add('ASheet:=WBook.Sheets.Item(1);');
     Add('ASheet.Activate;');
     Add('Randomize();');
     Add('for I:=1 to 5 do');
     Add('  ASheet.Cells.Item(2,I).Value:=Random(10);');
     Add('Ch:=ASheet.ChartObjects.Add(10,50,250,150);');
     Add('xl3DColumn:=$FFFFEFFC;');
     Add('Ch.Chart.ChartWizard(ASheet.Range("A2:E2"),xl3DColumn,');
     Add('      Unassigned,Unassigned,Unassigned,Unassigned,False);');
     Add('ShowMessage("OK");');
   end;
   DescrLbl.Caption:='This is an example of using OLE Automation objects.';
end;




initialization
  CoInitialize(nil);

finalization
  CoUninitialize;
end.
