unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, uExcDlg, ExcMagic;

type
  TfMain = class(TForm)
    btnRaise: TBitBtn;
    btnBounds: TBitBtn;
    btnIO: TBitBtn;
    btnVCL: TBitBtn;
    cbLogToFile: TCheckBox;
    cbLogOnce: TCheckBox;
    cbEnabled: TCheckBox;
    cbHookMsg: TCheckBox;
    cbHookDlg: TCheckBox;
    gbLog: TGroupBox;
    eLogFile: TEdit;
    Label1: TLabel;
    gbGeneral: TGroupBox;
    btnAccess: TBitBtn;
    btnTryExcept: TBitBtn;
    procedure cbEnabledClick(Sender: TObject);
    procedure cbHookMsgClick(Sender: TObject);
    procedure cbHookDlgClick(Sender: TObject);
    procedure cbLogToFileClick(Sender: TObject);
    procedure eLogFileChange(Sender: TObject);
    procedure cbLogOnceClick(Sender: TObject);
    procedure btnRaiseClick(Sender: TObject);
    procedure btnBoundsClick(Sender: TObject);
    procedure btnIOClick(Sender: TObject);
    procedure btnVCLClick(Sender: TObject);
    procedure btnAccessClick(Sender: TObject);
    procedure btnTryExceptClick(Sender: TObject);
  private
    procedure ExcMsg( ExceptionMessage,ExceptionClassName,ModuleName,SrcName: String; ModuleAddress: Pointer; SrcLine: Integer; Buffer: PChar; BufferSize: Integer );
    procedure ExcShow( Title,ExceptionMessage,CallStack,Registers: PChar );
  public
    { Public declarations }
  end;

var
  fMain: TfMain;

implementation

{$R *.DFM}

procedure TfMain.ExcMsg( ExceptionMessage,ExceptionClassName,ModuleName,SrcName: String; ModuleAddress: Pointer; SrcLine: Integer; Buffer: PChar; BufferSize: Integer );
begin
  StrLFmt( Buffer, BufferSize,
    'Gotcha!!!'#13#10 +
    'Exception "%s": %s'#13#10 +
    'In module %s at %p'#13#10 +
    'Source file: %s, Line %d',
    [ ExceptionClassName,ExceptionMessage,
      ModuleName, ModuleAddress,
      SrcName, SrcLine ] );
end;

procedure TfMain.ExcShow( Title,ExceptionMessage,CallStack,Registers: PChar );
begin
  fExcDialog.Caption      := Title;
  fExcDialog.memoMsg.Text := ExceptionMessage;
  fExcDialog.ShowModal;
end;

procedure TfMain.cbEnabledClick(Sender: TObject);
begin
  ExceptionHook.Enabled := cbEnabled.Checked;

  cbLogToFile.Enabled := cbEnabled.Checked;
  cbLogOnce.Enabled := cbEnabled.Checked;
  cbHookMsg.Enabled := cbEnabled.Checked;
  cbHookDlg.Enabled := cbEnabled.Checked;
  eLogFile.Enabled := cbEnabled.Checked;
end;

procedure TfMain.cbHookMsgClick(Sender: TObject);
begin
  if cbHookMsg.Checked then ExceptionHook.OnExceptionMsg := ExcMsg
                       else ExceptionHook.OnExceptionMsg := nil;
end;

procedure TfMain.cbHookDlgClick(Sender: TObject);
begin
  if cbHookDlg.Checked then ExceptionHook.OnExceptionShow := ExcShow
                       else ExceptionHook.OnExceptionShow := nil;
end;

procedure TfMain.cbLogToFileClick(Sender: TObject);
begin
  ExceptionHook.LogEnabled := cbLogToFile.Checked;
end;

procedure TfMain.eLogFileChange(Sender: TObject);
begin
  ExceptionHook.LogFile := eLogFile.Text;
end;

procedure TfMain.cbLogOnceClick(Sender: TObject);
begin
  ExceptionHook.LogOnce := cbLogOnce.Checked;
end;

procedure TfMain.btnRaiseClick(Sender: TObject);
var
  ModIdx, ProcIdx: Integer;
begin
  ExceptionHook.ProcName( @TfMain.btnRaiseClick, ModIdx, ProcIdx );
  raise Exception.CreateFmt( 'Manually raised ERROR in proc %s', [ ExceptionHook.Names[ProcIdx] ]  );
end;

procedure TfMain.btnBoundsClick(Sender: TObject);
var
  Tmp: array[ 5..10 ] of Boolean;
  Idx: Integer;
begin
{$RANGECHECKS ON}
  for Idx := 5 to 25 do Tmp[Idx] := True;
{$RANGECHECKS OFF}
end;

procedure TfMain.btnIOClick(Sender: TObject);
begin
  WriteLn( 'Ooops' );
end;

procedure TfMain.btnVCLClick(Sender: TObject);
begin
  btnVCL.Assign( gbGeneral );
end;

procedure TfMain.btnTryExceptClick(Sender: TObject);
begin
  try
    WriteLn( 'Ooops' );
  except
    on E: Exception do Application.ShowException( E );
  end;
end;


procedure TfMain.btnAccessClick(Sender: TObject);
begin
  asm
       mov     eax,11111111h
       mov     ebx,22222222h
       mov     ecx,33333333h
       mov     edx,44444444h
       inc     dword ptr [eax]
  end;
end;

end.
