unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, EvalExPa, Db, DBTables, DBCtrls, EvalNav, Grids, DBGrids,
  ComCtrls, StdCtrls, Buttons, eval, evalist, EvalSimp, EvalCom, EvalPar,
  Menus,ShellAPI;

resourcestring
  rsErrorValue  ='Chybn vstupn hodnota';
  rsResult      ='Vsledok : %10.4f';

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    Panel1: TPanel;
    GR1: TDBGrid;
    EvalDBNavigator1: TEvalDBNavigator;
    PLANETKY: TTable;
    DataSource1: TDataSource;
    EV_CALC: TEval;
    GroupBox1: TGroupBox;
    EC: TComboBox;
    BitBtn1: TBitBtn;
    GroupBox2: TGroupBox;
    CF: TComboBox;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    EV_FILTER: TEval;
    Label3: TLabel;
    Panel2: TPanel;
    Label4: TLabel;
    DBGrid1: TDBGrid;
    EvalDBNavigator2: TEvalDBNavigator;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    CB2: TComboBox;
    BitBtn3: TBitBtn;
    EL: TEvalList;
    LblFields: TLabel;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    GroupBox7: TGroupBox;
    GC: TEvalFnGroupCombo;
    FC: TEvalFnComboBox;
    GroupBox8: TGroupBox;
    FNPANEL: TEvalFnPanel;
    TabSheet1: TTabSheet;
    GroupBox9: TGroupBox;
    GroupBox10: TGroupBox;
    ARGS: TEvalParams;
    GL: TEvalFnGroupList;
    GroupBox11: TGroupBox;
    FL: TEvalFnListBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    EVAL_FN: TEval;
    LBL1: TLabel;
    BitBtn4: TBitBtn;
    PB: TProgressBar;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    GroupBox6: TGroupBox;
    Label10: TLabel;
    HIS: TEvalHistoryCombo;
    EvalDBNavigator3: TEvalDBNavigator;
    GR2: TDBGrid;
    Label13: TLabel;
    EV_HISTORY: TEval;
    BitBtn5: TBitBtn;
    HisRadio: TRadioGroup;
    TabSheet8: TTabSheet;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Image1: TImage;
    PM: TPopupMenu;
    Color1: TMenuItem;
    Font1: TMenuItem;
    ArgPosition: TRadioGroup;
    GroupBox12: TGroupBox;
    Label19: TLabel;
    HtmlStyle: TRadioGroup;
    BitBtn6: TBitBtn;
    Label20: TLabel;
    BitBtn8: TBitBtn;
    SIMPLE_LABEL: TLabel;
    Panel3: TPanel;
    EVAL_SIMPLE: TEval;
    SimpleGRID: TDBGrid;
    EvalDBNavigator4: TEvalDBNavigator;
    ME: TMemo;
    Button1: TButton;
    TabSheet9: TTabSheet;
    IN_FN: TComboBox;
    IN_LOW: TEdit;
    IN_HIGH: TEdit;
    IN_STEPS: TEdit;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Button2: TButton;
    EVAL_INTEGRAL: TEval;
    PLANETKYPLANET: TIntegerField;
    PLANETKYEQUINOX: TSmallintField;
    PLANETKYEPOCHA: TDateField;
    PLANETKYPeri: TDateTimeField;
    PLANETKYM: TFloatField;
    PLANETKYOMEGA: TFloatField;
    PLANETKYNODE: TFloatField;
    PLANETKYI: TFloatField;
    PLANETKYE: TFloatField;
    PLANETKYDMOTION: TFloatField;
    PLANETKYH: TFloatField;
    PLANETKYG: TFloatField;
    PLANETKYPert: TStringField;
    PLANETKYPert2: TStringField;
    PLANETKYNOPP: TSmallintField;
    PLANETKYNOBS: TSmallintField;
    PLANETKYYear1: TSmallintField;
    PLANETKYYear2: TSmallintField;
    PLANETKYRMS: TFloatField;
    PLANETKYSource: TStringField;
    PLANETKYName: TStringField;
    PLANETKYAutor: TStringField;
    PLANETKYUNum: TStringField;
    PLANETKYDate: TDateField;
    Memo1: TMemo;
    SMP: TEvalSimpleDesigner;
    CS: TRadioGroup;
    procedure BitBtn2Click(Sender: TObject);
    procedure GR1DrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FNPANELFunctionChange(Sender: TObject);
    procedure GLClick(Sender: TObject);
    procedure GCChange(Sender: TObject);
    procedure FLClick(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure EV_FILTERProgress(Sender: TObject; Position: Integer);
    procedure GR2DrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure BitBtn5Click(Sender: TObject);
    procedure HISChange(Sender: TObject);
    procedure HisRadioClick(Sender: TObject);
    procedure ArgPositionClick(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure SimpleGridDrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure BitBtn8Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SMPEvalChange(Sender: TObject);
    procedure PLANETKYBeforeOpen(DataSet: TDataSet);
    procedure CSClick(Sender: TObject);
  private
    FieldCounter : Integer;
    procedure    TestSimpleDesigner(DataSet: TDataSet; var Accept: Boolean);
  public
    { Public declarations }
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}

uses EvalDefs, AboutU;

resourcestring
   rsFilter = 'Records in filter : %d';
   rsHistoryLabel = 'Condition - source code : ';

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
     EV_FILTER.Expression := CF.Text;
end;

procedure TForm1.GR1DrawColumnCell(Sender: TObject; const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
     if (EV_FILTER.Expression<>'') and (EV_FILTER.AsBoolean) then
           GR1.Canvas.Brush.Color:=clYellow;

     GR1.DefaultDrawColumnCell(Rect,DataCol,Column,State);
end;




procedure TForm1.BitBtn3Click(Sender: TObject);
var i:Integer;
    s:String;
begin
     EL.CreateCalcField('EC'+IntToStr(FieldCounter),20,CB2.Text);
     Inc(FieldCounter);

     s:='EvalList fields';
     for i:=0 to EL.Count-1 do
         s:=s+#13#10+EL.Evals[i].Field.FieldName+' - '+EL.Evals[i].Expression;
     LblFields.Caption:=s;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     FieldCounter := 0;
     CB2.Items.Assign(EC.Items);
     Label13.Caption:=rsHistoryLabel;
     HIS.FileName := ExtractFilePath(Application.ExeName)+'FILTERS.HIS';

     SMP.Cells[1,0]:='PLANET';
     SMP.Cells[2,0]:='>=';
     SMP.Cells[3,0]:='5';
     SMP.Cells[0,1]:='and';
     SMP.Cells[1,1]:='PLANET';
     SMP.Cells[2,1]:='<=';
     SMP.Cells[3,1]:='10';
     SMP.Cells[0,2]:='or';
     SMP.Cells[1,2]:='PLANET';
     SMP.Cells[2,2]:='=';
     SMP.Cells[3,2]:='13';
     SMP.EvalComboChange(SMP);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var F:TField;
begin
     F:=EV_CALC.CreateCalcField('EvalCalc',20,EC.Text);
     F.Index:=0;
end;



procedure TForm1.FNPANELFunctionChange(Sender: TObject);
begin
     ARGS.SelectedFunction:=FNPANEL.SelectedFunction;
end;

procedure TForm1.GLClick(Sender: TObject);
begin
     FL.FunctionType:=GL.FunctionType;
end;

procedure TForm1.GCChange(Sender: TObject);
begin
     FC.FunctionType:=GC.FunctionType;
end;

procedure TForm1.FLClick(Sender: TObject);
var F:TEvalSymbol;
begin
     F:=FL.SelectedFunction;
     LBL1.Caption:=GetFunctionBySymbol(F).Hint;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
var i:Integer;
begin
     PB.Visible:=True;
     i:=EV_FILTER.RecordCount;
     PB.Visible:=False;
     ShowMessage(Format(rsFilter,[i]));
end;

procedure TForm1.EV_FILTERProgress(Sender: TObject; Position: Integer);
begin
     PB.Position:=Position;
end;


procedure TForm1.GR2DrawColumnCell(Sender: TObject; const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
     if (EV_HISTORY.Expression<>'') and (EV_HISTORY.AsBoolean) then
           GR2.Canvas.Brush.Color:=clYellow;

     GR2.DefaultDrawColumnCell(Rect,DataCol,Column,State);

end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
     HIS.AddWithQuestion(CF.Text);     
end;

procedure TForm1.HISChange(Sender: TObject);
begin
     Label13.Caption:=rsHistoryLabel+' '+HIS.Expression;
end;

procedure TForm1.HisRadioClick(Sender: TObject);
begin
     HIS.FileNameKey:=HisRadio.Items[HisRadio.ItemIndex];
end;

procedure TForm1.ArgPositionClick(Sender: TObject);
begin
     ARGS.ListStyle :=TListStyle(ArgPosition.ItemIndex);
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
var F:TFileName;
begin
    F:=ExtractFilePath(Application.ExeName)+'fn.html';
    CreateFunctionHTML(F,TEvalHtml(HtmlStyle.ItemIndex));
    ShellExecute(Application.Handle,'open',PChar(F),nil,nil,SW_SHOW);         
end;

procedure TForm1.SimpleGridDrawColumnCell(Sender: TObject;
  const Rect: TRect; DataCol: Integer; Column: TColumn;
  State: TGridDrawState);
begin
     if CS.ItemIndex=0 then
       if (EVAL_SIMPLE.Expression<>'') and (EVAL_SIMPLE.AsBoolean) then
           SimpleGrid.Canvas.Brush.Color:=clYellow;

     SimpleGrid.DefaultDrawColumnCell(Rect,DataCol,Column,State);
end;

procedure TForm1.BitBtn8Click(Sender: TObject);
begin
     AboutFmt:=TAboutFmt.Create(Application);
     try
        AboutFmt.ShowModal;
     finally
        AboutFmt.Free;
     end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var _From,_To,Value : Double;
    _Steps          : Integer;
begin
   try
     _Steps :=StrToInt(IN_STEPS.Text);
     _From  :=StrToFloat(IN_LOW.Text);
     _To    :=StrToFloat(IN_HIGH.Text);

     value:=EVAL_INTEGRAL.Integral(IN_FN.Text,'X',_From,_To,_Steps);
     MessageDlg(Format(rsResult,[value]),mtInformation,[mbOK],0);
   except
        ShowMessage(rsErrorValue);
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var i:Integer;
begin
     ME.Lines.Clear;
     for i:=1 to GetFunctionCount do
        ME.Lines.Add(getFnCall(i));
end;

procedure TForm1.SMPEvalChange(Sender: TObject);
begin
     SIMPLE_LABEL.Caption  :=SMP.Expression;
     EVAL_SIMPLE.Expression:=SMP.Expression;
end;

procedure TForm1.PLANETKYBeforeOpen(DataSet: TDataSet);
begin
     PLANETKY.TableName := ExtractFilePath(Application.ExeName)+'PLANETKY.DB';
end;

procedure TForm1.CSClick(Sender: TObject);
begin
     if CS.ItemIndex=1 then begin
        PLANETKY.OnFilterRecord := TestSimpleDesigner;
        PLANETKY.Filtered       := True;
     end else begin
        PLANETKY.OnFilterRecord := nil;
        PLANETKY.Filtered       := False;
     end;
end;


procedure TForm1.TestSimpleDesigner(DataSet: TDataSet; var Accept: Boolean);
begin
     Accept := (EVAL_SIMPLE.Expression='') or (EVAL_SIMPLE.AsBoolean);
end;



end.
