// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ExcMagic.pas' rev: 5.00

#ifndef ExcMagicHPP
#define ExcMagicHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <ExcMagicUtils.hpp>	// Pascal unit
#include <ExcUnmangle.hpp>	// Pascal unit
#include <ExcMemMap.hpp>	// Pascal unit
#include <SysConst.hpp>	// Pascal unit
#include <Commctrl.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Excmagic
{
//-- type declarations -------------------------------------------------------
typedef unsigned TLongArray[1];

typedef unsigned *PLongArray;

typedef unsigned TLongwordArray[1];

typedef unsigned *PLongwordArray;

class DELPHICLASS EExcMagicError;
class PASCALIMPLEMENTATION EExcMagicError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EExcMagicError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EExcMagicError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EExcMagicError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EExcMagicError(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EExcMagicError(const AnsiString Msg, int AHelpContext)
		 : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EExcMagicError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EExcMagicError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EExcMagicError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EExcMagicError(void) { }
	#pragma option pop
	
};


struct TDS_SubsectionHeader;
typedef TDS_SubsectionHeader *PDS_SubsectionHeader;

#pragma pack(push, 1)
struct TDS_SubsectionHeader
{
	Word sshHeaderSize;
	Word sshRecordSize;
	int sshRecordCount;
	Byte reserved[8];
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct TDS_SubsectionEntry
{
	Word sseType;
	Word sseModIndex;
	unsigned sseOffset;
	unsigned sseSize;
} ;
#pragma pack(pop)

typedef TDS_SubsectionEntry TDS_SubsectionEntryArray[1];

typedef TDS_SubsectionEntry *PTDS_SubsectionEntryArray;

#pragma pack(push, 1)
struct TDS_SegmentRange
{
	unsigned sStart;
	unsigned sEnd;
} ;
#pragma pack(pop)

typedef TDS_SegmentRange TDS_SegmentRangeArray[1];

typedef TDS_SegmentRange *PTDS_SegmentRangeArray;

#pragma pack(push, 1)
struct TDS_LineNum
{
	Word LineNum;
	unsigned Offset;
} ;
#pragma pack(pop)

struct TExceptionRecord;
typedef TExceptionRecord *PExceptionRecord;

#pragma pack(push, 1)
struct TExceptionRecord
{
	unsigned ExceptionCode;
	unsigned ExceptionFlags;
	TExceptionRecord *OuterException;
	void *ExceptionAddress;
	int NumberParameters;
	union
	{
		struct 
		{
			void *ExceptAddr;
			void *ExceptObject;
			unsigned ExceptEBX;
			unsigned ExceptESI;
			unsigned ExceptEDI;
			unsigned ExceptEBP;
			unsigned ExceptESP;
			
		};
		struct 
		{
			int ExceptionInformation[15];
			
		};
		
	};
} ;
#pragma pack(pop)

class DELPHICLASS TModuleDebugInfo;
class PASCALIMPLEMENTATION TModuleDebugInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Excmemmap::TMMFileStream* FMMFile;
	AnsiString FName;
	bool FLoaded;
	unsigned FInstance;
	Windows::_IMAGE_DOS_HEADER *FPDosHdr;
	_IMAGE_NT_HEADERS *FPImgHdr;
	unsigned FSignature;
	unsigned FTDSTotalSize;
	unsigned FTDSOffset;
	unsigned FTDSDataSize;
	#pragma pack(push, 1)
	TDS_SubsectionHeader FTDSSubdir;
	#pragma pack(pop)
	
	TDS_SubsectionEntry *FTDSEntries;
	TDS_SubsectionEntry FsstSrcTable[3];
	int FsstSrcCount;
	int FNamesCount;
	unsigned *FNameIndexes;
	void * __fastcall GetConvertedAddress(void * Address);
	unsigned __fastcall EntryOffset(int Index);
	void __fastcall GetModuleName(void * Address, char * ModuleName, int ModuleNameSize);
	int __fastcall FindProc(void * Address, int Module);
	bool __fastcall GetSourceLine(void * Address, int &SrcFileNameIndex, int &SrcLineNum);
	bool __fastcall GetProcName(void * Address, int &ModuleNameIndex, int &ProcNameIndex);
	AnsiString __fastcall GetName(int Index);
	bool __fastcall GetIsDelphi(void);
	bool __fastcall CreateNamesArray(void);
	bool __fastcall LoadTDS(AnsiString AFileName);
	bool __fastcall LoadTDS2(void);
	bool __fastcall LoadDebugInfo(AnsiString FileName);
	void __fastcall UnLoadDebugInfo(void);
	
public:
	__fastcall TModuleDebugInfo(const AnsiString FileName, const unsigned Inst);
	__fastcall virtual ~TModuleDebugInfo(void);
	bool __fastcall IsInCode(void * Address);
	void * __fastcall GetLogicalAddr(void * Address);
	bool __fastcall SourceLine(void * Address, int &SrcFileNameIndex, int &SrcLineNum);
	bool __fastcall ProcName(void * Address, int &ModuleNameIndex, int &ProcNameIndex);
	__property AnsiString ModuleName = {read=FName};
	__property AnsiString Names[int Index] = {read=GetName};
	__property bool Loaded = {read=FLoaded, nodefault};
	__property bool IsDelphiModule = {read=GetIsDelphi, nodefault};
};


#pragma pack(push, 1)
struct TCallStackItem
{
	TModuleDebugInfo* DebugModule;
	void *CallAddress;
	int ModuleNameIndex;
	int ProcNameIndex;
	int FileNameIndex;
	int FileLineNumber;
	int NestingLevel;
} ;
#pragma pack(pop)

typedef TCallStackItem *PCallStackItem;

class DELPHICLASS TExcCallStack;
class PASCALIMPLEMENTATION TExcCallStack : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	PCallStackItem __fastcall GetItem(int Index);
	
public:
	void __stdcall GenerateFromAddr(void * Address, unsigned RegEBP, int MaxSize, bool SuppressRecursion
		);
	void __stdcall Generate(int MaxSize, bool SuppressRecursion);
	virtual void __fastcall Clear(void);
	void __fastcall Dump(Classes::TStringList* StrList);
	__property PCallStackItem Items[int Index] = {read=GetItem};
public:
	#pragma option push -w-inl
	/* TList.Destroy */ inline __fastcall virtual ~TExcCallStack(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TExcCallStack(void) : Classes::TList() { }
	#pragma option pop
	
};


struct TExceptionMessageInfo
{
	AnsiString miMessage;
	char miModuleName[261];
	void *miVirtualAddress;
	void *miModuleAddress;
	int miModuleNameIndex;
	int miProcNameIndex;
	int miSrcNameIndex;
	int miSrcLineNum;
	TModuleDebugInfo* miDebugModule;
} ;

typedef void __fastcall (__closure *TExcMagicMsgProc)(System::TObject* ExceptionObject, const TExceptionMessageInfo 
	&MessageInfo, char * Buffer, int BufferSize);

typedef void __fastcall (__closure *TExcMagicShowProc)(AnsiString Title, AnsiString ExceptionMessage
	, Classes::TStringList* CallStack, Classes::TStringList* Registers, Classes::TStringList* CustomInfo
	);

typedef void __fastcall (__closure *TExcMagicLogProc)(char * Buffer, int BufferSize, Classes::TStringList* 
	CallStack, Classes::TStringList* Registers, Classes::TStringList* CustomInfo);

typedef void __fastcall (__closure *TExcMagicCustomInfoProc)(Classes::TStringList* CustomInfo);

typedef void __fastcall (__closure *TExcMagicTerminateProc)(bool &CloseDialog);

#pragma option push -b-
enum TExcMagicOption { excDlgDetailed, excDlgCallStack, excDlgRegisters, excDlgCustomInfo, excDlgTerminate, 
	excShowDialog };
#pragma option pop

typedef Set<TExcMagicOption, excDlgDetailed, excShowDialog>  TExcMagicOptions;

struct TSourceInfo
{
	TModuleDebugInfo* ModuleDebugInfo;
	AnsiString ModuleName;
	AnsiString FileName;
	AnsiString ProcName;
	int LineNumber;
} ;

class DELPHICLASS TExcMagic;
class PASCALIMPLEMENTATION TExcMagic : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TExcCallStack* FCallStack;
	Classes::TStringList* FCallStackStrings;
	Classes::TStringList* FContextStrings;
	Classes::TStringList* FCustomInfoStrings;
	AnsiString FCustomTab;
	Classes::TList* FModules;
	char *FIcon;
	bool FEnabled;
	AnsiString FLogFile;
	bool FLogEnabled;
	bool FLogHandled;
	TExcMagicOptions FOptions;
	int FMaxCallStack;
	bool FSuppressRecursion;
	TExcMagicMsgProc FOnExceptionMsg;
	TExcMagicShowProc FOnExceptionShow;
	TExcMagicLogProc FOnExceptionLog;
	TExcMagicCustomInfoProc FOnCustomInfo;
	TExcMagicTerminateProc FOnTerminate;
	void __fastcall SetEnabled(bool Value);
	AnsiString __fastcall GetExcMagicAbout(void);
	AnsiString __fastcall GetExcMagicVersion(void);
	TModuleDebugInfo* __fastcall FindDebugModule(void * Address);
	void __fastcall LogExceptionData(char * Buffer, int BufLen);
	void __fastcall DumpAll(void);
	void __fastcall DumpContext(Classes::TStringList* StrList);
	_CONTEXT __fastcall GetContext(void);
	TExceptionRecord __fastcall GetExceptionRec(void);
	TExceptionMessageInfo __fastcall GetExceptionInfo(void);
	
public:
	__fastcall TExcMagic(void);
	__fastcall virtual ~TExcMagic(void);
	AnsiString __fastcall UnMangle(AnsiString Source, bool IsDelphi);
	bool __fastcall GetAddressSourceInfo(void * Address, TModuleDebugInfo* &ModuleDebugInfo, AnsiString 
		&ModuleName, AnsiString &FileName, AnsiString &ProcName, int &LineNumber);
	bool __stdcall GetSourceInfo(TModuleDebugInfo* &ModuleDebugInfo, AnsiString &ModuleName, AnsiString 
		&FileName, AnsiString &ProcName, int &LineNumber);
	TSourceInfo __fastcall GetAddressSourceInfoRec(void * Address);
	TSourceInfo __stdcall GetSourceInfoRec(void);
	void __fastcall LogException(void);
	void __fastcall Log(char * Text, bool WithHeader);
	__property AnsiString About = {read=GetExcMagicAbout};
	__property TExcCallStack* CallStack = {read=FCallStack};
	__property AnsiString CustomTab = {read=FCustomTab, write=FCustomTab};
	__property bool Enabled = {read=FEnabled, write=SetEnabled, default=1};
	__property _CONTEXT ExceptionContext = {read=GetContext};
	__property TExceptionMessageInfo ExceptionInfo = {read=GetExceptionInfo};
	__property TExceptionRecord ExceptionRec = {read=GetExceptionRec};
	__property char * Icon = {read=FIcon, write=FIcon};
	__property bool LogEnabled = {read=FLogEnabled, write=FLogEnabled, default=1};
	__property AnsiString LogFile = {read=FLogFile, write=FLogFile};
	__property bool LogHandled = {read=FLogHandled, write=FLogHandled, default=0};
	__property int MaxCallStack = {read=FMaxCallStack, write=FMaxCallStack, default=100};
	__property bool SuppressRecursion = {read=FSuppressRecursion, write=FSuppressRecursion, default=1};
		
	__property TExcMagicOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property AnsiString Version = {read=GetExcMagicVersion};
	__property TExcMagicMsgProc OnExceptionMsg = {read=FOnExceptionMsg, write=FOnExceptionMsg};
	__property TExcMagicShowProc OnExceptionShow = {read=FOnExceptionShow, write=FOnExceptionShow};
	__property TExcMagicLogProc OnExceptionLog = {read=FOnExceptionLog, write=FOnExceptionLog};
	__property TExcMagicCustomInfoProc OnCustomInfo = {read=FOnCustomInfo, write=FOnCustomInfo};
	__property TExcMagicTerminateProc OnTerminate = {read=FOnTerminate, write=FOnTerminate};
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint MAX_SRCMODULE = 0x3;
extern PACKAGE TExcMagic* ExceptionHook;

}	/* namespace Excmagic */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Excmagic;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ExcMagic
