// 
{*******************************************************}
{                                                       }
{         E L E K S   S P I T T E D  P A N E L S        }        
{                                                       }
{        Copyright (C) 1998, 1999 Eleks Software        }
{               Created by Yuri Solodkiy                }
{                                                       }
{                 http://eleks.txnet.com                }
{                    eleks@txnet.com                    }
{                   gerasika@yahoo.com                  }                            
{                                                       }
{*******************************************************}


// $Archive: /H/Gerix/Projects/elSplittedPanels/elSplittedPanels.pas $ $Author: Gerix $ $Date: 19.08.99 12:50 $ $Revision: 2 $ $Workfile: elSplittedPanels.pas $

unit elSplittedPanels;
//     BeginDeferWindowPos, DeferWindowPos, EndDeferwindowPos
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TelSplittedPanels = class;

  TOrientation = (orHorizontal, orVertical);
  TSide = (sdFirst, sdSecond);
  TSplitterBevelStyle = (sbsNone, sbsLowered, sbsSingle);
  
  PDoublePoint = ^TDoublePoint;
  TDoublePoint = record
    x: double;
    y: double;
  end;

  TelSplitterLine = class
  private
{  }
  public
    property BorderLine: boolean read FBorderLine;
    property BorderIndex: integer read FBorderIndex;
    property Orientation: TOrientation read FOrientation;
    property FirstPointPosition: double read FFirstPointPosition;
    property SecondPointPosition: double read FSecondPointPosition;
    property Position: double read FPosition;

    constructor Create(ASplittedPanels: TelSplittedPanels; AOrientation: TOrientation; AFirstPointPosition: double; ASecondPointPosition: double; APosition: double);
    destructor Destroy; override;
  end;

  TelSplittedPanel = class(TCollectionItem)
  private
{  }
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    function Split(Kind: TOrientation): TelSplittedPanel;
    function SplitAt(Kind: TOrientation; At: double): TelSplittedPanel;
    function BoundsRect: TRect;
    procedure DesignPaint(Canvas: TCanvas);
    property LeftLine: TelSplitterLine read FLeftLine;
    property RightLine: TelSplitterLine read FRightLine;
    property TopLine: TelSplitterLine read FTopLine;
    property BottomLine: TelSplitterLine read FBottomLine;
  published
    property OnMouseDown: TMouseEvent read FOnMouseDown write FOnMouseDown;
    property OnMouseUp: TMouseEvent read FOnMouseUp write FOnMouseUp;
    property OnMouseMove: TMouseMoveEvent read FOnMouseMove write FOnMouseMove;
    property Control: TControl read FControl write SetControl;
  end;

  TelSplittedPanelCollection = class(TCollection)
  private
{  }
  protected { overrides }
    function GetOwner: TPersistent; override;
  private
    constructor Create(ASplittedPanels: TelSplittedPanels);
  public
    property Items[Index: integer]: TelSplittedPanel read GetItems write SetItems; default;
  end;

  TelSplittedPanels = class(TCustomPanel)
  private
{  }
  protected { overrides }
    procedure DefineProperties(Filer: TFiler); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Paint; override;
    procedure Resize; override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CMDesignHitTest(var Message: TCMDesignHitTest); message CM_DesignHitTest;
    procedure WMNCHitTest(var Msg: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SetCursor;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure AlignControls(AControl: TControl; var Rect: TRect); override;
  protected
    function GetLineCount: integer;
    function GetLines(Index: integer): TelSplitterLine;
    property LineCount: integer read GetLineCount;
    property Lines[Index: integer]: TelSplitterLine read GetLines;
  public
    function PanelAt(const Point: TPoint): TelSplittedPanel;
    function FindControlPanel(Control: TControl): TelSplittedPanel;
    procedure MoveLine(Line: TelSplitterLine; PositionDelta: double; Check: boolean);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property SplitterWidth: integer read FSplitterWidth write SetSplitterWidth default 7;
    property Panels: TelSplittedPanelCollection read FPanels write FPanels;
    property Align default alClient;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FullRepaint;
    property Color;
    property Ctl3D;
    property Font;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnResize;
    property OnStartDrag;
    property BevelsStyle: TSplitterBevelStyle read FBevelsStyle write SetBevelsStyle default sbsSingle;
  end;

implementation

{  }

end.

