{ $Archive: /!!S/UNITS.PCK/StrUtilz.pas $ $Author: Admin $ $Date: 11.06.99 18:35 $ }
  
unit StrUtilz;

interface

uses
  Classes;

  { Ansi - Windows Charsets, Oem - DOS, Writeln requeries Oem }
{$IFNDEF VER80}
function AnsiToOem(const Str: string): string;
function OemToAnsi(const Str: string): string;
  {    KeyUkr    Ansi, 
    OemToAnsi }
function KeyukrCorrection(const Str: string): string;
procedure Writeln2(const Str: string);
{$ENDIF}
function Like(const Mask,Str: string): boolean;
function isPrefix(const SubStr,Str: string): boolean;
function is2Prefix(const SubStr,SubStr2,Str: string): boolean;
function isSuffix(const SubStr, Str: string): boolean;

function StrCharCount(Str: string; Ch: char): integer;
function LastPos(Ch: char; s: string): integer;

function CopyAfter(const SubStr, Str: string): string;
function CopyBefore(const SubStr,Str:string): string;
procedure CopyBeforeAndAfter(const SubStr, Str: string; out Before, After: string);
function ValidateIdent(const Ident: string): string;
function IdentPos(const Ident, Code: string): Integer;
function GetIdent(const Code: string): string;
function GetIdentAt(const Code: string;Col: Smallint): string;
function IsInsideSubStr(const SubStr, Str: string; var Col: Integer): Boolean;
function KillBlanks(const Str: string):string;
function KillLowerCase(const Str: string): string;
function Blanks(Count: integer): string;
function RemoveExtraBlanks(const Str: string): string;
function ReplaceStr(TextToFind: string; ReplaceWith: string; Str: string): string;
function ExtractQuotedStr(const Str: string; Quote: char): string;
function StrToRTF(const Str: string): string;
function StrToHTML(const Str: string): string;
function SplitByDelimiter(Source: string; Delim: char; out Left, Right: string): boolean;
{$ifdef VER100}
function FormatTemplate(TemplateStr: string; Params: TStrings): string;
{$endif}

function FileNameToSourceSafe(const FileName: string): string;
function StrToRichText(const Str: string): string;
{$IFNDEF VER80}
function _ExtractFilePath(const FileName: string): string;
function _ExtractFileName(const FileName: string): string;
{ Suxx: To be removed }
function FileModified(const FileName: string; var ModificationDate: integer): boolean;
function GetTemporaryFolder: string;
procedure InprocExec(const FileName: string);
{$ENDIF}
function sif(Cond: boolean; const Str1,Str2: string): string;
function iif(Cond: boolean; Int1, Int2: integer): integer;
function CompareInt(Int1, Int2: integer): integer;

function StripDir(const S : String): String;
function DressDir(const S : String): String;


function ByteToStr(Value: byte): string;
function StrToByte(Str: string): byte;

function BytesToStr(Value: Integer): String;

const
  ValidIdentChars: set of char = ['a' .. 'z', 'A' .. 'Z', '_'];
  CaseSensitive: boolean = false;

{$IFDEF VER80} { Copied from SysUtils }
{: Trim trims leading and trailing spaces and control characters from the
  given string. }
function Trim(const S: string): string;
{: TrimLeft trims leading spaces and control characters from the given
  string. }
function TrimLeft(const S: string): string;
{: TrimRight trims trailing spaces and control characters from the given
  string. }
function TrimRight(const S: string): string;
{$ENDIF}

const
  BeginDateTimeSubString = '%~';
  EndDateTimeSubString   = '~%';
{find substring bordered (%~) and (~%) and Formated it by FormatDateTime }
function InternalFormatDateTime(ThisString: string; DateTime: TDateTime): string;

{ Support wild characters '*' and '?' }
function WildCompareStr(const Mask: string; const Source: string): boolean;

{ Cyr to alpha }
function toalpha(c: char): char;
function CopyShortName(s: string): string;
{$IFNDEF VER80}
function GetHashValueOfStr(const Str: String): Integer;
{$ENDIF}
implementation

uses {$IFNDEF VER80}ActiveX, {$ENDIF}WinTypes, WinProcs, SysUtils;

{$IFNDEF VER80}
function _ExtractFilePath(const FileName: string): string;
var
  I: Integer;
begin
  I := LastDelimiter('\/:', FileName);
  Result := Copy(FileName, 1, I);
end;

function _ExtractFileName(const FileName: string): string;
var
  I: Integer;
begin
  I := LastDelimiter('\/:', FileName);
  Result := Copy(FileName, I + 1, System.MaxInt);
end;

function FileModified(const FileName: string; var ModificationDate: integer): boolean;
var
  FileHandle: integer;
  ModiDate: integer;
begin
  FileHandle := FileOpen(FileName,fmOpenRead);
  try
    ModiDate := FileGetDate(FileHandle);
    Result := ModiDate <> ModificationDate;
    if Result then ModificationDate := ModiDate;
  finally
    FileClose(FileHandle);
  end;
end;

function GetTemporaryFolder: string;
var
  _ : array [ 0 .. 255 ] of Char;
begin
  FillChar(_,SizeOf(_),0);
  GetEnvironmentVariable('TEMP',_,255);
  Result := _;
end;

procedure InprocExec(const FileName: string);
var
  StartupInfo: TStartupInfo;
  ProcessInfo: TProcessInformation;
begin
  FillChar(StartupInfo,Sizeof(StartupInfo),0);
  CreateProcess(nil,PChar(FileName),
         nil,nil,false,0,nil,nil,StartupInfo,ProcessInfo);
  try
{$IFDEF VER120}
    WaitForSingleObject(ProcessInfo.hProcess, LongWord(-1));
{$ELSE}
    WaitForSingleObject(ProcessInfo.hProcess, INFINITE);
{$ENDIF}
  finally
    CloseHandle(ProcessInfo.hProcess);
  end;
end;

function AnsiToOem(const Str: string): string;
var
  p1,
  p2: PChar;
  i: integer;
begin
  Result := Str;
  for i := 1 to Length(Result) do begin
    case Result[i] of
      '': Result[i] := 'i';
      '': Result[i] := 'I';
    end;
  end;
  p1 := PChar(Result);
  p2 := StrNew(p1);
  CharToOem(p1, p2);
  Result := StrPas(p2);
  StrDispose(p2);
end;

function OemToAnsi(const Str: string): string;
var
  p1,
  p2: PChar;
begin
  p1 := PChar(Str);
  p2 := StrNew(p1);
  OemToChar(p1, p2);
  Result := StrPas(p2);
  StrDispose(p2);
end;

function KeyukrCorrection(const Str: string): string;
var
  i: integer;
begin
  Result := Str;
  for i := 1 to Length(Result) do
    case Result[I] of
      '': Result[I] := '';
      '': Result[I] := '';
      '': Result[I] := '';
      '': Result[I] := '';
      '': Result[I] := '';
      '': Result[I] := '';
      '': Result[I] := '';
      '': Result[I] := '';
    end;
end;

procedure Writeln2(const Str: string);
begin
  Writeln(AnsiToOem(Str));
end;

{$ENDIF}
function sif(Cond: boolean; const Str1,Str2: string): string;
begin
  if Cond then Result := Str1 else Result := Str2;
end;

function iif(Cond: boolean; Int1, Int2: integer): integer;
begin
  if Cond then Result := Int1 else Result := Int2;
end;

{  FileName  SourceSafe , a: h:\aide2 -> $/h/aide2 }
function FileNameToSourceSafe(const FileName: string): string;
var
  s: string;
  i: integer;
begin
  if FileName='' then Exit;
  s := ExpandFileName(FileName);
  Result :=  '$\'+s[1]+Copy(s,3,Length(s));
  for i := 0 to Length(Result) do
    if Result[i]='\' then Result[i] := '/';
end;

function StrToRichText(const Str: string): string;
var
  i: integer;
begin
  Result := '';
  for i := 1 to Length(Str) do
    begin
      case Str[i] of
        #128 .. #255 :
          Result := Result + '\''' + LowerCase(IntToHex(Ord(Str[i]), 2));
        '\','{','}':
          Result := Result + '\' + Str[i];
        else Result := Result + Str[i];
      end;
    end;
end;

function ReplaceStr(TextToFind: string; ReplaceWith: string; Str: string): string;
var
  fl: integer;
  sl: integer;
  i: integer;
  last: integer;
  function SubStr(Index: integer): boolean;
  var
    j: integer;
  begin
    Result := false;
    for j:=0 to fl-1 do begin
      if Str[Index+j] <> TextToFind[j+1] then exit;
    end;
    Result := true;
  end;
begin
  if Pos(TextToFind, Str) = 0 then begin
    Result := Str;
    exit;
  end;
  fl := Length(TextToFind);
  sl := Length(Str);
  Result := '';
  i := 1;
  last := 1;
  while i<=sl do begin
    if SubStr(i) then begin
      Result := Result + Copy(Str, Last, i-Last);
      Result := Result + ReplaceWith;
      i := i + fl;
      Last := i;
    end else Inc(i);
  end;
  Result := Result + Copy(Str, Last, i-Last);
end;

function ExtractQuotedStr(const Str: string; Quote: char): string;
var
  i: integer;
  _: boolean;
begin
  Result := '';
  if Length(Str) < 2
    then Exit;
  if (Str[1] <> Quote) or (Str[Length(Str)] <> Quote)
    then Exit;
  _ := false;
  for i := 2 to Length(Str) - 1 do
    begin
      if Str[i] = Quote then
        if _ then
          begin
            Result := Result + Quote;
            _ := false;
          end
          else _ := true
        else Result := Result + Str[i];
    end;
end;

function StrToRTF(const Str: string): string;
var
  i: integer;
begin
  Result := '';
  for i := 1 to Length(Str) do begin
    case Str[i] of
      #128 .. #255 :
        Result := Result + '\''' + LowerCase(IntToHex(Ord(Str[i]), 2));
      '\','{','}':
        Result := Result + '\' + Str[i];
      else 
        Result := Result + Str[i];
    end;
  end;
end;

function StrToHTML(const Str: string): string;
var
  i: integer;
begin
  Result := '';
  for i := 1 to Length(Str) do
    case Str[i] of
      '<': Result := Result + '&lt';
      '>': Result := Result + '&gt';
      '&': Result := Result + '&amp';
      '"': Result := Result + '&quot';
      else Result := Result + Str[i];
    end;
end;

function SplitByDelimiter(Source: string; Delim: char; out Left, Right: string): boolean;
var
  ps: integer;
begin
  ps := pos(Delim, Source);
  if ps = 0 then begin
    Left   := Source;
    Right  := '';
    Result := false;
  end
  else begin
    Left   := copy(Source, 1, ps-1);
    Right  := copy(Source, ps+1, Length(Source));
    Result := true;
  end;
  Left := Trim(Left);
  Right := Trim(Right);
end;

{$IFDEF VER100}
function FormatTemplate(TemplateStr: string; Params: TStrings): string;
const
  s_ = '[$';
  f_ = '$]';
var
  i: integer;
  Param: string;
begin
  Result := '';
  repeat
  i := Pos(s_, TemplateStr);
  if i = 0 then
    begin
      Result := Result + TemplateStr;
      Exit;
    end;
  Result := Result + Copy(TemplateStr, 1, i - 1);
  TemplateStr := Copy(TemplateStr, i + Length(s_), MaxInt);
  Param := CopyBefore(f_, TemplateStr);
  i := Params.IndexOfName(Param);
  if i <> -1 then
    begin
      Result := Result + CopyAfter('=', Params[i]);
    end;
  TemplateStr := CopyAfter(f_, TemplateStr);
  until TemplateStr = '';
end;
{$ENDIF}

function CompareInt(Int1, Int2: integer): integer;
begin
  Result := 1;
  if Int1 = Int2
    then Result := 0
    else
      if Int1 < Int2
        then Result := -1
end;

function StripDir(const S : String): String;
var
  CopyLen: Integer;
begin
  CopyLen := Length(S);
  if S[CopyLen] = '\' then Dec(CopyLen);
  Result := Copy(S, 1, CopyLen);
end;

function DressDir(const S : String): String;
begin
  Result := S;
  if Result[Length(Result)] <> '\' then Result := Result + '\';
end;

function ByteToStr(Value: byte): string;
var
  h: byte;
begin
  SetLength(Result, 2);
  h := ((Value shr 4) and $0F);
  if h>9 then inc(h, 7);
  Result[1] := char(h + byte('0'));
  h := (Value and $0F);
  if h>9 then inc(h, 7);
  Result[2] := char(h + byte('0'));
end;

function StrToByte(Str: string): byte;
var
  h: byte;
begin
  h := byte(Str[1]) - byte('0');
  if h > 9 then h := h - 7;
  Result := h shl 4;
  h := byte(Str[2]) - byte('0');
  if h > 9 then h := h - 7;
  Result := Result + h; 
end;

function BytesToStr(Value: Integer): String;
const
  Names: array[0..3] of String[6] = ('', '', '', '');
var
  IntVal: Double;
  I: Integer;
begin
  IntVal := Value;
  I := 0;
  while (IntVal > 1024) and (I < 3) do begin
    Inc(I);
    IntVal := IntVal / 1024;
  end;
  Result := FormatFloat('#########.##', IntVal)+' '+Names[I];
end;


function Blanks(Count: integer): string;
var
  i: integer;
begin
  Result := '';
  for i := 0 to Count - 1 do
    Result := Result + ' ';
end {Blanks};

function RemoveExtraBlanks(const Str: string): string;
var
  i: integer;
begin
  Result := '';
  for i := 1 to Length(Str) do
    begin
      if Str[i] in [#9, ' ', #13, #10] then
        begin
          if (Result = '') or not(Result[Length(Result)] = ' ')
            then Result := Result + ' ';
        end
        else
          if Str[i] in ValidIdentChars
            then Result := Result + Str[i]
            else
              if (Length(Result) = 0) then begin
                Result := Result + Str[i];
              end else begin
                if (Result[Length(Result)] = ' ')
                  then Result[Length(Result)] := Str[i]
                  else Result := Result + Str[i];
              end;    
    end;
  Result := Trim(Result);
end;

function GetIdent(const Code: string): string;
var
  _: Shortstring;
  i: integer;
begin
  Result := '';
  if (Code <> '') and (Code[1] in ValidIdentChars) then begin
    _ := Code[1]; 
    for i := 2 to Length(Code) do
      if (Code[i] in ValidIdentChars) or (Code[i] in ['0' .. '9']) then 
        _ := _ + Code[i]
      else 
        Break;
    Result := _;
  end;
end;

function GetIdentAt(const Code: string;Col: Smallint): string;
var
  i: integer;
begin
  Result := '';
  for i := Col - 1 downto 1 do
    if (Code[i] in ValidIdentChars) or (Code[i] in ['0' .. '9'])
      then Result := Code[i] + Result
      else Break;
  if Result <> ''
    then
      while Result[1] in ['0' .. '9'] do
        begin
          Result := Copy(Result, 2, System.MaxInt);
          if Result = ''
            then Break;
        end;
  for i := Col to Length(Code) do
    if (Code[i] in ValidIdentChars) or (Code[i] in ['0' .. '9'])
      then Result := Result + Code[i]
      else Break;
end;

function IsInsideSubStr(const SubStr, Str: string; var Col: Integer): Boolean;
var
  s: string;
  i,
  j: Integer;
begin
  Result := False;
  s := Str;
  i := 0;
  while s <> '' do
    begin
      j := Pos(SubStr, s);
      if j = 0
        then Break;
      if (j + i <= Col) and (j + i < Col + Length(SubStr)) then
        begin
          Col := j + i + Length(SubStr);
          Result := True;
          Break;
        end
        else
          if j + i < Col then
            begin
              i := i + j;
              s := Copy(s, j + 1, System.MaxInt);
              Continue;
            end
            else Break;
    end;
end;

function KillBlanks(const Str: string):string;
var
  i: integer;
begin
  Result := '';
  for i:= 1 to Length(Str) do
    if Str[i] in [' ',#13,#10,#9] then else Result := Result+Str[i];
end {KillBlanks};

function KillLowerCase(const Str: string): string;
var
  i: integer;
begin
  Result := '';
  for i := 1 to Length(Str) do
    if Str[i] in ['A'..'Z', '0'..'9']
      then Result := Result + Str[i];
end;

{{$O-}
function Like(const Mask,Str: string): boolean;
var
  i: integer;
  function WildCardLike(const Mask,Str: string): boolean;
  var
    i: integer;
  begin
    Result := false;
    if Mask = '' then
      begin
        Result := true;
        Exit;
      end;
    for i := 1 to Length(Str) do
      begin
        Result := Like(Mask,Copy(Str,i,MaxInt));
        if Result then Exit;
      end;
  end;
begin
  Result := false;
  if Length(Mask)>Length(Str) then Exit;
  for i := 1 to Length(Str) do
    begin
      if i>Length(Mask) then Exit;
      case Mask[i] of
        '*':
          begin
            Result := WildCardLike(Copy(Mask,i+1,MaxInt),Copy(Str,i,MaxInt));
            if Result then Exit;
          end;
        '?': Continue;
      else
        if CompareText(Mask[i],Str[i])<>0 then
          begin
            Result := false;
            Exit;
          end;
      end;
    end;
  Result := Length(Str) = Length(Mask);
end;

function isPrefix(const SubStr,Str: string): boolean;
var
  SubStrLength: Integer;
begin
  SubStrLength := Length(SubStr);
  Result := (SubStrLength <= Length(Str)) and 
    (AnsiCompareText(SubStr, Copy(Str, 1, SubStrLength)) = 0);
end;

function is2Prefix(const SubStr,SubStr2,Str: string): boolean;
var
  SubStrLength: Integer;
begin
  SubStrLength := Length(SubStr);
  Result := (SubStrLength <= Length(Str)) and 
    (AnsiCompareText(SubStr, Copy(Str, 1, SubStrLength)) = 0);
  if Result then 
    Result := IsPrefix(SubStr2, TrimLeft(Copy(Str, SubStrLength + 1, MaxInt)));
end;

function isSuffix(const SubStr, Str: string): boolean;
var
  SubStrLength,
  StrLength: Integer;
begin
  SubStrLength := Length(SubStr);
  StrLength := Length(Str);
  Result := (SubStrLength <= StrLength) and 
    (AnsiCompareText(SubStr, Copy(Str, StrLength - SubStrLength + 1, MaxInt)) = 0);
end;

function CopyBefore(const SubStr,Str:string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then 
    Result := Str 
  else 
    Result := Copy(Str,1,_-1);
end;

procedure CopyBeforeAndAfter(const SubStr, Str: string; out Before, After: string);
begin
  Before := CopyBefore(SubStr, Str);
  After  := CopyAfter(SubStr, Str); 
end;

function ValidateIdent(const Ident: string): string;
var
  i: integer;
begin
  Result := '';
  for i := 1 to Length(Ident) do
    if Ident[i] in ['_', 'A' .. 'Z', 'a' .. 'z', '0' .. '9']
      then Result := Result + Ident[i];
end;

function IdentPos(const Ident, Code: string): Integer;
var
  i: Integer;
begin
  Result := Pos(Ident, Code);
  if Result = 0
    then Exit;
  for i := Result to Length(Code) - Length(Ident) + 1 do
    if GetIdentAt(Code, i) = Ident then
      begin
        Result := i;
        Exit;
      end;
  Result := 0;
end;

function StrCharCount(Str: string; Ch: char): integer;
var
  L: integer;
  i: integer;
begin
  L := Length(Str);
  Result := 0;
  for i := 1 to L do
    if Str[i]=Ch then Inc(Result);
end;

function LastPos(Ch: char; s: string): integer;
begin
  Result := Length(s);
  while Result>0 do
    begin
    if s[Result]=ch then Exit;
    dec(Result);
    end;
end;

function CopyAfter(const SubStr, Str: string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then 
    Result := '' 
  else 
    Result := Copy(Str,_+Length(SubStr),Length(Str));
end;

{$IFDEF VER80}
function Trim(const S: string): string;
var
  I, L: Integer;
begin
  L := Length(S);
  I := 1;
  while (I <= L) and (S[I] <= ' ') do Inc(I);
  if I > L then Result := '' else
  begin
    while S[L] <= ' ' do Dec(L);
    Result := Copy(S, I, L - I + 1);
  end;
end;

function TrimLeft(const S: string): string;
var
  I, L: Integer;
begin
  L := Length(S);
  I := 1;
  while (I <= L) and (S[I] <= ' ') do Inc(I);
  Result := Copy(S, I, Maxint);
end;

function TrimRight(const S: string): string;
var
  I: Integer;
begin
  I := Length(S);
  while (I > 0) and (S[I] <= ' ') do Dec(I);
  Result := Copy(S, 1, I);
end;
{$ENDIF}

function InternalFormatDateTime(ThisString: string; DateTime: TDateTime): string;
var
  DateTimeString: string;
begin
  DateTimeString := CopyBefore(EndDatetimeSubString, CopyAfter(BeginDateTimeSubString, ThisString));
  if DateTimeString <> '' then DateTimeString := FormatDateTime(DateTimeString, DateTime);
  Result := CopyBefore(BeginDateTimeSubString, ThisString) + DateTimeString + CopyAfter(EndDateTimeSubString, ThisString);
end;


function iWildCompareStr(const Mask: string; MaskPos: integer; const Source: string; SourcePos: integer): boolean;
var
  i, j: integer;
begin
  for i:=MaskPos to Length(Mask) do begin
    case Mask[i] of
      '?': if SourcePos <= Length(Source) then inc(SourcePos)
           else begin
             Result := false;
             exit;
           end;
      '*': begin
             Result := true;
             if i = Length(Mask) then exit;
             for j:=SourcePos to Length(Source) do begin
               Result := iWildCompareStr(Mask, i+1, Source, j);
               if Result then exit;
             end;
             if SourcePos <= Length(Source) then exit;
           end;
      else begin
        if (SourcePos <= Length(Source)) and (Source[SourcePos] = Mask[i]) then inc(SourcePos)
        else begin
         Result := false;
         exit;
        end;
      end;
    end;
  end;
  if SourcePos > Length(Source) then Result := true
  else Result := false;
end;

function WildCompareStr(const Mask: string; const Source: string): boolean;
begin
  Result := iWildCompareStr(Mask, 1, Source, 1);
end;

function toalpha(c: char): char;
begin
  if c in ['0'..'9', 'a'..'z', 'A'..'Z', '_'] then Result := c else
  if (AnsiLowerCase(c) = c) and (AnsiUpperCase(c) = c) then Result := '_' else Result := c;
end;

function CopyShortName(s: string): string;
var
  i: integer;
begin
  for i := 1 to length(s) do begin
    s[i] := toalpha(s[i]);
  end;
  Result := s;
end;

{$IFNDEF VER80}
function GetHashValueOfStr(const Str: String): Integer;
begin
  Result := LHashValOfNameSysA(SYS_WIN32, LOCALE_USER_DEFAULT, PChar(Str));
end;
{$ENDIF}
end.











