// $Archive: /H/GERIX/Projects/elReports/elReportsUtils.pas $ $Author: Gerix $ $Date: 10/21/99 12:13p $ $Revision: 5 $ $Workfile: elReportsUtils.pas $

// 
{*******************************************************}
{                                                       }
{                E L E K S   R E P O R T S              }        
{                                                       }
{        Copyright (C) 1998, 1999 Eleks Software        }
{               Created by Andriy Gerasika              }
{                  All rights reserved                  }
{                                                       }
{                 http://eleks.txnet.com                }
{                    eleks@fnmail.com                   }
{                                                       }
{*******************************************************}


unit elReportsUtils;

interface

uses
  ActiveX, elReports_TLB, elReportsEUI_TLB;

function AddField(const Self: IelReportEntities; const Name: WideString): IelReportField; safecall;
function AddCallbackField(const Self: IelReportEntities; const Callback: IelReportCallback; const Prefix: WideString; const Suffix: WideString): IelReportCallbackField; safecall;
function AddBeginRepeater(const Self: IelReportEntities; const Name: WideString): IelReportBeginRepeater; safecall;
function AddEndRepeater(const Self: IelReportEntities; const Name: WideString): IelReportEndRepeater; safecall;
function AddConditionalField(const Self: IelReportEntities; const Conditionals: IelStringList;
                             const IfStr, EndIfStr, ThenStr, ElseStr, ElsIfStr: WideString): IelReportConditionalField; safecall;
function AddDictionaryField(const Self: IelReportEntities; const Dictionary: IelReportDictionary; const Prefix: WideString;
                            const FieldDelimiter: WideString; const BodyDelimiter: WideString; const Suffix: WideString): IelReportDictionaryField; safecall;
function AddInterpreterField(const Self: IelReportEntities; const Dictionary: IelReportDictionary; const Prefix: WideString;
                             const Delimiter: WideString; const Suffix: WideString): IelReportInterpreterField; safecall;
procedure InitializeHtmlUnAligner(Report: IelReport);

function elReportsLibrary: ITypeLib;
function elReportsEUILibrary: ITypeLib;

implementation

function AddField(const Self: IelReportEntities; const Name: WideString): IelReportField;
begin
  Result := CoelReportField.Create;
  Result.Name := Name;
  Self.Add(Result);
end;

function AddCallbackField(const Self: IelReportEntities; const Callback: IelReportCallback; const Prefix: WideString; const Suffix: WideString): IelReportCallbackField;
begin
  Result := CoelReportCallbackField.Create;
  Result.Prefix := Prefix;
  Result.Suffix := Suffix;
  Result.Callback := Callback;
  Self.Add(Result);
end;

function AddBeginRepeater(const Self: IelReportEntities; const Name: WideString): IelReportBeginRepeater;
begin
  Result := CoelReportBeginRepeater.Create;
  Result.Name := Name;
  Self.Add(Result);
end;

function AddEndRepeater(const Self: IelReportEntities; const Name: WideString): IelReportEndRepeater;
begin
  Result := CoelReportEndRepeater.Create;
  Result.Name := Name;
  Self.Add(Result);
end;

function AddConditionalField(const Self: IelReportEntities; const Conditionals: IelStringList;
                                 const IfStr, EndIfStr, ThenStr, ElseStr, ElsIfStr: WideString): IelReportConditionalField; safecall;
begin
  Result := CoelReportConditionalField.Create;
  Result.IfStr := IfStr;
  Result.EndIfStr := EndIfStr;
  Result.ThenStr := ThenStr;
  Result.ElseStr := ElseStr;
  Result.ElsIfStr := ElsIfStr;
  Result.Conditionals := Conditionals;
  Self.Add(Result);
end;

function AddDictionaryField(const Self: IelReportEntities; const Dictionary: IelReportDictionary; const Prefix: WideString;
                                const FieldDelimiter: WideString; const BodyDelimiter: WideString; const Suffix: WideString): IelReportDictionaryField;
begin
  Result := CoelReportDictionaryField.Create;
  Result.Dictionary := Dictionary;
  Result.Prefix := Prefix;
  Result.FieldDelimiter := FieldDelimiter;
  Result.BodyDelimiter := BodyDelimiter;
  Result.Suffix := Suffix;
  Self.Add(Result);
end;

function AddInterpreterField(const Self: IelReportEntities;
  const Dictionary: IelReportDictionary; const Prefix, Delimiter,
  Suffix: WideString): IelReportInterpreterField;
begin
  Result := CoelReportInterpreterField.Create;
  Result.Dictionary := Dictionary;
  Result.Prefix := Prefix;
  Result.Suffix := Suffix;
  Result.Delimiter := Delimiter;
  Self.Add(Result);
end;

procedure InitializeHtmlUnAligner(Report: IelReport);
var
  UnAlignerFlag: IelReportUnAlignerFlag;
  function AddUnAlignerField(const Name, Value: String): IelReportUnAlignerField;
  begin
    Result := CoelReportUnAlignerField.Create;
    Result.Name := Name;
    Result.Value := Value;
    Result.Flag := UnAlignerFlag;
    Report.Entities.Add(Result);
  end;
  function AddUnAlignerFlagField(const Name: String; Increment: Integer): IelReportUnAlignerFlagField;
  begin
    Result := CoelReportUnAlignerFlagField.Create;
    Result.Name := Name;
    Result.Increment := Increment;
    Result.Flag := UnAlignerFlag;
    Result.CaseSensitive := False;
    Report.Entities.Add(Result);
  end;
begin
  UnAlignerFlag := CoelReportUnAlignerFlag.Create;

  AddUnAlignerField('>'#13#10, '>');
  AddUnAlignerField(#13#10, ' ');

  AddUnAlignerFlagField('<pre', -1);
  AddUnAlignerFlagField('</pre>', 1);
  AddUnAlignerFlagField('<script', -1);
  AddUnAlignerFlagField('</script>', 1);
end;

var
  felReportsLibrary: ITypeLib;

function elReportsLibrary: ITypeLib;
begin
  if not Assigned(felReportsLibrary) then begin
    Assert(Succeeded(LoadRegTypeLib(Libid_elReports, 1, 0, 0, felReportsLibrary)));
  end;
  Result := felReportsLibrary;
end;

var
  felReportsEUILibrary: ITypeLib;

function elReportsEUILibrary: ITypeLib;
begin
  if not Assigned(felReportsEUILibrary) then begin
    Assert(Succeeded(LoadRegTypeLib(Libid_elReportsEUI, 1, 0, 0, felReportsEUILibrary)));
  end;
  Result := felReportsEUILibrary;
end;

end.
