// 
{*******************************************************}
{                                                       }
{                E L E K S   R E P O R T S              }        
{                                                       }
{        Copyright (C) 1998, 1999 Eleks Software        }
{               Created by Andriy Gerasika              }
{                  All rights reserved                  }
{                                                       }
{                 http://eleks.txnet.com                }
{                    eleks@fnmail.com                   }
{                                                       }
{*******************************************************}


// $Archive: /H/Gerix/Projects/elReports/elReportsDemoUnit.pas $ $Author: Gerix $ $Date: 11/13/99 1:13p $ $Revision: 16 $ $Workfile: elReportsDemoUnit.pas $

unit elReportsDemoUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ActiveX,
  StdCtrls, Db, DBTables, Buttons, Grids, DBGrids,
  elReports_TLB, elReportsEUI_TLB, elReportsBDE_TLB, elReportsXDO_TLB, elReportsUtils, ComObj, ComServ,
  DBCtrls, ExtCtrls, ComCtrls, elReportsBDEImpl;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    Lesson5: TTabSheet;
    Lesson6: TTabSheet;
    FishSource: TDataSource;
    FishTable: TTable;
    FishTableCategory: TStringField;
    FishTableSpeciesName: TStringField;
    FishTableLengthcm: TFloatField;
    FishTableLength_In: TFloatField;
    FishTableCommon_Name: TStringField;
    FishTableNotes: TMemoField;
    FishTableGraphic: TGraphicField;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel3: TPanel;
    DBMemo1: TDBMemo;
    Panel7: TPanel;
    Panel1: TPanel;
    DBImage1: TDBImage;
    Panel8: TPanel;
    DBLabel1: TDBText;
    Panel4: TPanel;
    DBGrid1: TDBGrid;
    Panel2: TPanel;
    FishReportBtn: TButton;
    Customer: TTable;
    Order: TTable;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    Panel9: TPanel;
    DBGrid2: TDBGrid;
    Panel10: TPanel;
    DBGrid3: TDBGrid;
    Panel11: TPanel;
    CustOrdReportBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Lesson1: TTabSheet;
    Lesson2: TTabSheet;
    Generate1: TButton;
    Label14: TLabel;
    Template1: TMemo;
    Label15: TLabel;
    Document1: TMemo;
    Label18: TLabel;
    Begin2: TEdit;
    Label19: TLabel;
    End2: TEdit;
    Template2: TMemo;
    Generate2: TButton;
    Document2: TMemo;
    Lesson3: TTabSheet;
    Template3: TMemo;
    Document3: TMemo;
    Generate3: TButton;
    Label27: TLabel;
    Prefix3: TEdit;
    Label28: TLabel;
    Suffix3: TEdit;
    Lesson4: TTabSheet;
    Label4: TLabel;
    Name41: TEdit;
    Label5: TLabel;
    Value41: TMemo;
    Label6: TLabel;
    Begin4: TEdit;
    Label8: TLabel;
    End4: TEdit;
    Generate4: TButton;
    Label3: TLabel;
    Name42: TEdit;
    Label10: TLabel;
    Value42: TMemo;
    Label7: TLabel;
    Label11: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label32: TLabel;
    Lesson7: TTabSheet;
    familyList: TListView;
    template7: TMemo;
    ButtonGenerate: TButton;
    document7: TMemo;
    Panel12: TPanel;
    Label22: TLabel;
    Panel13: TPanel;
    Label23: TLabel;
    Label33: TLabel;
    NameValue1: TMemo;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label31: TLabel;
    Label38: TLabel;
    NameValue2: TMemo;
    Label12: TLabel;
    Label13: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Panel14: TPanel;
    Label26: TLabel;
    Panel15: TPanel;
    Label9: TLabel;
    Panel17: TPanel;
    Label21: TLabel;
    Panel16: TPanel;
    Label20: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Panel18: TPanel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Lesson8: TTabSheet;
    Panel19: TPanel;
    Label45: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    Label54: TLabel;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    procedure FishReportBtnClick(Sender: TObject);
    procedure CustOrdReportBtnClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure Generate1Click(Sender: TObject);
    procedure Generate2Click(Sender: TObject);
    procedure Generate3Click(Sender: TObject);
    procedure Generate4Click(Sender: TObject);
    procedure ButtonGenerateClick(Sender: TObject);
  private
    { Private declarations }
  protected
  public
    { Public declarations }
    procedure GenerateReport(ReportName: String);
  end;

  TelReportFormCallback = class(TAutoIntfObject
  , IelReportCallback
  )
  private
    Form: TForm;
  protected
  public
    procedure Generate(const Writer: IelReportWriter; const Value: WideString); safecall;
  end;

var
  Form1: TForm1;

implementation

uses
  Consts;

{$R *.DFM}

function CopyAfter(const SubStr, Str: string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then
    Result := ''
  else
    Result := Copy(Str,_+Length(SubStr),Length(Str));
end;

function CopyBefore(const SubStr,Str:string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then
    Result := Str
  else
    Result := Copy(Str,1,_-1);
end;

var
  WordBasic: OleVariant;

procedure OpenFileInWord(const FileName: String);
var
  WordBasicClsid: TClsid;
  WordBazic: IUnknown;
  _: String;
begin
  if MessageDlg(Format('Do you want file %s to be opened in Word ?',
    [FileName]), mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin
    if VarIsEmpty(WordBasic) then begin
      WordBasicClsid := ProgidToClassid('Word.Basic');
      if not Succeeded(GetActiveObject(WordBasicClsid, nil, WordBazic)) then
        WordBazic := CreateComObject(WordBasicClsid);
      WordBasic := WordBazic as IDispatch;
    end;
    _ := ExpandFileName(FileName);
    WordBasic.FileOpen(_);
    WordBasic.AppShow;
  end;
end;

procedure TForm1.GenerateReport(ReportName: String);
var
  r: IelReport;
  cb: IelReportBDECallback;
begin
  r := CoelRtfReport.Create;
  cb := TelReportBDECallback.Create(elReportsEUILibrary, Iid_IelReportCallback);
  cb.DataSetOwner := Integer(Self);
  AddCallbackField(r.Entities, cb, '$$', '$$');
  SetCurrentDir(ExtractFilePath(ParamStr(0)));
  r.GenerateFile('..\projects\elreports\template\' + ReportName + '.rtf',
                 '..\projects\elreports\document\' + ReportName + '.rtf');
  OpenFileInWord(ExpandFileName('..\projects\elreports\document\' + ReportName + '.rtf'));
end;

procedure TForm1.FishReportBtnClick(Sender: TObject);
begin
  FishTable.Active := False;
  FishTable.Active := True;
  GenerateReport('Fish');
end;

procedure TForm1.CustOrdReportBtnClick(Sender: TObject);
begin
  Order.Active := False;
  Customer.Active := False;
  Customer.Active := True;
  Order.Active := True;
  GenerateReport('Cust')
end;

type
  _TControl_ = class(TControl)
  public
    property Text;
  end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
  if PageControl1.ActivePage = Lesson5 then
    FishTable.Active := True
  else if PageControl1.ActivePage = Lesson6 then begin
    Customer.Active := True;
    Order.Active := True;
  end;
end;

procedure TForm1.Generate1Click(Sender: TObject);
var
  _: IelReport;
  ws1, ws2: WideString;
  i: Integer;
begin
  _ := CoelTextReport.Create;
  for i := 0 to NameValue1.Lines.Count - 1 do begin
    AddField(_.Entities, CopyBefore('=', NameValue1.Lines[i]))
      .Values.Add(CopyAfter('=', NameValue1.Lines[i]));
  end;
  ws1 := Template1.Lines.Text;
  _.GenerateString(ws1, ws2);
  Document1.Lines.Text := ws2;
end;

procedure TForm1.Generate2Click(Sender: TObject);
var
  _: IelReport;
  sl: TStringList;
  ws1, ws2: WideString;
  i: Integer;
  j: Integer; 
begin
  _ := CoelTextReport.Create;
  for i := 0 to NameValue1.Lines.Count - 1 do begin
    with AddField(_.Entities, CopyBefore('=', NameValue2.Lines[i])) do begin
      RepeatedValues := True;
      sl := TStringList.Create;
      try
        sl.CommaText := CopyAfter('=', NameValue2.Lines[i]);
        for j := 0 to sl.Count - 1 do
          Values.Add(sl[j]);
      finally
        sl.Free;
      end;
    end;
  end;
  AddBeginRepeater(_.Entities, Begin2.Text);
  AddEndRepeater(_.Entities, End2.Text);
  ws1 := Template2.Lines.Text;
  _.GenerateString(ws1, ws2);
  Document2.Lines.Text := ws2;
end;

procedure TForm1.Generate3Click(Sender: TObject);
var
  _: IelReport;
  ws1, ws2: WideString;
  cfc: TelReportFormCallback;
  unk: IUnknown;
begin
  _ := CoelTextReport.Create;
  cfc := TelReportFormCallback.Create(elReportsEUILibrary, Iid_IelReportCallback);
  cfc.Form := Self;
  AddCallbackField(_.Entities, cfc, Prefix3.Text, Suffix3.Text);
  ws1 := Template3.Lines.Text;
  _.GenerateString(ws1, ws2);
  Document3.Lines.Text := ws2;
end;

procedure TForm1.Generate4Click(Sender: TObject);
var
  _: IelReport;
  i: Integer;
  ReportName: String;
begin
  _ := CoelRtfReport.Create;
  with AddField(_.Entities, Name41.Text) do begin
    RepeatedValues := True;
    for i := 0 to Value41.Lines.Count - 1 do
      Values.Add(Value41.Lines[i]);
  end;
  with AddField(_.Entities, Name42.Text) do begin
    RepeatedValues := True;
    for i := 0 to Value42.Lines.Count - 1 do
      Values.Add(Value42.Lines[i]);
  end;
  AddBeginRepeater(_.Entities, Begin4.Text);
  AddEndRepeater(_.Entities, End4.Text);

  ReportName := 'marry';
  _.GenerateFile('..\projects\elreports\template\' + ReportName + '.rtf',
                 '..\projects\elreports\document\' + ReportName + '.rtf');
  OpenFileInWord(ExpandFileName('..\projects\elreports\document\' + ReportName + '.rtf'));
end;

procedure TelReportFormCallback.Generate(const Writer: IelReportWriter; const Value: WideString);
var
  C: TComponent;
begin
  C := Form.FindComponent(Value);
  if C is TControl then
    Writer.WriteString(_TControl_(C).Text);
end;

procedure TForm1.ButtonGenerateClick(Sender: TObject);
var
  r: IelReport;
  cb: IelReportXDOCallback;
  ParentRecordSet,
  ChildrenRecordSet: IelRecordSet;
  ParentRecord,
  ChildrenRecord: IelRecord;
  ParentField,
  ChildrenField: IelField;
  c: IelReportCollector;
  s1, s2: WideString;
  _: TStringList;
  i: Integer;
  j: Integer;
begin
  r := CoelTextReport.Create;
  ParentRecordSet := CoelRecordSet.Create;

  for i := 0 to familyList.Items.Count - 1 do begin
    ParentRecord := CoelRecord.Create;
    ParentRecordSet.AddRecord(ParentRecord);

    ParentField := CoelField.Create;
    ParentRecord.AddField(ParentField);
    ParentField.Name := 'father';
    ParentField.Value := familyList.Items[i].Caption; 

    ParentField := CoelField.Create;
    ParentRecord.AddField(ParentField);
    ParentField.Name := 'mother';
    ParentField.Value := familyList.Items[i].SubItems[0]; 

    ParentField := CoelField.Create;
    ParentRecord.AddField(ParentField);
    ParentField.Name := 'children';
    ChildrenRecordSet := CoelRecordSet.Create;
    ParentField.Recordset := ChildrenRecordSet;

    if familyList.Items[i].SubItems.Count = 1 then
      Continue;

    _ := TStringList.Create;
    _.CommaText := familyList.Items[i].SubItems[1];
    for j := 0 to _.Count - 1 do begin
      ChildrenRecord := CoelRecord.Create;
      ChildrenRecordSet.AddRecord(ChildrenRecord);

      ChildrenField := CoelField.Create;
      ChildrenRecord.AddField(ChildrenField);
      ChildrenField.Name := 'no';
      ChildrenField.Value := IntToStr(j);

      ChildrenField := CoelField.Create;
      ChildrenRecord.AddField(ChildrenField);
      ChildrenField.Name := 'name';
      ChildrenField.Value := _[j];
    end;
  end;

  cb := CoelReportXDOCallback.Create;
  cb.AddRecordSet('family', ParentRecordSet);
  AddCallbackField(r.Entities, cb, '$$', '$$');

  r.Collector := CoelReportCollector.Create;

  s1 := template7.Lines.Text;
  r.GenerateString(s1, s2);
  document7.Lines.Text := s2;
end;

end.


