unit elReportsBDEImpl;

interface

uses
  SysUtils, ComObj, ComServ, ActiveX, elReportsBDE_TLB, elReportsEUI_TLB, elReports_TLB,
  StdVcl, Classes, DB, Graphics;

type
  TelReportBDECallback = class(TAutoIntfObject///TAutoObject
  , IelReportCallback
  , IelReportBDECallback
  )
  private
    fDataSetOwner: TComponent;
  protected
    function Get_DataSetOwner: Integer; safecall;
    procedure Set_DataSetOwner(Value: Integer); safecall;
  public
    procedure Generate(const Writer: IelReportWriter; const Value: WideString); safecall;
    property DataSetOwner: TComponent read fDataSetOwner write fDataSetOwner;
  end;

///var
///  elReportBDECallbackFactory: TAutoObjectFactory;

implementation

{
uses
  StrUtilz;
}
function CopyAfter(const SubStr, Str: string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then
    Result := '' 
  else 
    Result := Copy(Str,_+Length(SubStr),Length(Str));
end;

function CopyBefore(const SubStr,Str:string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then 
    Result := Str 
  else
    Result := Copy(Str,1,_-1);
end;

{ TelReportBDECallback }

procedure TelReportBDECallback.Generate(
  const Writer: IelReportWriter; const Value: WideString);
var
  TableName,
  FieldName: String;
  Component: TComponent;
  Table: TDataSet;
  Field: TField;
  MemoField: TMemoField;
  GraphicField: TGraphicField;
  Picture: TPicture;
  Bitmap: TBitmap;
  Metafile: TMetafile;
  MetafileCanvas: TMetafileCanvas;
  Stream: TMemoryStream;
  i: Integer;
begin
  TableName := Trim(CopyBefore('.', Value));
  Component := nil;
  if Assigned(DataSetOwner) then
    Component := DataSetOwner.FindComponent(TableName);

  if Component is TDataSet then begin
    Table := TDataSet(Component);
    Table.Active := True;
    FieldName := Trim(CopyAfter('.', Value));
    if CompareText(FieldName, '#BEGIN#') = 0 then
      Writer.BeginRepeater(TableName)
    else if CompareText(FieldName, '#END#') = 0 then begin
      Table.Next;
      Writer.RepeatNeeded := Writer.RepeatNeeded or not Table.EOF;
      Writer.EndRepeater(TableName);
    end
    else begin
      Field := Table.FieldByName(FieldName);
      if Assigned(Field) then begin
        case Field.DataType of
        ftMemo: begin
          MemoField := Field as TMemoField;
          Writer.WriteString(MemoField.AsString);
        end;
        ftGraphic: begin
          GraphicField := Field as TGraphicField;
          Picture := TPicture.Create;
          try
            Picture.Assign(GraphicField);
            Bitmap := Picture.Bitmap;
            Metafile := TMetafile.Create;
            try
              Metafile.Width := Bitmap.Width;
              Metafile.Height := Bitmap.Height;
              MetafileCanvas := TMetafileCanvas.Create(Metafile, 0);
              try
                MetafileCanvas.Draw(0, 0, Bitmap);
              finally
                MetafileCanvas.Free;
              end;
              Stream := TMemoryStream.Create;
              try
                Metafile.SaveToStream(Stream);
                Writer.WriteImage(TStreamAdapter.Create(Stream), Metafile.Width, Metafile.Height);
              finally
                Stream.Free;
              end;
            finally
              Metafile.Free;
            end;
          finally
            Picture.Free;
          end;
        end
        else
          Writer.WriteString(Field.DisplayText);
        end;
      end;
    end;
  end;
end;

function TelReportBDECallback.Get_DataSetOwner: Integer;
begin
  Result := Integer(fDataSetOwner);
end;

procedure TelReportBDECallback.Set_DataSetOwner(Value: Integer);
begin
  if Value = 0 then
    fDataSetOwner := nil
  else if TObject(Value) is TComponent then
    fDataSetOwner := TComponent(Value);
end;

initialization
///  elReportBDECallbackFactory := TAutoObjectFactory.Create(ComServer, TelReportBDECallback, Class_elReportBDECallback,
///    ciMultiInstance, tmApartment);

end.
