// $Archive: /H/Gerix/Projects/elReports/elReportsADOImpl.pas $ $Author: Gerix $ $Date: 10/21/99 12:13p $ $Revision: 9 $ $Workfile: elReportsADOImpl.pas $

// 
{*******************************************************}
{                                                       }
{                E L E K S   R E P O R T S              }        
{                                                       }
{        Copyright (C) 1998, 1999 Eleks Software        }
{               Created by Andriy Gerasika              }
{                  All rights reserved                  }
{                                                       }
{                 http://eleks.txnet.com                }
{                    eleks@fnmail.com                   }
{                                                       }
{*******************************************************}


unit elReportsADOImpl;

interface

uses
  SysUtils, ComObj, ComServ, ActiveX, Classes, ADODB_TLB, DERuntimeObjects_TLB, elReportsADO_TLB, elReportsEUI_TLB, elReports_TLB;

var
  elReportADOCallbackFactory: TAutoObjectFactory;

procedure Register(ComServer: TComServer);
procedure Unregister(ComServer: TComServer);

implementation

type
  IRecordsets = Recordsets;
  IRecordset = Recordset;
  IFields = Fields;
  IField = Field;

  TelReportADOCallback = class(TAutoObject
  , IelReportCallback
  , IelReportADOCallback
  )
  private
    fRecordsetCache: TStringList;
    iRecordsetCache: TInterfaceList;
  protected
    procedure Generate(const Writer: IelReportWriter; const Value: WideString); safecall;
    procedure AddRecordset(const Name: WideString; const Value: Recordset); safecall;
    procedure AddRecordsets(const Value: DataEnvironment); safecall;
  public
    procedure AfterConstruction; override;
    procedure BeforeDestruction; override;
  end;

{
uses
  StrUtilz;

}
function CopyAfter(const SubStr, Str: string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then
    Result := ''
  else
    Result := Copy(Str,_+Length(SubStr),Length(Str));
end;

function CopyBefore(const SubStr,Str:string): string;
var
  _: Integer;
begin
  _ := Pos(SubStr,Str);
  if _=0 then
    Result := Str
  else
    Result := Copy(Str,1,_-1);
end;

{ TelReportCalculatedADOFieldCallback }

procedure TelReportADOCallback.Generate(const Writer: IelReportWriter; const Value: WideString);
var
  PrefixValue,
  SuffixValue,
  TableName,
  FieldName: String;
  Recordset: IRecordset;
  Fields: IFields;
  Field: IField;
  RetVal: WideString;
  _: OleVariant;
  i: Integer;
begin
  SuffixValue := Value;

  repeat
    TableName := Trim(CopyBefore('.', SuffixValue));
    SuffixValue := Trim(CopyAfter('.', SuffixValue));
    if PrefixValue = '' then
      PrefixValue := TableName
    else
      PrefixValue := PrefixValue + '.' + TableName;
    i := fRecordsetCache.IndexOf(PrefixValue);
    if i <> -1 then
      Recordset := iRecordsetCache[i] as IRecordset
    else begin
      _ := TableName;
      if Assigned(Fields) then begin
        try
          Field := Fields.Item[_];
          Recordset := IDispatch(Field.Value) as IRecordset;
        except
          on _: EOleException do begin
            _.Message := _.Message + Format(^m'[elReports: Field Recordset is %s]', [PrefixValue]);
            raise;
          end;
        end;
      end
      else begin
{        if Assigned(DataEnvironment) then
          Recordsets := DataEnvironment.Recordsets; }
{        try
          Recordset := Recordsets.Item[_];
        except
          on _: EOleException do begin
            _.Message := _.Message + Format(^m'[elReports: Recordset is %s]', [TableName]);
            raise;
          end;
        end; }
        Assert(False, 'Recordset ' + _ + ' not found');
      end;
      fRecordsetCache.Add(PrefixValue);
      iRecordsetCache.Add(Recordset);
    end;
    Fields := Recordset.Fields;
  until Pos('.', SuffixValue) = 0;

  FieldName := SuffixValue;
  if CompareText(FieldName, '#BEGIN#') = 0 then
    Writer.BeginRepeater(PrefixValue)
  else if CompareText(FieldName, '#END#') = 0 then begin
    if not Recordset.EOF then
      Recordset.MoveNext;
    if Recordset.EOF then begin
      i := fRecordsetCache.IndexOf(PrefixValue);
      Assert(i <> -1);
      if not Assigned(fRecordsetCache.Objects[i]) then begin
        fRecordsetCache.Delete(i);
        iRecordsetCache.Delete(i);
      end;
    end;
    Writer.RepeatNeeded := Writer.RepeatNeeded or not Recordset.EOF;
    Writer.EndRepeater(PrefixValue);
  end
  else if not Recordset.EOF then begin
    _ := FieldName;
    try
      Field := Recordset.Fields.Item[_];
    except
      on _: EOleException do begin
        _.Message := _.Message + Format(^m'[elReports: Field is %s.%s]', [PrefixValue, FieldName]);
        raise;
      end;
    end;
    _ := Field.Value;
    if VarIsNull(_) then
      RetVal := ''
    else
      RetVal := _;
    Writer.WriteString(RetVal);
  end;
end;

procedure TelReportADOCallback.AfterConstruction;
begin
  inherited;
  fRecordsetCache := TStringList.Create;
  iRecordsetCache := TInterfaceList.Create;
end;

procedure TelReportADOCallback.BeforeDestruction;
begin
  fRecordsetCache.Free;
  iRecordsetCache.Free;
  inherited;
end;

procedure TelReportADOCallback.AddRecordset(
  const Name: WideString; const Value: Recordset);
begin
  fRecordsetCache.AddObject(Name, Pointer(-1));
  iRecordsetCache.Add(Value);
end;

procedure TelReportADOCallback.AddRecordsets(
  const Value: DataEnvironment);
var
  Enum: IEnumVariant;
  _: OleVariant;
  i: Cardinal;
begin
  Enum := Value.Recordsets._NewEnum as IEnumVariant;
  OleCheck(Enum.Reset);
  while Succeeded(Enum.Next(1, _, {$IFDEF VER120}@{$ENDIF}i)) and (i = 1) do begin
    AddRecordset(_, Value.Recordsets.Item[_]);
  end;
end;

procedure Register(ComServer: TComServer);
begin
  elReportADOCallbackFactory := TAutoObjectFactory.Create(ComServer, TelReportADOCallback, Class_elReportADOCallback,
    ciMultiInstance, tmApartment);
end;

procedure Unregister(ComServer: TComServer);
begin
end;

initialization
{$IFNDEF elReports777}
  Register(ComServer);
{$ENDIF}

end.
