unit EffectSample;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, MyEffectControl, Spin, ExtCtrls, Grids,
  Outline, DirOutln, EffectPages, FileCtrl, Mask, Calendar;

type
  TForm1 = class(TEffectForm)
    Next: TBitBtn;
    Prev: TBitBtn;
    MyEffectControl1: TMyEffectControl;
    BitBtn6: TBitBtn;
    ComboBox1: TComboBox;
    Label18: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    EffectPageControl1: TEffectPageControl;
    EffectPage1: TEffectPage;
    EffectPage2: TEffectPage;
    Button1: TButton;
    Memo1: TMemo;
    Edit1: TEdit;
    ListBox1: TListBox;
    Label19: TLabel;
    RichEdit1: TRichEdit;
    ProgressBar1: TProgressBar;
    TrackBar1: TTrackBar;
    ListView1: TListView;
    FileListBox1: TFileListBox;
    EffectPage3: TEffectPage;
    RadioGroup1: TRadioGroup;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    RadioButton1: TRadioButton;
    MaskEdit1: TMaskEdit;
    StaticText1: TStaticText;
    Calendar1: TCalendar;
    Redraw: TBitBtn;
    Shape1: TShape;
    Image1: TImage;
    Edit2: TEdit;
    UpDown1: TUpDown;
    Edit3: TEdit;
    UpDown2: TUpDown;
    Edit4: TEdit;
    UpDown3: TUpDown;
    Edit5: TEdit;
    UpDown4: TUpDown;
    Edit6: TEdit;
    UpDown5: TUpDown;
    Edit7: TEdit;
    UpDown6: TUpDown;
    procedure FormCreate(Sender: TObject);
    procedure RedrawClick(Sender: TObject);
    procedure NextClick(Sender: TObject);
    procedure PrevClick(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormPaint(Sender: TObject);
    procedure Edit8KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    StartColor, EndColor: TColor;
    procedure SetComboBoxItem;
  end;

var
  Form1: TForm1;

implementation

uses MyImgEffectUnit;

{$R *.DFM}

procedure TForm1.SetComboBoxItem;
begin
 ComboBox1.Items.Clear;
 if EffectPageControl1.ActivePage = EffectPage1 then begin
      ComboBox1.Items.Add('Memo1');
      ComboBox1.Items.Add('Button1');
      ComboBox1.Items.Add('Edit1');
      ComboBox1.Items.Add('Calendar1');
      ComboBox1.Items.Add('ListBox1');
 end else if EffectPageControl1.ActivePage = EffectPage2 then begin
      ComboBox1.Items.Add('RichEdit1');
      ComboBox1.Items.Add('ProgressBar1');
      ComboBox1.Items.Add('TrackBar1');
      ComboBox1.Items.Add('ListView1');
      ComboBox1.Items.Add('FileListBox1');
 end else if EffectPageControl1.ActivePage = EffectPage3 then begin
      ComboBox1.Items.Add('RadioGroup1');
      ComboBox1.Items.Add('GroupBox1');
      ComboBox1.Items.Add('CheckBox1');
      ComboBox1.Items.Add('RadioButton1');
      ComboBox1.Items.Add('MaskEdit1');
      ComboBox1.Items.Add('StaticText1');
      ComboBox1.Items.Add('Shape1');
      ComboBox1.Items.Add('Image1');
 end;
 ComboBox1.ItemIndex := 0;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 StartColor := clSilver;
 EndColor := clBlue;

 Randomize;

 Self.Effect := -1;
 Self.DrawingUnit := 2;
 Self.SPEED := 2000;
 self.RepaintGraphic := False;
 Self.RepaintControl := False;

 EffectPageControl1.ActivePage := EffectPage1;
 SetComboBoxItem;

 UpDown1.Min := Low(TImgEffectRange);
 UpDown4.Min := Low(TImgEffectRange);
 UpDown2.Min := 0;
 UpDown5.Min := 0;
 UpDown3.Min := Low(TDrawingUnitRange);
 UpDown6.Min := Low(TDrawingUnitRange);

 UpDown1.Max := High(TImgEffectRange);
 UpDown4.Max := High(TImgEffectRange);
 UpDown2.Max := High(SmallInt);
 UpDown5.Max := High(SmallInt);
 UpDown3.Max := High(TDrawingUnitRange);
 UpDown6.Max := High(TDrawingUnitRange);
end;


procedure TForm1.RedrawClick(Sender: TObject);
begin
  with MyEffectControl1 do begin
    Effect := UpDown1.Position;
    Speed := UpDown2.Position;
    DrawingUnit := UpDown3.Position;

    Control := TWinControl(Self.FindComponent(ComboBox1.Items[ComboBox1.ItemIndex]));
    if Control = nil then begin
        ShowMessage('Cannot find selected control !!');
        Exit;
    end;

    if Control.Visible then Control.Visible := False;

    Show;
  end;
end;

procedure TForm1.NextClick(Sender: TObject);
begin
  if EffectPageControl1.ActivePage = EffectPage1 then begin
                     EffectPage2.Effect := UpDown4.Position;
                     EffectPage2.Speed := UpDown5.Position;
                     EffectPage2.DrawingUnit := UpDown6.Position;
                     EffectPageControl1.ActivePage := EffectPage2;
                     Next.Enabled := True;
                     Prev.Enabled := True;
  end else if EffectPageControl1.ActivePage = EffectPage2 then begin
                     EffectPage3.Effect := UpDown4.Position;
                     EffectPage3.Speed := UpDown5.Position;
                     EffectPage3.DrawingUnit := UpDown6.Position;
                     EffectPageControl1.ActivePage := EffectPage3;
                     Next.Enabled := False;
                     Prev.Enabled := True;
  end;

  SetComboBoxItem;
end;


procedure TForm1.PrevClick(Sender: TObject);
begin
  if EffectPageControl1.ActivePage = EffectPage3 then begin
                     EffectPage2.Effect := UpDown4.Position;
                     EffectPage2.Speed := UpDown5.Position;
                     EffectPage2.DrawingUnit := UpDown6.Position;
                     EffectPageControl1.ActivePage := EffectPage2;
                     Next.Enabled := True;
                     Prev.Enabled := True;
  end else if EffectPageControl1.ActivePage = EffectPage2 then begin
                     EffectPage1.Effect := UpDown4.Position;
                     EffectPage1.Speed := UpDown5.Position;
                     EffectPage1.DrawingUnit := UpDown6.Position;
                     EffectPageControl1.ActivePage := EffectPage1;
                     Next.Enabled := True;
                     Prev.Enabled := False;
  end;

  SetComboBoxItem;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     ReleaseCapture;
     Perform(WM_SYSCOMMAND, $F012, 0);
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  RGBFrom: array[0..2] of Byte;
  RGBDiff: array[0..2] of integer;
  DC: HDC;
  CPH: HPEN;
  I: Integer;
  R, G, B: Byte;
begin
  RGBFrom[0] := GetRValue(ColorToRGB(StartColor));
  RGBFrom[1] := GetGValue(ColorToRGB(StartColor));
  RGBFrom[2] := GetBValue(ColorToRGB(StartColor));

  RGBDiff[0] := GetRValue(ColorToRGB(EndColor)) - RGBFrom[0];
  RGBDiff[1] := GetGValue(ColorToRGB(EndColor)) - RGBFrom[1];
  RGBDiff[2] := GetBValue(ColorToRGB(EndColor)) - RGBFrom[2];

  DC  := Canvas.Handle;
  CPH := Canvas.Pen.Handle;

  for I := 0 to Height-1 do
  begin
    R := RGBFrom[0] + MulDiv(I, RGBDiff[0], Height + 1);
    G := RGBFrom[1] + MulDiv(I, RGBDiff[1], Height + 1);
    B := RGBFrom[2] + MulDiv(I, RGBDiff[2], Height + 1);

    SelectObject(DC, CreatePen(PS_SOLID, 1, RGB(R, G, B)));

    MoveToEx(DC, 0, I, nil);
    LineTo(DC, Width, I);

    DeleteObject(SelectObject(DC, CPH));
  end;
end;


procedure TForm1.BitBtn6Click(Sender: TObject);
begin
 Close;
end;


procedure TForm1.Edit8KeyPress(Sender: TObject; var Key: Char);
begin
 if not (Key in ['0'..'9', '-', #8]) then
    Key := #0;
end;

end.
