unit Unit8;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, dsdialog, ComCtrls, FileCtrl, Gauges, ExtCtrls;

type

  TFileThread = class(TThread)
   private
    FileSize:comp;
    NumFiles:integer;
    StartDir:string;
    SizeLabel:TLabel;
    NumLabel:TLabel;
    procedure UpdateLabels;
   public 
    procedure Execute; override;
  end;

  TBrowseForFolderForm = class(TForm)
    FormFolderDialog: TFormFolderDialog;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Gauge1: TGauge;
    Bevel1: TBevel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    procedure FormFolderDialogChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
    FileThread:TFileThread;
  public
    { Public declarations }
  end;

var
  BrowseForFolderForm: TBrowseForFolderForm;

implementation

{$R *.DFM}

procedure TFileThread.UpdateLabels;
begin
 if SizeLabel <> nil then begin
   if FileSize < 10*1024                    //< 10 kB
    then SizeLabel.Caption:=FloatToStrF(FileSize,ffNumber,18,0)+' B'
   else if FileSize < 10*integer(1024)*1024 //< 10 Mb
   then SizeLabel.Caption:=FloatToStrF(FileSize/1024,ffNumber,18,0)+' kB'
   else SizeLabel.Caption:=FloatToStrF(FileSize/(1024*1024),ffNumber,18,0)+' MB'
 end;
 if NumLabel <> nil then NumLabel.Caption:=FloatToStrF(NumFiles,ffNumber,18,0);
end;

procedure TFileThread.Execute;

 procedure DoExecuteAt(Dir:string);
 var d:string;
     Found:integer;
     Dirs:TStringList;
     i:integer;
     SearchRec:TSearchRec;
 begin
  d:=Dir;
  Dirs:=TStringLIst.Create;
  try
  if d[length(d)] <> '\' then d:=d+'\';
  Found := FindFirst(d+'*.*', faAnyFile, SearchRec);
  if Found=0 then begin
   while Found = 0 do
    begin
      if (SearchRec.Name <>'.') and (SearchRec.Name <> '..') then begin
       FileSize:=FileSize+SearchRec.Size;
       inc(NumFiles);
       if (SearchRec.Attr and faDirectory) <> 0 then Dirs.Add(d+SearchRec.Name);
      end;
      Found := FindNext(SearchRec);
    end;
   FindClose(SearchRec);
  end;
  if not Terminated then begin
    Synchronize(UpdateLabels);
    for i:=0 to Dirs.Count-1 do DoExecuteAt(Dirs[i]);
  end;
  finally
   Dirs.Destroy;
  end;
 end;

begin
 FileSize:=0;
 NumFiles:=0;
 DoExecuteAt(StartDir);
end;

procedure TBrowseForFolderForm.FormFolderDialogChange(Sender: TObject);
var Dir:string;
    lpSectorsPerCluster,
    lpBytesPerSector,
    lpNumberOfFreeClusters,
    lpTotalNumberOfClusters:DWORD;
    lpVolumeNameBuffer:string;
    lpVolumeSerialNumber,
    lpMaximumComponentLength,
    lpFileSystemFlags:DWORD;
    lpFileSystemNameBuffer:string;
    r1,r2:longbool;
begin
 Dir:=FormFolderDialog.Directory;

 if FileThread <> nil then begin
  FileThread.Terminate;
  {FileThread.WaitFor;}
  FileThread.Destroy;
 end;
 FileThread:=TFileThread.Create(true);
 FileThread.SizeLabel:=Label17;
 FileThread.NumLabel:=Label16;
 FileThread.StartDir:=Dir;
 FileThread.Resume;

 Label18.Caption:='Folder: '+Dir;
 r1:=GetDiskFreeSpace(PChar(Dir),lpSectorsPerCluster,lpBytesPerSector,
                     lpNumberOfFreeClusters,lpTotalNumberOfClusters);
 SetLength(lpVolumeNameBuffer,256);
 SetLength(lpFileSystemNameBuffer,256);
 r2:=GetVolumeInformation(PChar(Dir),PChar(lpVolumeNameBuffer),256,@lpVolumeSerialNumber,
                          lpMaximumComponentLength,lpFileSystemFlags,
                          PChar(lpFileSystemNameBuffer),256);
 SetLength(lpVolumeNameBuffer,length(PChar(lpVolumeNameBuffer)));
 SetLength(lpFileSystemNameBuffer,length(PChar(lpFileSystemNameBuffer)));
 if r1 and r2 then begin
   Label1.Caption:='Drive:  '+Dir;
   Label2.Caption:='Sectors per cluster: '+IntToStr(lpSectorsPerCluster);
   Label3.Caption:='Bytes per sector: '+IntToStr(lpBytesPerSector);
   Label4.Caption:='Number of free clusters: '+IntToStr(lpNumberOfFreeClusters);
   Label5.Caption:='Total number of clusters: '+IntToStr(lpTotalNumberOfClusters);
   Gauge1.Progress:=trunc(100*(lpTotalNumberOfClusters-lpNumberOfFreeClusters)/
                              lpTotalNumberOfClusters);
   Label6.Caption:='Volume name: '+lpVolumeNameBuffer;
   Label7.Caption:='Volume serial number: '+IntToStr(lpVolumeSerialNumber);
   Label8.Caption:='Max filename length: '+IntToStr(lpMaximumComponentLength);
   Label9.Caption:='File system: '+lpFileSystemNameBuffer;
   if (lpFileSystemFlags and FS_CASE_IS_PRESERVED) <> 0
       then Label10.Caption:='Filename case preserved: '+'Yes'
       else Label10.Caption:='Filename case preserved: '+'No';
   if (lpFileSystemFlags and FS_CASE_SENSITIVE) <> 0
       then Label11.Caption:='Filename case sensitive: '+'Yes'
       else Label11.Caption:='Filename case sensitive: '+'No';
   if (lpFileSystemFlags and FS_FILE_COMPRESSION) <> 0
       then Label12.Caption:='File compession supported: '+'Yes'
       else Label12.Caption:='File compession supported: '+'No';
   if (lpFileSystemFlags and FS_VOL_IS_COMPRESSED) <> 0
       then Label13.Caption:='Volume compressed: '+'Yes'
       else Label13.Caption:='Volume compressed: '+'No';
 end;
end;

procedure TBrowseForFolderForm.FormDestroy(Sender: TObject);
begin
 if FileThread <> nil then FileThread.Destroy;
end;

procedure TBrowseForFolderForm.FormHide(Sender: TObject);
begin
 if FileThread <> nil then begin
  FileThread.Terminate;
  FileThread.Destroy;
  FileThread:=nil;
 end;
end;

end.
