unit Unit5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dsdialog, StdCtrls, ExtCtrls, ComCtrls;

type
  TPageSetupForm = class(TForm)
    PageSetupDialog: TFormPageSetupDialog;
    Image1: TImage;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    PrintDateTime: TCheckBox;
    Bevel3: TBevel;
    PrintFileName: TCheckBox;
    CenterImage: TCheckBox;
    PrintPageNumber: TCheckBox;
    function PageSetupDialogPaintPage(Sender: TObject;
      PaintWhat: TPSPaintWhat; Canvas: TCanvas; Rect: TRect): Boolean;
    procedure CenterImageClick(Sender: TObject);
    procedure PageSetupDialogPrinter(Sender: TObject;
      var ShowPrinters: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PageSetupForm: TPageSetupForm;

implementation

uses RichEdit;

{$R *.DFM}

procedure SplatTextToDC ( hRTFWnd :HWND;
                         hDC : HDC;
                        prcDrawTo:TRect;
                        prcPage:TRect;
                        bPrinterDC :boolean);
var fr:TFormatRange;
begin
 fr.hDC:=hDC;
 fr.hdcTarget:=hDC;
 fr.rc:=prcDrawTo;
 fr.rcPage:=prcPage;
 fr.chrg.cpMin := 0;
 fr.chrg.cpMax := -1;
 SendMessage ( hRTFWnd, EM_FORMATRANGE, integer(TRUE), integer(@fr) );
 SendMessage ( hRTFWnd, EM_FORMATRANGE, integer(FALSE), 0 );
end;


function TPageSetupForm.PageSetupDialogPaintPage(Sender: TObject;
  PaintWhat: TPSPaintWhat; Canvas: TCanvas; Rect: TRect): Boolean;
var R:TRect;
    w,h,x,y:integer;
    s:single;
    //Bitmap:TBitmap;
begin
  Result := FALSE;
  case PaintWhat of
    // The entire paper.
    pwMargins,pwFullPage,pwEnvStamp:
      begin
        Canvas.Brush.Color := clWhite;
        Canvas.Pen.Color := clWhite;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;
    pwMinimumMargins:
      begin
        Canvas.Brush.Color := clWhite;
        Canvas.Pen.Color := clBlack;
        Canvas.FillRect(Rect);
        Canvas.Font.Color:=clBlack;
        Canvas.Font.Name:='Small Fonts';
        Canvas.Font.Height:=round((Rect.Bottom-Rect.Top) / 40)+1;
        if PrintFileName.Checked then
          Canvas.TextOut(2*Canvas.Font.Height,2*Canvas.Font.Height,'c:\somedirectory\filename.txt');
        if PrintDateTime.Checked then
          Canvas.TextOut(2*Canvas.Font.Height,Rect.Bottom-3*Canvas.Font.Height,'01/01/99 12:00:00');
        if PrintPageNumber.Checked then
          Canvas.TextOut(Rect.Right-8*Canvas.Font.Height,Rect.Bottom-3*Canvas.Font.Height,'Page XXX');
      end;
    // Draw the sample page text area
    pwGreekText:
      begin
        Canvas.Pen.Color := clWhite;
        Canvas.Brush.Color := clWhite;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);

         if ((Rect.Right-Rect.Left)/Image1.Picture.Width) < ((Rect.Bottom-Rect.Top)/Image1.Picture.Bitmap.Height) then
              s:=(Rect.Right-Rect.Left)/Image1.Picture.Bitmap.Width else
              s:=(Rect.Bottom-Rect.Top)/Image1.Picture.Bitmap.Height;
         if s=0 then Exit;
         w:=round(s*Image1.Picture.Bitmap.Width);
         h:=round(s*Image1.Picture.Bitmap.Height);
         if CenterImage.Checked then begin
           x:=Rect.Left+2+((Rect.Right-Rect.Left)-w-4) div 2;
           y:=Rect.Top+2+((Rect.Bottom-Rect.Top)-h-4) div 2;
         end else begin
           x:=Rect.Left;
           y:=Rect.Top;
         end;
         R:=Classes.Rect(x,y,x+w,y+h);
         Canvas.StretchDraw(R,Image1.Picture.Bitmap);
         Canvas.Pen.Color := clRed;
         Canvas.Pen.Style := psDot;
         Canvas.Brush.Style := bsClear;
         with Rect do
           Canvas.Rectangle(Left, Top, Right, Bottom);
      end;
  end;

end;

procedure TPageSetupForm.CenterImageClick(Sender: TObject);
begin
 PageSetupDialog.RedrawPage;
end;


procedure TPageSetupForm.PageSetupDialogPrinter(Sender: TObject;
  var ShowPrinters: Boolean);
begin
 ShowPrinters:=MessageDlg('Do you really want to see the printers?'#13#10+
                          '           Just kidding...' ,
                          mtConfirmation,[mbYes, mbNo],0)=mrYes;
end;


end.
