unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, dsdialog, Grids,extctrls, ComCtrls;

type
  TFontForm = class(TForm)
    StringGrid1: TStringGrid;
    FontDialog: TFormFontDialog;
    Label1: TLabel;
    Bevel1: TBevel;
    RichEdit: TRichEdit;
    Label2: TLabel;
    procedure FontDialogApply(Sender: TObject; Wnd: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FontDialogFontChange(Sender: TObject);
    procedure FontDialogShow(Sender: TObject);
    procedure StringGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid1DblClick(Sender: TObject);
    procedure RichEditSelectionChange(Sender: TObject);
  private
    { Private declarations }
    Panel:TPanel;
  public
    { Public declarations }
  end;

var
  FontForm: TFontForm;

implementation

{$R *.DFM}

procedure TFontForm.FontDialogApply(Sender: TObject; Wnd: Integer);
begin
  StringGrid1.Font.Assign(TFormFontDialog(Sender).Font);
end;

procedure TFontForm.FormCreate(Sender: TObject);
var i,j:integer;
begin
 for i:=0 to 15 do
  for j:=0 to 15 do StringGrid1.Cells[i,j]:=char(j*15+i);
 Panel:=nil;
end;

procedure TFontForm.FontDialogFontChange(Sender: TObject);
begin
 StringGrid1.Font.Assign(TFormFontDialog(Sender).Font);
 RichEdit.SelAttributes.Assign(TFormFontDialog(Sender).Font);
end;

procedure TFontForm.FontDialogShow(Sender: TObject);
begin
 FontDialog.Font:=StringGrid1.Font;
end;

procedure TFontForm.StringGrid1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var R:TRect;
    S:TSize;
    CC,RR,w,h:integer;
begin
 with StringGrid1 do begin
  if Panel<>nil then Panel.Destroy;
  Panel:=TPanel.Create(Self);
  MouseToCell(X,Y,CC,RR);
  R:=CellRect(Col,Row);
  Panel.Font.Assign(StringGrid1.Font);
  w:=(R.Right-R.Left) div 2;
  h:=(R.Bottom-R.Top) div 2;
  Panel.BoundsRect:=Rect(R.Left+Left-w,R.Top+Top-h,R.Right+Left+w,R.Bottom+Top+h);
  Panel.Caption:=Cells[CC,RR];
  if Panel.Caption='&' then Panel.Caption:=Panel.Caption+'&'; 
  Windows.GetTextExtentPoint32(StringGrid1.Canvas.Handle, PChar(Panel.Caption), Length(Panel.Caption), S);
  Panel.Font.Height:=Panel.Height-4;
  Panel.Parent:=Self;
  Panel.Visible:=true;
 end;
end;
                
procedure TFontForm.StringGrid1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 if Panel<>nil then Panel.Destroy;
 Panel:=nil;
end;

procedure TFontForm.StringGrid1DblClick(Sender: TObject);
begin
 with StringGrid1 do RichEdit.SelText:=Cells[Col,Row];
end;

procedure TFontForm.RichEditSelectionChange(Sender: TObject);
var st:string;
begin
  st:=RichEdit.SelText;
  if length(st) > 0 then FontDialog.SampleCaption:=st;
end;

end.
