unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, O2DirSpy, StdCtrls, ExtCtrls, FileCtrl;

type
  TMainForm = class(TForm)
    OxygenDirectorySpy1: TOxygenDirectorySpy;
    ChangesListBox: TListBox;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    AddButton: TButton;
    RemoveButton: TButton;
    Panel4: TPanel;
    DirectoriesListBox: TListBox;
    Panel5: TPanel;
    Label1: TLabel;
    WatchSubTreeCheck: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OxygenDirectorySpy1ChangeDirectory(Sender: TObject; ChangeRecord: TDirectoryChangeRecord);
    procedure AddButtonClick(Sender: TObject);
    procedure WatchSubTreeCheckClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RemoveButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  OxygenDirectorySpy1.Enabled := False;
end;

procedure TMainForm.OxygenDirectorySpy1ChangeDirectory(Sender: TObject; ChangeRecord: TDirectoryChangeRecord);
begin
  ChangesListBox.Items.Add(DateTimeToStr(SysUtils.Now) + '  ' + ChangeRecord2String(ChangeRecord));
  with ChangesListBox do if (Items.Count > 0) then ItemIndex := Items.Count - 1;
end;

procedure TMainForm.AddButtonClick(Sender: TObject);
  var s : String;
begin
  if not SelectDirectory(s, [sdAllowCreate, sdPerformCreate, sdPrompt],0) then Exit;
  with OxygenDirectorySpy1 do begin
    Enabled := False;
    Directories.Add(s);
    Enabled := True;
  end;
  with DirectoriesListBox do try
    Items.Clear;
    Items.AddStrings(OxygenDirectorySpy1.Directories);
    ItemIndex := 0;
  except end;
  RemoveButton.Enabled := True;
end;

procedure TMainForm.WatchSubTreeCheckClick(Sender: TObject);
begin
  OxygenDirectorySpy1.WatchSubTree := WatchSubTreeCheck.Checked;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  SendMessage(ChangesListBox.Handle,LB_SETHORIZONTALEXTENT,1000,0);
end;

procedure TMainForm.RemoveButtonClick(Sender: TObject);
  var i : Integer;
begin
  if (DirectoriesListBox.Items.Count = 0) then Exit;
  i := DirectoriesListBox.ItemIndex;
  if (i = -1) then Exit;
  DirectoriesListBox.Items.Delete(i);
  with OxygenDirectorySpy1 do begin
    Enabled := False;
    Directories.Delete(i);
    if (Directories.Count > 0) then begin
      Enabled := True;
      DirectoriesListBox.ItemIndex := 0;
    end;
  end;
  RemoveButton.Enabled := (DirectoriesListBox.Items.Count > 0);
end;

end.
