unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, O2DirSpy,
  StdCtrls, ExtCtrls, FileCtrl;

type
  TMainForm = class(TForm)
    OxygenDirectorySpy1: TOxygenDirectorySpy;
    ChangesListBox: TListBox;
    Panel1: TPanel;
    Label1: TLabel;
    SpyDirLabel: TLabel;
    Panel2: TPanel;
    SelectButton: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OxygenDirectorySpy1ChangeDirectory(Sender: TObject; ChangeRecord: TDirectoryChangeRecord);
    procedure SelectButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  OxygenDirectorySpy1.Enabled := False;
end;

procedure TMainForm.OxygenDirectorySpy1ChangeDirectory(Sender: TObject; ChangeRecord: TDirectoryChangeRecord);
begin
  ChangesListBox.Items.Add(DateTimeToStr(SysUtils.Now) + '  ' + ChangeRecord2String(ChangeRecord));
  with ChangesListBox do if (Items.Count > 0) then ItemIndex := Items.Count - 1; 
end;

procedure TMainForm.SelectButtonClick(Sender: TObject);
  var s : String;
begin
  if not SelectDirectory(s, [sdAllowCreate, sdPerformCreate, sdPrompt],0) then Exit;
  with OxygenDirectorySpy1 do begin
    Enabled := False;
    Directory := s;
    Enabled := True;
  end;
  SpyDirLabel.Caption := s;
end;

end.
