unit u_ftp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, bt_ddftp, ComCtrls, StdCtrls, Menus, Buttons;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    PopupMenu1: TPopupMenu;
    About1: TMenuItem;
    Panel1: TPanel;
    ediHost: TEdit;
    ediUserName: TEdit;
    ediPassword: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ediRemoteDir: TEdit;
    Label4: TLabel;
    cbxPassive: TCheckBox;
    Button1: TButton;
    N1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Button2: TButton;
    BTEasyFTPButton1: TBTEasyFTPButton;
    BTDragDropFTP1: TBTDragDropFTP;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    procedure Button1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ediHostChange(Sender: TObject);
    procedure ediUserNameChange(Sender: TObject);
    procedure ediPasswordChange(Sender: TObject);
    procedure ediRemoteDirChange(Sender: TObject);
    procedure cbxPassiveClick(Sender: TObject);
    procedure BTDragDropFTP1DisplayMessage(Sender: TObject;
      const Messagetext: String; const IsError: Boolean);
    procedure BTDragDropFTP1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure BTDragDropFTP1Connect(Sender: TObject);
    procedure BTDragDropFTP1Disconnect(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure SpeedButton10Click(Sender: TObject);
    procedure SpeedButton11Click(Sender: TObject);
    procedure SpeedButton12Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation
uses Registry;
{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
with BTDragDropFTP1 do
begin
     if Connected
     then Disconnect
     else Connect;
     Application.ProcessMessages;
end;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
Showmessage('MiniFTP  BetaSoft 1998'+#13#10+'BTDragDropFTP build '+BTDragDropFTP1.VersionString);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
with TRegistry.Create do
begin
     if OpenKey('Software\BetaSoft\MiniFTP\Connection1', true)
     then
     begin
          if ReadString('HostName')<>''
          then ediHost.Text := ReadString('HostName');
          if ReadString('LoginName')<>''
          then ediUserName.Text := ReadString('LoginName');
          if ReadString('RemoteDir')<>''
          then ediRemoteDir.Text := ReadString('RemoteDir');
          if ValueExists('Passive')
          then cbxPassive.Checked := ReadBool('Passive')
          else cbxPassive.Checked := BTDragDropFTP1.Passive;
          {if ReadString('Password')<>''
          then ediPassword.Text  := ReadString('Password');}
          CloseKey;
     end;
end;
Caption := 'MiniFTP - BTDragDropFTP build '+BTDragDropFTP1.VersionString
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
with TRegistry.Create do
begin
     if OpenKey('Software\BetaSoft\MiniFTP\Connection1', true)
     then
     begin
          WriteString('HostName', BTDragDropFTP1.HostName);
          WriteString('LoginName', BTDragDropFTP1.LoginName);
          WriteString('RemoteDir', BTDragDropFTP1.RemoteDir);
          WriteBool('Passive', BTDragDropFTP1.Passive);
          // WriteString('Password', BTDragDropFTP1.Password);
          CloseKey;
     end;
end;
end;

procedure TForm1.ediHostChange(Sender: TObject);
begin
BTDragDropFTP1.HostName := ediHost.Text;
end;

procedure TForm1.ediUserNameChange(Sender: TObject);
begin
BTDragDropFTP1.LoginName := ediUserName.Text
end;

procedure TForm1.ediPasswordChange(Sender: TObject);
begin
BTDragDropFTP1.Password := ediPassword.Text;
end;

procedure TForm1.ediRemoteDirChange(Sender: TObject);
begin
BTDragDropFTP1.RemoteDir := ediRemoteDir.Text;
end;

procedure TForm1.cbxPassiveClick(Sender: TObject);
begin
BTDragDropFTP1.Passive := cbxPassive.Checked;
end;

procedure TForm1.BTDragDropFTP1DisplayMessage(Sender: TObject;
  const Messagetext: String; const IsError: Boolean);
begin
StatusBar1.SimpleText := Messagetext;
end;

procedure TForm1.BTDragDropFTP1Click(Sender: TObject);
begin
Button2.Enabled := BTDragDropFTP1.CanDownload;
Button2.Caption := 'Download '+BTDragDropFTP1.FileName;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
BTDragDropFTP1.DownLoadSelected;
end;

procedure TForm1.BTDragDropFTP1Connect(Sender: TObject);
begin
Button1.Caption := 'Disconnect'
end;

procedure TForm1.BTDragDropFTP1Disconnect(Sender: TObject);
begin
Button1.Caption := 'Connect'
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
BTDragDropFTP1.ViewSmallIcons(self);
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
BTDragDropFTP1.ViewLargeIcons(self);
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
BTDragDropFTP1.ViewList(self);
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
BTDragDropFTP1.ViewReport(self);
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
BTDragDropFTP1.OrderByName(self);
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
BTDragDropFTP1.OrderBySize(self);
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
BTDragDropFTP1.OrderByDate(self);
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
BTDragDropFTP1.OrderByType(self);
end;

procedure TForm1.SpeedButton9Click(Sender: TObject);
var
DirName: string;
begin
InputQuery('New folder', 'Folder name:', DirName);
BTDragDropFTP1.NewFolder(DirName)
end;

procedure TForm1.SpeedButton10Click(Sender: TObject);
begin
BTDragDropFTP1.DeleteFile(BTDragDropFTP1.FileName);
end;

procedure TForm1.SpeedButton11Click(Sender: TObject);
begin
BTDragDropFTP1.DeleteFolder(BTDragDropFTP1.FileName);
end;

procedure TForm1.SpeedButton12Click(Sender: TObject);
begin
BTDragDropFTP1.Rename(BTDragDropFTP1.FileName, 'x');
end;

end.
