unit intmain;

interface
uses
  delphin,dcgen,classes,sysutils;

procedure MainProc;

implementation

{-----------------------------------------}

procedure CreateIntFile(Const FName:String);
Var
  FOut:TFileStream;
  FMem:TMemoryStream;
  H:THalCompiler;
begin
  FMem:=TMemoryStream.Create;
  try
    FOut:=TFileStream.Create(ChangeFileExt(FName,'.INT'),fmcreate);
    try
      FMem.LoadFromFile(FName);
      FMem.Seek(0,soFromBeginning);
      H:=THalCompiler.Create(FMem,nil);
      With H do
        While True do
        begin
          Token:=ReadToken;
          If Token.ID=idendoffile then break;
          If Token.ID=id_implement then
          begin
           FOut.CopyFrom(FMem,CurRead);
           break;
          end;
        end;
    finally
      FOut.Free;
    end;
  finally
    FMem.Free;
  end;
end;

{-----------------------------------------}

procedure CreateINTsForDir(Const APath:String );
var
  SearchRec: TSearchRec;
  Re:Integer;
  FileName:String;
begin
  Re:=FindFirst(AddSlash(APath)+'*.pas' , faAnyFile, SearchRec);
  try
    While Re=0 do
    begin
      FileName:=AddSlash(APath)+Searchrec.Name;
      CreateIntFile(FileName);
      Writeln(FileName);
      Re:=FindNext(SearchRec);
    end;
  finally
    FindClose(SearchRec);
  end;  
end;

{-----------------------------------------}

procedure MainProc;
begin
  writeln('INT Maker Version 1.01');
  writeln('Copyright (c) 1997,1998 S.Kurinny & S.Kostinsky');
  writeln;
  writeln('This utility creates INT files from PAS files in the current directory');
  writeln('or in the directory passed as parameter');
  
  if ParamCount=0
  then
    CreateINTsForDir(ExtractFilePath(ParamStr(0)))
  else
    CreateINTsForDir(ParamStr(1));

end;

end.