{*******************************************************}
{                                                       }
{  Main form of Instant Report                          }
{  Copyright (c) 1997,1998 S.Kurinny & S.Kostinsky      }
{                                                       }
{*******************************************************}
unit MainUnit;

interface
{$I dc.inc}

// Comment out this define if you don't have Volume 3 of Dream Controls
{$DEFINE VOLUME3}

{$IFDEF D3}
// Comment out this define if you don't want to compile QuickReport components into EXE
{$DEFINE QREP}
{$ENDIF}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Menus, StdCtrls, buttons, extctrls, dcfdes,useunit,
  dsgnintf, dcL0, dcGen,dcpalet,ctrlreg,dcsplit,DCMenu,dcdbreg,ctrlreg2

  {$IFDEF QREP}
  ,dcqureg
  {$ENDIF}

  {$IFDEF VOLUME3}
  ,ctrlreg3, dcL2, HalInsp, HALInit, editunit
  {$ENDIF}

  {$IFDEF D3}
  ,dcpload,packcfg
  {$ENDIF}
  ;

{$IFNDEF D3}

  {$R ctrlreg.dcr}
  {$R dcdb30.dcr}
  {$R dcstd30.dcr}
  {$R DCSYS31.DCR}
  {$R DCWIN31.DCR}
  {$R ctrlreg2.dcr}

  {$IFDEF VOLUME3}
    {$R ctrlreg3.dcr}
  {$ENDIF}

{$ENDIF}

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    NewForm1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAll1: TMenuItem;
    Close1: TMenuItem;
    CloseAll1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit2: TMenuItem;
    N6: TMenuItem;
    DeleteBlock: TMenuItem;
    Paste1: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    N7: TMenuItem;
    Undo1: TMenuItem;
    Redo1: TMenuItem;
    SelectAll1: TMenuItem;
    Aligntogrid1: TMenuItem;
    BringtoFront1: TMenuItem;
    SendtoBack1: TMenuItem;
    Align1: TMenuItem;
    Size1: TMenuItem;
    Scale1: TMenuItem;
    TabOrder1: TMenuItem;
    LockControls1: TMenuItem;
    Help2: TMenuItem;
    N2: TMenuItem;
    Saveas1: TMenuItem;
    CreationOrder1: TMenuItem;
    N3: TMenuItem;
    About1: TMenuItem;
    Contents1: TMenuItem;
    N5: TMenuItem;
    Onlinereg: TMenuItem;
    N4: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    NewUnit1: TMenuItem;
    Panel2: TPanel;
    NewButton: TSpeedButton;
    OpenButton: TSpeedButton;
    SaveButton: TSpeedButton;
    CutButton: TSpeedButton;
    CopyButton: TSpeedButton;
    PasteButton: TSpeedButton;
    Bevel1: TBevel;
    RunButton: TSpeedButton;
    BrowseButton: TSpeedButton;
    N10: TMenuItem;
    UseUnit1: TMenuItem;
    Addtoproject1: TMenuItem;
    RemovefromProject1: TMenuItem;
    View1: TMenuItem;
    ObjectInspector1: TMenuItem;
    AlignmentPalette1: TMenuItem;
    ToggleFormUnit1: TMenuItem;
    HomePage1: TMenuItem;
    Writetous1: TMenuItem;
    Browser1: TMenuItem;
    Search1: TMenuItem;
    Find1: TMenuItem;
    FindinFiles1: TMenuItem;
    Replace1: TMenuItem;
    SearchAgain1: TMenuItem;
    IncrementalSearch1: TMenuItem;
    N12: TMenuItem;
    GotoLineNumber1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Run1: TMenuItem;
    Run2: TMenuItem;
    Parameters1: TMenuItem;
    Project1: TMenuItem;
    AddtoProject2: TMenuItem;
    RemovefromProject2: TMenuItem;
    N13: TMenuItem;
    SyntaxCheck1: TMenuItem;
    N14: TMenuItem;
    Options1: TMenuItem;
    Compile1: TMenuItem;
    N15: TMenuItem;
    EvaluateModify1: TMenuItem;
    EnvironmentOptions1: TMenuItem;
    ReadOnly1: TMenuItem;
    ReadOnly2: TMenuItem;
    Tools1: TMenuItem;
    N17: TMenuItem;
    ResourceMaster1: TMenuItem;
    N11: TMenuItem;
    DCSplitter1: TDCSplitter;
    PaletteMenu: TPopupMenu;
    Components1: TMenuItem;
    N16: TMenuItem;
    EnvironmentOptions2: TMenuItem;
    WindowList1: TMenuItem;
    Palette: TDCCompPalette;
    DCMenu1: TDCMenu;
    procedure Exit1Click(Sender: TObject);
    procedure NewForm1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure ObjectInspector1Click(Sender: TObject);
    procedure EnvironmentOptions1Click(Sender: TObject);
    procedure OnlineregClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure BrowseButtonClick(Sender: TObject);
    procedure UseUnit1Click(Sender: TObject);
    procedure AlignmentPalette1Click(Sender: TObject);
    procedure HomePage1Click(Sender: TObject);
    procedure Writetous1Click(Sender: TObject);
    procedure ToggleFormUnit1Click(Sender: TObject);
    procedure Align1Click(Sender: TObject);
    procedure Size1Click(Sender: TObject);
    procedure Scale1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure DeleteBlockClick(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure Aligntogrid1Click(Sender: TObject);
    procedure BringtoFront1Click(Sender: TObject);
    procedure SendtoBack1Click(Sender: TObject);
    procedure LockControls1Click(Sender: TObject);
    procedure CreationOrder1Click(Sender: TObject);
    procedure TabOrder2Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure SaveAll1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure CloseAll1Click(Sender: TObject);
    procedure RunButtonClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure InstantReportUpdateButtons(Sender: TObject);
    procedure InstantReportUpdateSaveButton(Sender: TObject);
    procedure GotoLineNumber1Click(Sender: TObject);
    procedure ReadOnly1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure ResourceMaster1Click(Sender: TObject);
    procedure SearchAgain1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure EnvironmentOptions2Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Redo1Click(Sender: TObject);
    procedure WindowList1Click(Sender: TObject);
    procedure PalettePagesChanged(Sender: TObject);
  private
  protected
    procedure WMINITMENU(Var Message:TMessage);message WM_INITMENU;
    procedure WMGETMINMAXINFO(Var Message:TMessage);message WM_GETMINMAXINFO;
    procedure WMSETTINGCHANGE(Var Message:TMessage);message WM_SETTINGCHANGE;
    procedure OnSettingChange;
  public
    SkipLimitSize:Boolean;
    {$IFDEF D3}
    DCPackageLoader:TDCPackageLoader;
    {$ENDIF}
  end;

var
  MainForm: TMainForm;


procedure RegisterAllProps;
procedure OpenParamFiles;

implementation

uses abounit;

{$R *.DFM}

{------------------------------------------------------------------}

procedure RegisterAllProps;
begin
  If not CompiledWithPackages then
  begin
    // Vol.I components registration
    ctrlreg.RegisterPropEdit;
    dcdbreg.Register;
    dcdbreg.InstantRegister;

    // Vol.II components registration
    ctrlreg2.Register;

    // Quick Report components registration
    {$IFDEF QREP}
    dcqureg.InstantRegister;
    {$ENDIF}
  end;
end;

{------------------------------------------------------------------}

procedure OpenParamFiles;
Var
  i:Integer;
begin
  for I:=1 to ParamCount do
   if FileExists(ParamStr(i)) then
    InstantReport.LoadFromFile(ParamStr(i));
end;

{------------------------------------------------------------------}

procedure TMainForm.WMINITMENU(Var Message:TMessage);
begin
  inherited;
  InstantReport.DoUpdateButtons;
  Message.Result:=0;
end;

{------------------------------------------------------------------}

procedure TMainForm.WMGETMINMAXINFO(Var Message:TMessage);
begin
  If SkipLimitSize then exit;
  With PMinMaxInfo(Message.lParam)^ do
  begin
    ptMaxSize.y:=Height;
    ptMinTrackSize.y:=Height;
    ptMaxTrackSize.y:=Height;
    ptMinTrackSize.x:=500;
  end;
  inherited;
  Message.Result:=0;
end;

{------------------------------------------------------------------}

procedure TMainForm.OnSettingChange;
var
  savestate : TWindowState;
  delta:Integer;
begin
  savestate := windowstate;
  SkipLimitSize:=True;

  If Palette.PageCount>0 then
  begin
    delta:=(CPaletteButtonSize-Palette.Pages[0].ClientHeight);
    ClientHeight:=ClientHeight+Delta;
  end;
  SkipLimitSize:=False;
  windowstate := savestate;
end;

{------------------------------------------------------------------}

procedure TMainForm.WMSETTINGCHANGE(Var Message:TMessage);
begin
  inherited;
  OnSettingChange;
  Message.Result:=0;
end;

{------------------------------------------------------------------}

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

{------------------------------------------------------------------}

procedure TMainForm.NewForm1Click(Sender: TObject);
begin
  InstantReport.NewForm;
end;

{------------------------------------------------------------------}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  SetFlatProp([NewButton,OpenButton,SaveButton,CutButton,
    CopyButton,PasteButton,RunButton,BrowseButton],True);

 {$IFDEF VOLUME3}
 With TInstantReport2.Create(self) do
 {$ELSE}
 With TInstantReport.Create(self) do
 {$ENDIF}
 begin
   PopupMenu := Self.PopupMenu1;
   OnUpdateButtons := InstantReportUpdateButtons;
   OnUpdateSaveButton := InstantReportUpdateSaveButton;
   DoUpdateButtons;
 end;

  If not CompiledWithPackages then
  begin
  // Vol.II components registration
 {$IFDEF VOLUME3}
   ctrlreg3.Register;
 {$ENDIF}
  end;

  ReadWinPosFromReg(Self, 'MainForm');
  InstantReport.LoadConfig;
  OnSettingChange;
  {$IFDEF D3}
  If CompiledWithPackages then
  begin
    DCPackageLoader:=TDCPackageLoader.Create(Self);
    With DCPackageLoader do
    begin
      IniSection:='Packages';
      UseRegistry:=True;
      Options:=[];
      try
        DefaultLoadConfig;
      finally
        DefaultSaveConfig;
        Options:=[plAutoSave,plAutoUpdate];
      end;
    end;
  end;
  {$ENDIF}

  {$IFDEF VOLUME3}
  AEditForm;
  {$ENDIF}
end;

{------------------------------------------------------------------}

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  WriteWinPosToReg(Self, 'MainForm');
  If InstantReport<>nil then
    InstantReport.SaveConfig;
end;

{------------------------------------------------------------------}

procedure TMainForm.Open1Click(Sender: TObject);
begin
  InstantReport.Open;
end;

{------------------------------------------------------------------}

procedure TMainForm.ObjectInspector1Click(Sender: TObject);
begin
  ShowInspector;
end;

{------------------------------------------------------------------}

procedure TMainForm.EnvironmentOptions1Click(Sender: TObject);
begin
  {$IFDEF D3}
  ShowPackagesConfig;
  {$ENDIF}
end;

{------------------------------------------------------------------}

procedure TMainForm.OnlineregClick(Sender: TObject);
begin
  OnlineRegistration;
end;

{------------------------------------------------------------------}

procedure TMainForm.About1Click(Sender: TObject);
begin
   ShowAboutForm;
end;

{-----------------------------------------------------------}

procedure TMainForm.BrowseButtonClick(Sender: TObject);
begin
  {$IFDEF VOLUME3}
  ShowBrowser;
  {$ENDIF}
end;

{-----------------------------------------------------------}

procedure TMainForm.UseUnit1Click(Sender: TObject);
begin
  InstantReport.UseUnit;
end;

{-----------------------------------------------------------}

procedure TMainForm.AlignmentPalette1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_ShowAlignmentPalette);
end;

{-----------------------------------------------------------}

procedure TMainForm.HomePage1Click(Sender: TObject);
begin
  HomePage;
end;

{-----------------------------------------------------------}

procedure TMainForm.Writetous1Click(Sender: TObject);
begin
  WriteToUs;
end;

{-----------------------------------------------------------}

procedure TMainForm.ToggleFormUnit1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_ToggleFormUnit);
end;

{-----------------------------------------------------------}

procedure TMainForm.Align1Click(Sender: TObject);
begin
  SimpleBroadCast(cm_AlignControls);
end;

{-----------------------------------------------------------}

procedure TMainForm.Size1Click(Sender: TObject);
begin
  SimpleBroadCast(cm_SizeControls);
end;

{-----------------------------------------------------------}

procedure TMainForm.Scale1Click(Sender: TObject);
begin
  SimpleBroadCast(cm_ScaleControls);
end;

{-----------------------------------------------------------}

procedure TMainForm.Cut1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_ClipBoardCut);
end;

{-----------------------------------------------------------}

procedure TMainForm.Copy1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_ClipboardCopy);
end;

{-----------------------------------------------------------}

procedure TMainForm.Paste1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_ClipboardPaste);
end;

{-----------------------------------------------------------}

procedure TMainForm.DeleteBlockClick(Sender: TObject);
begin
  SimpleBroadcast(cm_DeleteBlock);
end;

{-----------------------------------------------------------}

procedure TMainForm.SelectAll1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_SelectAll);
end;

{-----------------------------------------------------------}

procedure TMainForm.Aligntogrid1Click(Sender: TObject);
begin
  SimpleBroadCast(cm_AlignToGrid);
end;

{-----------------------------------------------------------}

procedure TMainForm.BringtoFront1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_BringToFront);
end;

{-----------------------------------------------------------}

procedure TMainForm.SendtoBack1Click(Sender: TObject);
begin
  SimpleBroadCast(cm_SendToBack);
end;

{-----------------------------------------------------------}

procedure TMainForm.LockControls1Click(Sender: TObject);
begin
  SimpleBroadCast(cm_ChangeLockControls);
end;

{-----------------------------------------------------------}

procedure TMainForm.CreationOrder1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_CreationOrder);
end;

{-----------------------------------------------------------}

procedure TMainForm.TabOrder2Click(Sender: TObject);
begin
  SimpleBroadcast(cm_TabOrder);
end;

{---------------------------------------------------}

procedure TMainForm.Save1Click(Sender: TObject);
begin
  InstantReport.Save;
end;

{---------------------------------------------------}

procedure TMainForm.Saveas1Click(Sender: TObject);
begin
  InstantReport.SaveAs;
end;

{---------------------------------------------------}

procedure TMainForm.SaveAll1Click(Sender: TObject);
begin
  InstantReport.SaveAll;
end;

{---------------------------------------------------}

procedure TMainForm.Close1Click(Sender: TObject);
begin
  InstantReport.Close;
end;

{---------------------------------------------------}

procedure TMainForm.CloseAll1Click(Sender: TObject);
begin
  InstantReport.CloseAll;
end;

{---------------------------------------------------}

procedure TMainForm.RunButtonClick(Sender: TObject);
begin
  InstantReport.Run;
end;

{---------------------------------------------------}

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose:=Instantreport.CloseAll;
end;

{---------------------------------------------------}

procedure TMainForm.InstantReportUpdateButtons(Sender: TObject);
Var
  E,B:Boolean;
  D:TDCFormDesigner;
begin
  D:=InstantReport.ActiveDesigner;
  B:=D<>nil;
  E:=Instantreport.InCodeEditor;

  SetEnabledControls([
    CutButton,CopyButton,PasteButton,RunButton,GotoLineNumber1,Replace1,
    Run2,Find1,SearchAgain1,ReadOnly1,Saveas1,UseUnit1,ToggleFormUnit1,
    Close1,CloseAll1,DeleteBlock,Paste1,Copy1,Cut1,SelectAll1,
    AlignmentPalette1],b);

  SetEnabledControls([Undo1,Redo1],b and e);

  SetEnabledControls([
    Aligntogrid1,BringtoFront1,SendtoBack1,Align1,Size1,Scale1,TabOrder1,
    LockControls1,CreationOrder1],b and (E=False));

  If LockControls1.Enabled then
    LockControls1.Checked:=D.LockControls;
  If ReadOnly1.Enabled then
    ReadOnly1.Checked:=D.ReadOnly;
end;

{---------------------------------------------------}

procedure TMainForm.InstantReportUpdateSaveButton(Sender: TObject);
Var
  B:Boolean;
  D:TDCFormDesigner;
begin
  D:=InstantReport.ActiveDesigner;
  B:=D<>nil;
  With SaveButton do
  begin
    Enabled:=(b) and (D.WasChanged);
    Save1.Enabled:=Enabled;
    SaveAll1.Enabled:=Enabled;
  end;
end;

{---------------------------------------------------}

procedure TMainForm.GotoLineNumber1Click(Sender: TObject);
begin
  SimpleBroadcast(CM_GOTOLINE);
end;

{---------------------------------------------------}

procedure TMainForm.ReadOnly1Click(Sender: TObject);
begin
  SimpleBroadCast(cm_ChangeReadOnly);
end;

{---------------------------------------------------}

procedure TMainForm.PopupMenu1Popup(Sender: TObject);
begin
  ReadOnly2.Checked:=InstantReport.ActiveDesigner.ReadOnly;
end;

{---------------------------------------------------}

procedure TMainForm.ResourceMaster1Click(Sender: TObject);
begin
  InstantReport.OpenExecutable;
end;

{---------------------------------------------------}

procedure TMainForm.SearchAgain1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_SearchAgain);
end;

{---------------------------------------------------}

procedure TMainForm.Replace1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_Replace);
end;

{---------------------------------------------------}

procedure TMainForm.Find1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_Find);
end;

{---------------------------------------------------}

procedure TMainForm.EnvironmentOptions2Click(Sender: TObject);
begin
  InstantReport.EnvironmentOptions;
end;

{---------------------------------------------------}

procedure TMainForm.Undo1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_Undo);
end;

{---------------------------------------------------}

procedure TMainForm.Redo1Click(Sender: TObject);
begin
  SimpleBroadcast(cm_Redo);
end;

{---------------------------------------------------}

procedure TMainForm.WindowList1Click(Sender: TObject);
begin
  ShowWindowList;
end;

procedure TMainForm.PalettePagesChanged(Sender: TObject);
begin
  OnSettingChange;
end;

end.
