unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, DCMenu, StdCtrls, dcfdes;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure DesignerKeyDown (Sender : TObject; var Key: Word; Shift: TShiftState);
    procedure DesignerAction(Sender : TObject; Instance : TPersistent;
                            Action : TActionType; var Allow : boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DesignerKeyDown (Sender : TObject; var Key: Word; Shift: TShiftState);
var
  d : TDesigner;
begin
  if key = VK_F5 then
    begin
      d := Designer;
      Designer := nil;
      d.Free;
      Button1.Caption := 'Start &Design';
    end;
end;

procedure TForm1.DesignerAction(Sender : TObject; Instance : TPersistent;
                            Action : TActionType; var Allow : boolean);
begin
  if (Instance = Button2) and (Action = atMove) then
    Allow := false;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  with TDCFormDesigner.Create do
    try
      Form := self;
      Active := true; // Now we are in Design mode. Easy, isn't it?

      OnKeyDown := DesignerKeyDown;
      OnAction  := DesignerAction;
    except
      Free;
    end;
  Button1.Caption := 'Press F5 to stop designing';
end;

end.
