unit Demo2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, DBTables, Grids, DBGrids, ExtCtrls, Buttons, DbpSet;

type
  TDemo2Form = class(TForm)
    Panel1: TPanel;
    DBGrid1: TDBGrid;
    Table1: TTable;
    DataSource1: TDataSource;
    DBFilterDialog1: TDBFilterDialog;
    Memo1: TMemo;
    CustTable: TTable;
    EmpTable: TTable;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    procedure DBFilterDialog1EditButtonClick(FieldRecord: TFieldRecord;
      EditNo: Integer);
    procedure DBFilterDialog1EditChange(FieldRecord: TFieldRecord;
      EditNo: Integer);
    procedure DBFilterDialog1EditKeyDown(FieldRecord: TFieldRecord;
      var Key: Word; Shift: TShiftState; EditNo: Integer);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Demo2Form: TDemo2Form;

implementation

uses Employee, Customer;

{$R *.DFM}

procedure TDemo2Form.DBFilterDialog1EditButtonClick(FieldRecord: TFieldRecord;
  EditNo: Integer);
begin
  if AnsiCompareText(FieldRecord.FieldName,'EmpNo')=0 then
  begin
    if EmployeeForm.ShowModal=mrOk then
      FieldRecord.Values[EditNo]:=EmployeeForm.EmpNo;
  end
  else if AnsiCompareText(FieldRecord.FieldName,'CustNo')=0 then
  begin
    if CustomerForm.ShowModal=mrOk then
      FieldRecord.Values[EditNo]:=CustomerForm.CustNo;
  end;
end;

procedure TDemo2Form.DBFilterDialog1EditChange(FieldRecord: TFieldRecord;
  EditNo: Integer);
begin
  if AnsiCompareText(FieldRecord.FieldName,'EmpNo')=0 then
  begin
    if EmpTable.FindKey([FieldRecord.Values[EditNo]]) then
        FieldRecord.CommentTexts[EditNo]:=EmpTable.FieldByname('LastName').AsString+' '
          +EmpTable.FieldByname('FirstName').AsString
    else FieldRecord.CommentTexts[EditNo]:='';
  end
  else if AnsiCompareText(FieldRecord.FieldName,'CustNo')=0 then
  begin
    if CustTable.FindKey([FieldRecord.Values[EditNo]]) then
      FieldRecord.CommentTexts[EditNo]:=CustTable.FieldByName('Company').AsString
    else FieldRecord.CommentTexts[EditNo]:='';
  end
end;

procedure TDemo2Form.DBFilterDialog1EditKeyDown(FieldRecord: TFieldRecord;
  var Key: Word; Shift: TShiftState; EditNo: Integer);
begin
  if Key=VK_F2 then DBFilterDialog1EditButtonClick(FieldRecord,EditNo);
end;


procedure TDemo2Form.BitBtn1Click(Sender: TObject);
begin
  DBFilterDialog1.Execute;
end;

end.
