unit Unit2;

interface

uses   WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, DB, DBTables,Messages, Grids, DBGrids, DataNet;

type
  TOKRightDlg = class(TForm)
    OKBtn: TButton;
    Bevel1: TBevel;
    Table1: TTable;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Button1: TButton;
    Button2: TButton;
    DBLink1: TDBLink;
    Label1: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OKRightDlg: TOKRightDlg;

implementation

uses Unit1;

{$R *.DFM}

procedure TOKRightDlg.OKBtnClick(Sender: TObject);
begin
close
end;

procedure TOKRightDlg.Button1Click(Sender: TObject);
begin
{Manually Notify Change}
DBLink1.NotifyChange(Table1)
end;

procedure TOKRightDlg.Button2Click(Sender: TObject);
begin
{Disable DBLink}
DBLink1.Active:=False;
{Batch Work Demo Beginning}
Table1.DisableControls;
Table1.Last;
While not Table1.bof do
  begin
   Table1.Edit;
   Table1.FieldByName('ZIP').AsInteger:=Table1.FieldByName('ZIP').AsInteger+10;
   Table1.Post;
   Table1.prior;
  end;
Table1.EnableControls;
{End of Batch Work}
{Reactivate DBLink}
DBLink1.Active:=True;
{Manually Notify Change}
DBLink1.NotifyChange(Table1);
end;

procedure TOKRightDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  {Restore All Tables in original state}
  {DBLink1.UnRegisterTable;}
  {Call not needed Auto UnRegister when destroying component}
end;

procedure TOKRightDlg.FormCreate(Sender: TObject);
var s:string;
begin
 {Register All Tables of the Form
  !!!!!    This is important   !!!!!
  Never forget that TDBlink need the Events Methods of the Dataset
  to work, if you need to set manually the Dataset EventHandler
  Call RegisterTable only after you've done this !!!

  If you plan to change Dataset EventHandler on the fly,
  Call before UnregisterTable, make you change
  then Call RegisterTable again : that's all}

  {DBLink1.RegisterTable;}
  {Call not needed AutoRegister is set to True}
  GetDir(0,S);
  Table1.DatabaseName:=S;
  Table1.open;
end;

procedure TOKRightDlg.FormDestroy(Sender: TObject);
begin
Table1.close;
end;

end.
