{------------------------------------------------------------------------------
  Project:  Amazo-App
  Purpose:  Demonstration of simple database application development in Delphi
            and APOLLO.
  Notes  :  Requires a TEST.DBF located in the same directory as AMAZOAPP.EXE
            with at least two CHARACTER fields of equal length, one called
            FIRST and one called LAST.
------------------------------------------------------------------------------}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, DBCtrls, Mask, DB, DBTables,
  DbiTypes, Grids, DBGrids, DbiProcs, Apollo, Gauges, DBNet32;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Label1: TLabel;
    Button1: TButton;
    Apollo1: TApollo;
    Gauge1: TGauge;
    DBNavigator1: TDBNavigator;
    NetDataLink1: TNetDataLink;
    DBLink1: TDBLink;
    procedure Button1Click(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{Create index on UPPER(LAST+FIRST) }
procedure TForm1.Button1Click(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  Gauge1.Visible := True;
  with Apollo1 do
  begin
    SetGaugeHook( Form1.Handle );
    IndexTag( '', 'NAME', 'UPPER(LAST+FIRST)', IDX_NONE, False, '' );
    SetGaugeHook( 0 );
  end;
  Gauge1.Visible := False;
  Screen.Cursor := crDefault;
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
begin
  Label1.Caption := IntToStr( Apollo1.Recno ) + '/' +
                    IntToStr( Apollo1.RecCount );
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
	wVal : Word;
begin
if (Key and $7000) <> 0 then
  begin
  	wVal := -Word( Key );
    Gauge1.Progress := wVal;
    Key := 0;
  end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  { The following line of code insures that the Table1.Database
    property looks in the same directory as the AMAZOAPP.EXE. }
  Table1.DatabaseName := ExtractFilePath( Application.ExeName );
  Table1.Open;
end;

procedure TForm1.FormDeactivate(Sender: TObject);
begin
  Table1.Close;
end;

end.
