unit unitdem3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, math, ExtCtrls, ComCtrls,
  richedit, Buttons, dbasic;

type
  Tmainform = class(TForm)   
    Panel1: TPanel;
    sbcoord: TStatusBar;
    BitBtn1: TBitBtn;
    BitBtn4: TBitBtn;
    OpenDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;               
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    rsource1: TRichEdit;
    rsource2: TRichEdit;
    rsource3: TRichEdit;
    routput: TRichEdit;
    Splitter1: TSplitter;
    ButClone: TButton;
    procedure FormCreate(Sender: TObject);
    procedure rsource1SelectionChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ButCloneClick(Sender: TObject);
    procedure Panel1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
    ticks: integer;
    mybasic: TDbasic;
  end;


var
  mainform: Tmainform;

implementation

{$R *.DFM}


procedure Tmainform.FormCreate(Sender: TObject);
begin
   mybasic := tdbasic.create;
   mybasic.this := self;
   mybasic.OnProgress := Panel1Click;
   ticks := 0;
end;

procedure Tmainform.FormDestroy(Sender: TObject);
begin
   mybasic.free;
end;

procedure Tmainform.rsource1SelectionChange(Sender: TObject);
var
  x,y:integer;
  rsource: TRichEdit;
begin
  rsource := Sender as TRichEdit;
  y := SendMessage(rsource.Handle,EM_EXLINEFROMCHAR,0,rsource.SelStart);
  x := rsource.SelStart - SendMessage(rsource.Handle,EM_LINEINDEX,y,0);
  sbcoord.simpletext := Format('Row: %2d   Col: %2d',[y+1,x+1]);
end;

// ---------------- VARARRAY --------------------

function p_alloc(var d:double): pointer; stdcall;
begin
   result := allocmem(sizeof(double)*round(d));
end;

function n_get(p:pointer; var d:double): double; stdcall;
var offs: integer;
begin
   offs := integer(p) + (round(d) * sizeof(double));
   result := pdouble(offs)^;
end;                         // No checks , just a demo.

function n_set(p:pointer; var d,n:double): double; stdcall;
var offs: integer;
begin
   offs := integer(p) + (round(d) * sizeof(double));
   pdouble(offs)^ := n;
   result := 0;
end;

// ----------------- BUTTONS --------------------

function p_createbutton(tag:pointer; pcaption:pchar): pointer; stdcall;
var
   b: tbutton;
   mform: Tmainform;
begin
   mform := Tobject(tag) as Tmainform;
   b := tbutton.create(mform);
   b.caption := pcaption;
   b.parent := mform.Panel1;
   result := b
end;

function p_movebutton(p:pointer; var x,y:double): pointer; stdcall;
var
   b: tbutton;
begin
   b := tobject(p) as Tbutton;
   b.left := round(x);
   b.top := round(y);
   b.parent.update;
end;

// ----------------- FILE DEMO --------------------

function p_createfile(pfilename:pchar): pointer; stdcall;
var f: TFileStream;
begin
   f := TFileStream.create(pfilename,fmCreate);
   result := f;
end;

function n_write(p:pointer; var n:double): double; stdcall;
var
   f: TFileStream;
   b: byte;
begin
   f := TFileStream(p);
   b := round(n);
   f.write(b,1);
   result := 0;           // No checks.
end;

function n_closefile(p:pointer): double; stdcall;
var f: TFileStream;
begin
   f := TFileStream(p);
   f.free;
   result := 0;
end;

// ----------------------------------------------

procedure Tmainform.BitBtn1Click(Sender: TObject);
var
   r: integer;
   sl: tstringlist;
begin                                      // max three functions in
   sl := tstringlist.create;               // demo version
   r := 0;
   case pagecontrol1.ActivePage.TabIndex of
    0: begin
         sl.addobject('alloc#@n',@p_alloc);
         sl.addobject('get@#n',@n_get);
         sl.addobject('set@#nn',@n_set);
         r := mybasic.compile(rsource1.lines,sl);
       end;
    1: begin
         sl.addobject('createbutton#@#$',@p_createbutton);
         sl.addobject('movebutton#@#nn',@p_movebutton);
         r := mybasic.compile(rsource2.lines,sl);
       end;
    2: begin
         sl.addobject('createfile#@$',@p_createfile);
         sl.addobject('write@#n',@n_write);
         sl.addobject('closefile@#',@n_closefile);
         r := mybasic.compile(rsource3.lines,sl);
       end;
   end;
   if r = 0 then mybasic.execute(routput.lines);
   sl.free;
end;

procedure Tmainform.ButCloneClick(Sender: TObject);
var mform: Tmainform;
begin
   mform := Tmainform.create(application);
   mform.left := mform.left + 32;
   mform.top := mform.top + 32;
   mform.show;
end;

procedure Tmainform.Panel1Click(Sender: TObject);
begin
  if (ticks and $1f) = 0      // otherwise it slows down too much execution
     then sbcoord.simpletext := 'Ticks: ' + inttostr(ticks);
  inc(ticks);
end;

procedure Tmainform.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

end.
