unit unitdem2;

interface                  

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, math, ExtCtrls, ComCtrls,
  richedit, Buttons, dbasic;

type
  Tmainform = class(TForm)   
    Panel1: TPanel;
    sbcoord: TStatusBar;
    rsource: TRichEdit;
    ButRun: TBitBtn;
    ButOpen: TBitBtn;
    ButSave: TBitBtn;              
    ButHelp: TBitBtn;
    OpenDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    ButEval: TButton;
    ListBox1: TListBox;
    PaintBox1: TPaintBox;
    PaintBox2: TPaintBox;
    RadioGroup: TRadioGroup;
    ButClone: TButton;
    procedure FormCreate(Sender: TObject);
    procedure rsourceSelectionChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButRunClick(Sender: TObject);
    procedure ButOpenClick(Sender: TObject);
    procedure ButSaveClick(Sender: TObject);
    procedure ButEvalClick(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure ButCloneClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
    mybasic: TDbasic;
  end;


var
  mainform: Tmainform;

implementation         

{$R *.DFM}


procedure Tmainform.FormCreate(Sender: TObject);
begin
   // decimalseparator := '.';   // Not needed , see Help
   mybasic := tdbasic.create;
   mybasic.This := self;         // Used by function p_getcanvas
end;

procedure Tmainform.FormDestroy(Sender: TObject);
begin
   mybasic.free;
end;

procedure Tmainform.rsourceSelectionChange(Sender: TObject);
var x,y:integer;
begin
   y := SendMessage(rsource.Handle,EM_EXLINEFROMCHAR,0,rsource.SelStart);
   x := rsource.SelStart - SendMessage(rsource.Handle,EM_LINEINDEX,y,0);
   sbcoord.simpletext := Format('Row: %2d   Col: %2d',[y+1,x+1]);
end;

// ------------- Delphi functions ---------------

function p_getcanvas(pf:pointer): pointer; stdcall;
var mform: Tmainform;
begin                                    // Generic, object oriented code
   mform := TMainform(pf);               // simulating "Procedures of Objects"
   with mform do
        if RadioGroup.ItemIndex = 0 then result := PaintBox1.canvas
           else result := PaintBox2.canvas;
end;

function p_lineto(cnv:pointer; var d1,d2:double): pointer; stdcall;
begin
   TCanvas(cnv).lineto(round(d1),round(d2));
end;

function p_moveto(cnv:pointer;var d1,d2:double): pointer; stdcall;
begin
   TCanvas(cnv).moveto(round(d1),round(d2));
end;

// ----------------------------------------------

procedure Tmainform.ButRunClick(Sender: TObject);
var
   r: integer;
   sl: tstringlist;
begin
   sl := tstringlist.create;
   sl.addobject('getcanvas#@#',@p_getcanvas);
   sl.addobject('moveto#@#nn',@p_moveto);
   sl.addobject('lineto#@#nn',@p_lineto);
   r := mybasic.compile(rsource.lines,sl);
   if r = 0 then mybasic.execute(nil);
   sl.free;
end;

procedure Tmainform.ButOpenClick(Sender: TObject);
begin
   if opendlg.execute then
      rsource.Lines.LoadFromFile(opendlg.filename);
end;

procedure Tmainform.ButSaveClick(Sender: TObject);
begin
   if savedlg.execute then
      rsource.Lines.SaveToFile(savedlg.filename);
end;

procedure Tmainform.ButEvalClick(Sender: TObject);     // The math parser
begin
   if mybasic.CompilePchar(pchar('print (' + edit1.text + ')'),nil) = 0 then
      begin
         mybasic.Execute(listbox1.items);              // Easy, isn't it ?
         listbox1.TopIndex := listbox1.items.count-1;
      end;
end;

procedure Tmainform.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
   if key = #13 then ButEvalClick(self);
end;

procedure Tmainform.ButCloneClick(Sender: TObject);
var mform: Tmainform;
begin
   mform := Tmainform.create(application);
   mform.left := mform.left + 32;
   mform.top := mform.top + 32;
   mform.show;
end;

procedure Tmainform.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

end.
