unit unitdem1;

interface         

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, math, ExtCtrls, ComCtrls,
  richedit, Buttons, dbasic;     

type
  TForm1 = class(TForm)    
    Panel1: TPanel;
    sbcoord: TStatusBar;
    rsource: TRichEdit;
    routput: TRichEdit;
    Splitter1: TSplitter;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;            
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    OpenDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure rsourceSelectionChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private              
  public
    mybasic: TDbasic;
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormCreate(Sender: TObject);
begin
   decimalseparator := '.';
   mybasic := tdbasic.create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   mybasic.free;
end;

procedure TForm1.rsourceSelectionChange(Sender: TObject);
var x,y:integer;
begin
  y := SendMessage(rsource.Handle,EM_EXLINEFROMCHAR,0,rsource.SelStart);
  x := rsource.SelStart - SendMessage(rsource.Handle,EM_LINEINDEX,y,0);
  sbcoord.simpletext := Format('Row: %2d   Col: %2d',[y+1,x+1]);
end;                  

procedure TForm1.BitBtn1Click(Sender: TObject);
var
  r: integer;
  l: tstringlist;             
begin
  l := tstringlist.create;
  routput.clear;
  r := mybasic.compile(rsource.lines,nil);
  if r = 0 then mybasic.execute(routput.lines);
  l.free;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
   if opendlg.execute then
      rsource.Lines.LoadFromFile(opendlg.filename);
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
   if savedlg.execute then
      rsource.Lines.SaveToFile(savedlg.filename);
end;

end.
