unit PrintUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DataPrn, Db, DBTables, Buttons, Grids, DBGrids, Printers,
  ExtCtrls, DBCtrls;

type
  TPrintForm = class(TForm)
    ComboBox1: TComboBox;
    Label1: TLabel;
    DBGrid1: TDBGrid;
    SpeedButton1: TSpeedButton;
    Database1: TDatabase;
    Customer: TTable;
    CustomerCustNo: TFloatField;
    CustomerCompany: TStringField;
    CustomerAddr1: TStringField;
    CustomerCity: TStringField;
    CustomerState: TStringField;
    CustomerZip: TStringField;
    CustomerCountry: TStringField;
    CustomerPhone: TStringField;
    CustomerTaxRate: TFloatField;
    CustomerLastInvoiceDate: TDateTimeField;
    DataSource1: TDataSource;
    Employee: TTable;
    EmployeeEmpNo: TIntegerField;
    EmployeeLastName: TStringField;
    EmployeeFirstName: TStringField;
    EmployeePhoneExt: TStringField;
    EmployeeHireDate: TDateTimeField;
    EmployeeSalary: TFloatField;
    Holdings: TTable;
    HoldingsACCT_NBR: TFloatField;
    HoldingsSYMBOL: TStringField;
    HoldingsSHARES: TFloatField;
    HoldingsPUR_PRICE: TFloatField;
    HoldingsPUR_DATE: TDateField;
    Orders: TTable;
    OrdersOrderNo: TFloatField;
    OrdersCustNo: TFloatField;
    OrdersSaleDate: TDateTimeField;
    OrdersTerms: TStringField;
    OrdersPaymentMethod: TStringField;
    OrdersItemsTotal: TCurrencyField;
    OrdersTaxRate: TFloatField;
    OrdersAmountPaid: TCurrencyField;
    Table1: TTable;
    Parts: TTable;
    PartsPartNo: TFloatField;
    PartsVendorNo: TFloatField;
    PartsDescription: TStringField;
    PartsOnHand: TFloatField;
    PartsOnOrder: TFloatField;
    PartsCost: TCurrencyField;
    PartsListPrice: TCurrencyField;
    DataPrinter: TODDataPrinter;
    OrdersQuery: TQuery;
    OrdersQueryOrderNo: TFloatField;
    OrdersQueryCustNo: TFloatField;
    OrdersQuerySaleDate: TDateTimeField;
    OrdersQueryTerms: TStringField;
    OrdersQueryPaymentMethod: TStringField;
    OrdersQueryItemsTotal: TCurrencyField;
    OrdersQueryAmountPaid: TCurrencyField;
    DBNavigator1: TDBNavigator;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    procedure ComboBox1Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure DataPrinterBeforeRowPrint(Sender: TObject;
      var RowTop: Integer);
    procedure DataPrinterAfterFinishPrint(Sender: TObject;
      var RowTop: Integer);
    procedure BitBtn1Click(Sender: TObject);
  private
    CurCustNo: Integer;          //customer group variable
    ItemsTotal, PaidTotal: Double;  //group total variables
    procedure PrintGroupTotals(RowTop: Integer);
  end;

var
  PrintForm: TPrintForm;

implementation

uses AboutDlg;

{$R *.DFM}

procedure TPrintForm.ComboBox1Change(Sender: TObject);
begin
  with DataSource1 do
  begin
    DataSet.Close;
    case ComboBox1.ItemIndex of
      0: DataSet := Customer;
      1: DataSet := Employee;
      2: DataSet := Holdings;
      3: DataSet := Orders;
      4: DataSet := OrdersQuery;
      5: DataSet := Parts;
    end;
    DataSet.Open;
    DataPrinter.DataSet := DataSet;
  end;
  SpeedButton1.Enabled := True;
end;

procedure TPrintForm.SpeedButton1Click(Sender: TObject);
begin
  DataPrinter.Title := ComboBox1.Text;
  DataPrinter.Print;
end;

procedure TPrintForm.PrintGroupTotals(RowTop: Integer);
begin
  //Highlight customers owing 1000 or more
  if ItemsTotal - PaidTotal >= 1000 then
    {Printer.Canvas.Font.Color := clRed}
    Printer.Canvas.Font.Style := [fsBold]
  else
    {Printer.Canvas.Font.Color := DataPrinter.BodyFont.Color;}
    Printer.Canvas.Font.Style := [];
  //This prints outside the component using the printer
  // object which is global to the whole program
  //No check for page end required here - DataPrinter prints col headers before this event
  Printer.Canvas.TextOut(DataPrinter.Margin, RowTop,
    '  Items Total: ' + Format('%*.*f', [6, 2, ItemsTotal]) +
    '  Paid Total: ' + Format('%*.*f', [6, 2, PaidTotal]) +
    '  Outstanding: ' + Format('%*.*f', [6, 2, ItemsTotal - PaidTotal]));
end;

procedure TPrintForm.DataPrinterBeforeRowPrint(Sender: TObject;
  var RowTop: Integer);
begin
  if DataPrinter.DataSet <> OrdersQuery then Exit;
  if CurCustNo <> OrdersQueryCustNo.AsInteger then  //starting a new group
  begin
    if CurCustNo <> 0 then    //if not starting first group
    begin
      PrintGroupTotals(RowTop);  //then first print subtotals of prev group
      //Remember to increment the next row's top to provide for subtotals
      Inc(RowTop, Round(Printer.Canvas.TextHeight('A') * 1.5));  //text height & a gap
    end;
    //Initialize for new group
    CurCustNo := OrdersQueryCustNo.AsInteger;
    ItemsTotal := OrdersQueryItemsTotal.AsFloat;
    PaidTotal := OrdersQueryAmountPaid.AsFloat;
    //Print group header
    Printer.Canvas.Font.Style := [fsBold];
    Printer.Canvas.TextOut(DataPrinter.Margin, RowTop,
      'Customer No: ' + OrdersQueryCustNo.AsString);
    Printer.Canvas.Font.Style := [];
    Inc(RowTop, Printer.Canvas.TextHeight('A'));
  end
  else        //within group so increment group totals
  begin
    ItemsTotal := ItemsTotal + OrdersQueryItemsTotal.AsFloat;
    PaidTotal := PaidTotal + OrdersQueryAmountPaid.AsFloat;
  end;
  //Highlight unpaid order row
  if OrdersQueryAmountPaid.AsFloat + 0.01 < OrdersQueryItemsTotal.AsFloat then
{   Printer.Canvas.Font.Color := clRed}
    Printer.Canvas.Font.Style := [fsBold]
  else
{  Printer.Canvas.Font.Color := DataPrinter.BodyFont.Color;}
   Printer.Canvas.Font.Style := []
end;

procedure TPrintForm.DataPrinterAfterFinishPrint(Sender: TObject;
  var RowTop: Integer);
begin
  if DataPrinter.DataSet <> OrdersQuery then Exit;
  //Check if to start new page
  if RowTop + Printer.Canvas.TextHeight('A') > Printer.PageHeight then
  begin
    Printer.NewPage;       //start new page
    RowTop := 0;
  end;
  //Print group totals for last group
  PrintGroupTotals(RowTop);
  CurCustNo := 0;
end;

procedure TPrintForm.BitBtn1Click(Sender: TObject);
begin
  ODAboutForm.ShowModal;
end;

end.
